/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.ArgsAndTypes;
import dev.nipafx.args.ArgsDefinitionErrorCode;
import dev.nipafx.args.ArgsDefinitionException;
import dev.nipafx.args.ArgsMessage;
import dev.nipafx.args.Check;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class ArgsModeFilter {
    private final List<String> argList = new ArrayList<String>();
    private final List<ArgsMessage> errors = new ArrayList<ArgsMessage>();
    private final List<Class<? extends Record>> recordTypes = new ArrayList<Class<? extends Record>>();
    private boolean actionFound;

    public ArgsAndTypes processModes(String[] argStrings, Class<?>[] types) {
        Check.internalErrorOnNull(argStrings);
        Check.internalErrorOnNull(types);
        this.argList.addAll(List.of(argStrings));
        for (Class<?> type : types) {
            if (type.isRecord()) {
                this.processRecord(type);
                continue;
            }
            if (type.isInterface() && type.isSealed()) {
                this.processSealedInterface(type);
                continue;
            }
            String message = "Types must be records or sealed interfaces with exclusively record implementations, but '%s' isn't.";
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.ILL_DEFINED_ARGS_TYPE, message.formatted(type));
        }
        ArgsAndTypes argsAndTypes = new ArgsAndTypes(List.copyOf(this.argList), List.copyOf(this.recordTypes), List.copyOf(this.errors));
        this.argList.clear();
        this.recordTypes.clear();
        this.errors.clear();
        this.actionFound = false;
        return argsAndTypes;
    }

    private void processRecord(Class<?> type) {
        this.recordTypes.add(type);
    }

    private void processSealedInterface(Class<?> type) {
        if (Set.of("Action", "ActionArgs").contains(type.getSimpleName())) {
            this.processAction(type);
        } else {
            this.processMode(type);
        }
    }

    private void processAction(Class<?> type) {
        if (this.actionFound) {
            String message = "There can only be one action, but %s is the second such interface.".formatted(type);
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.MULTIPLE_ACTIONS, message);
        }
        this.actionFound = true;
        Map<String, Class<? extends Record>> valueTypesByName = ArgsModeFilter.createValuesByTypeName(type);
        if (this.argList.isEmpty()) {
            this.errors.add(new ArgsMessage.MissingAction(valueTypesByName.keySet()));
        } else {
            String value = this.argList.getFirst();
            Class<? extends Record> valueType = valueTypesByName.get(value);
            if (valueType == null) {
                this.errors.add(new ArgsMessage.UnknownAction(valueTypesByName.keySet(), value));
            } else {
                this.argList.removeFirst();
                this.recordTypes.add(valueType);
            }
        }
    }

    private void processMode(Class<?> type) {
        String modeName = ArgsModeFilter.createArgumentName(type);
        Map<String, Class<? extends Record>> valueTypesByName = ArgsModeFilter.createValuesByTypeName(type);
        int argumentIndex = this.argList.indexOf("--" + modeName);
        if (argumentIndex == -1) {
            this.errors.add(new ArgsMessage.MissingArgument(modeName));
        } else {
            String value = this.argList.get(argumentIndex + 1);
            Class<? extends Record> valueType = valueTypesByName.get(value);
            if (valueType == null) {
                this.errors.add(new ArgsMessage.IllegalModeValue(modeName, valueTypesByName.keySet(), value));
            } else {
                this.argList.remove(argumentIndex + 1);
                this.argList.remove(argumentIndex);
                this.recordTypes.add(valueType);
            }
        }
    }

    private static Map<String, Class<? extends Record>> createValuesByTypeName(Class<?> type) {
        return Arrays.stream(type.getPermittedSubclasses()).map(subtype -> {
            if (subtype.isRecord()) {
                return subtype;
            }
            String message = "Types must be records or sealed interfaces with exclusively record implementations, but '%s' isn't.";
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.ILL_DEFINED_ARGS_TYPE, message.formatted(subtype));
        }).collect(Collectors.toMap(ArgsModeFilter::createArgumentName, Function.identity()));
    }

    private static String createArgumentName(Class<?> type) {
        String originalName = type.getSimpleName();
        String argsLessName = originalName.endsWith("Args") ? originalName.substring(0, originalName.length() - 4) : originalName;
        return argsLessName.substring(0, 1).toLowerCase(Locale.US) + argsLessName.substring(1);
    }
}

