/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.Check;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public sealed interface ArgsMessage {
    public String toMessage();

    default public Optional<Throwable> cause() {
        return Optional.empty();
    }

    public record FailedConstruction(Throwable exception) implements ArgsErrorMessage
    {
        public FailedConstruction {
            Check.internalErrorOnNull(exception);
        }

        @Override
        public String toMessage() {
            return "Argument validation failed with an error: \"%s\" (%s)".formatted(this.exception.getMessage(), this.exception.getClass().getSimpleName());
        }

        @Override
        public Optional<Throwable> cause() {
            return Optional.of(this.exception);
        }
    }

    public record UnknownAction(Set<String> allowedValues, String actualValue) implements ArgsErrorMessage
    {
        public UnknownAction {
            Check.internalErrorOnNullOrEmpty(allowedValues);
            allowedValues = Set.copyOf(allowedValues);
            Check.internalErrorOnNullOrBlank(actualValue);
        }

        @Override
        public String toMessage() {
            String allowedNames = this.allowedValues.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
            return "The first provided value '%s' did not match any of the allowed values: [ %s ].".formatted(this.actualValue, allowedNames);
        }
    }

    public record IllegalModeValue(String modeName, Set<String> allowedValues, String actualValue) implements ArgsErrorMessage
    {
        public IllegalModeValue {
            Check.internalErrorOnNullOrBlank(modeName);
            Check.internalErrorOnNullOrEmpty(allowedValues);
            allowedValues = Set.copyOf(allowedValues);
            Check.internalErrorOnNullOrBlank(actualValue);
        }

        @Override
        public String toMessage() {
            String allowedNames = this.allowedValues.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
            return "The value '%s' for argument '--%s' did not match any of the allowed values: [ %s ]".formatted(this.actualValue, this.modeName, allowedNames);
        }
    }

    public record UnexpectedValue(String value) implements ArgsErrorMessage
    {
        public UnexpectedValue {
            Check.internalErrorOnNullOrBlank(value);
        }

        @Override
        public String toMessage() {
            return "At the position of '%s' an argument was expected instead of a value.".formatted(this.value);
        }
    }

    public record IllegalValue(String argumentName, Class<?> argumentType, String value, Throwable parseError) implements ArgsErrorMessage
    {
        public IllegalValue {
            Check.internalErrorOnNullOrBlank(argumentName);
            Check.internalErrorOnNull(argumentType);
            Check.internalErrorOnNullOrBlank(value);
            Check.internalErrorOnNull(parseError);
        }

        @Override
        public String toMessage() {
            return "The value '%s' for argument '--%s' could not be parsed to type '%s': \"%s\" (%s)".formatted(this.value, this.argumentName, this.argumentType.getSimpleName(), this.parseError.getMessage(), this.parseError.getClass().getSimpleName());
        }
    }

    public record MissingAction(Set<String> allowedValues) implements ArgsErrorMessage
    {
        public MissingAction {
            Check.internalErrorOnNullOrEmpty(allowedValues);
            allowedValues = Set.copyOf(allowedValues);
        }

        @Override
        public String toMessage() {
            String allowedNames = this.allowedValues.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
            return "No arguments were provided but at least one is required. The first argument must be one of [ %s ].".formatted(allowedNames);
        }
    }

    public record MissingValue(String argumentName) implements ArgsErrorMessage
    {
        public MissingValue {
            Check.internalErrorOnNullOrBlank(argumentName);
        }

        @Override
        public String toMessage() {
            return "No value was provided for the argument '--%s'.".formatted(this.argumentName);
        }
    }

    public record MissingArgument(String argumentName) implements ArgsErrorMessage
    {
        public MissingArgument {
            Check.internalErrorOnNullOrBlank(argumentName);
        }

        @Override
        public String toMessage() {
            return "The required argument '--%s' was not provided.".formatted(this.argumentName);
        }
    }

    public static sealed interface ArgsErrorMessage
    extends ArgsMessage
    permits MissingArgument, MissingValue, MissingAction, IllegalValue, UnexpectedValue, IllegalModeValue, UnknownAction, FailedConstruction {
    }

    public record UnknownArgument(String argumentName) implements ArgsWarningMessage
    {
        public UnknownArgument {
            Check.internalErrorOnNullOrBlank(argumentName);
        }

        @Override
        public String toMessage() {
            return "The provided argument '--%s' is unknown.".formatted(this.argumentName);
        }
    }

    public static sealed interface ArgsWarningMessage
    extends ArgsMessage
    permits UnknownArgument {
    }
}

