/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.Arg;
import dev.nipafx.args.ArgsAndTypes;
import dev.nipafx.args.ArgsDefinitionErrorCode;
import dev.nipafx.args.ArgsDefinitionException;
import dev.nipafx.args.ArgsMessage;
import dev.nipafx.args.ArgsMessages;
import dev.nipafx.args.ArgsModeFilter;
import dev.nipafx.args.ArgsParseException;
import dev.nipafx.args.ArgsParser;
import dev.nipafx.args.Check;
import dev.nipafx.args.InternalArgsException;
import dev.nipafx.args.Parsed2;
import dev.nipafx.args.Parsed3;
import java.lang.reflect.Constructor;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Args {
    private Args() {
    }

    public static <ARGS_TYPE> ARGS_TYPE parse(String[] argStrings, Class<ARGS_TYPE> type) throws ArgsParseException {
        Args.throwIfAnyIsNull(argStrings, type);
        RecordPackager packager = types -> Args.getFromInstanceMap(types, type);
        return (ARGS_TYPE)Args.parse(argStrings, packager, type);
    }

    public static <ARGS_TYPE_1, ARGS_TYPE_2> Parsed2<ARGS_TYPE_1, ARGS_TYPE_2> parse(String[] argStrings, Class<ARGS_TYPE_1> type1, Class<ARGS_TYPE_2> type2) throws ArgsParseException {
        Args.throwIfAnyIsNull(argStrings, type1, type2);
        RecordPackager packager = types -> new Parsed2(Args.getFromInstanceMap(types, type1), Args.getFromInstanceMap(types, type2));
        return (Parsed2)Args.parse(argStrings, packager, type1, type2);
    }

    public static <ARGS_TYPE_1, ARGS_TYPE_2, ARGS_TYPE_3> Parsed3<ARGS_TYPE_1, ARGS_TYPE_2, ARGS_TYPE_3> parse(String[] argStrings, Class<ARGS_TYPE_1> type1, Class<ARGS_TYPE_2> type2, Class<ARGS_TYPE_3> type3) throws ArgsParseException {
        Args.throwIfAnyIsNull(argStrings, type1, type2, type3);
        RecordPackager packager = types -> new Parsed3(Args.getFromInstanceMap(types, type1), Args.getFromInstanceMap(types, type2), Args.getFromInstanceMap(types, type3));
        return (Parsed3)Args.parse(argStrings, packager, type1, type2, type3);
    }

    private static void throwIfAnyIsNull(String[] argStrings, Class<?> ... types) {
        int i;
        if (argStrings == null) {
            throw new IllegalArgumentException("Argument array must not be null.");
        }
        for (i = 0; i < argStrings.length; ++i) {
            if (argStrings[i] != null) continue;
            throw new IllegalArgumentException("Argument array must not contain null but does at position %s.".formatted(i));
        }
        for (i = 0; i < types.length; ++i) {
            String indexWord;
            switch (i) {
                case 0: {
                    Object object = "first";
                    break;
                }
                case 1: {
                    Object object = "second";
                    break;
                }
                case 2: {
                    Object object = "third";
                    break;
                }
                default: {
                    Object object = indexWord = i - 1 + "th";
                }
            }
            if (types[i] != null) continue;
            throw new IllegalArgumentException("Args type must not be null but %s was.".formatted(indexWord));
        }
    }

    private static <T> T parse(String[] argStrings, RecordPackager<T> packager, Class<?> ... types) throws ArgsParseException {
        try {
            ArgsAndTypes argsAndTypes = new ArgsModeFilter().processModes(argStrings, types);
            Args.throwOnErrors(argsAndTypes.errors());
            InferredArgs args = Args.inferArgs(argsAndTypes.types());
            ArgsMessages messages = ArgsParser.forArgs(args.all().toList()).parse(argsAndTypes.argsStrings());
            Args.throwOnErrors(messages.errors(), messages.warnings());
            List<ConstructorArguments> constructorArguments = Args.prepareConstructions(args);
            List<ArgsMessage> constructorErrors = constructorArguments.stream().flatMap(constrArg -> constrArg.errors.stream()).toList();
            Args.throwOnErrors(constructorErrors);
            Constructions constructions = Args.constructArgTypes(constructorArguments);
            Args.throwOnErrors(constructions.errors());
            return (T)packager.apply(constructions.argInstances());
        }
        catch (InternalArgsException ex) {
            throw new ArgsParseException(argStrings, List.of(types), ex);
        }
    }

    private static InferredArgs inferArgs(List<Class<? extends Record>> types) {
        Map<Class<? extends Record>, List<Arg<?>>> argsByType = types.stream().map(type -> Map.entry(type, Arrays.stream(type.getRecordComponents()).map(Args::readComponent).toList())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Args.ensureArgUniqueness(argsByType);
        return new InferredArgs(argsByType);
    }

    private static void ensureArgUniqueness(Map<Class<? extends Record>, List<Arg<?>>> argsByType) {
        record ArgAndRecordType(String name, Class<? extends Record> recordType) {
        }
        List allArgs = argsByType.entrySet().stream().flatMap(recordWithArgs -> ((List)recordWithArgs.getValue()).stream().map(arg -> new ArgAndRecordType(arg.name(), (Class)recordWithArgs.getKey()))).toList();
        HashMap<String, ArgAndRecordType> uniqueArgs = new HashMap<String, ArgAndRecordType>();
        ArrayList<String> errors = new ArrayList<String>();
        for (ArgAndRecordType arg : allArgs) {
            if (uniqueArgs.containsKey(arg.name())) {
                String message = "Duplicate arg '%s' in types '%s' and '%s'.".formatted(arg.name(), ((ArgAndRecordType)uniqueArgs.get(arg.name())).recordType().getName(), arg.recordType().getName());
                errors.add(message);
                continue;
            }
            uniqueArgs.put(arg.name(), arg);
        }
        if (!errors.isEmpty()) {
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.DUPLICATE_ARGUMENT_DEFINITION, String.join((CharSequence)"\n", errors));
        }
    }

    private static Arg<?> readComponent(RecordComponent component) {
        return Arg.of(component.getName(), component.getGenericType());
    }

    private static List<ConstructorArguments> prepareConstructions(InferredArgs args) {
        return args.allByType().map(entry -> Args.prepareConstruction((Class)entry.getKey(), (List)entry.getValue())).toList();
    }

    private static ConstructorArguments prepareConstruction(Class<? extends Record> type, List<Arg<?>> args) {
        ArrayList<ArgsMessage> errors = new ArrayList<ArgsMessage>();
        Class[] parameters = (Class[])args.stream().map(Arg::type).toArray(Class[]::new);
        Object[] arguments = args.stream().map(arg -> {
            if (arg.value().isEmpty()) {
                errors.add(new ArgsMessage.MissingArgument(arg.name()));
                return null;
            }
            return arg.value().get();
        }).toArray(Object[]::new);
        return new ConstructorArguments(type, parameters, arguments, errors);
    }

    private static Constructions constructArgTypes(List<ConstructorArguments> constructors) {
        HashMap<Class<? extends Record>, Record> argInstances = new HashMap<Class<? extends Record>, Record>();
        ArrayList<ArgsMessage> errors = new ArrayList<ArgsMessage>();
        for (ConstructorArguments constr : constructors) {
            Construction<? extends Record> construction = Args.constructArgType(constr.argType(), constr.parameters(), constr.arguments());
            construction.instance().ifPresent(argInstance -> argInstances.put(constr.argType(), (Record)argInstance));
            errors.addAll(construction.errors());
        }
        return new Constructions(argInstances, errors);
    }

    private static <T extends Record> Construction<T> constructArgType(Class<T> type, Class<?>[] parameters, Object[] arguments) {
        try {
            Constructor<T> canonicalConstructor = type.getDeclaredConstructor(parameters);
            canonicalConstructor.setAccessible(true);
            return Construction.successful((Record)canonicalConstructor.newInstance(arguments));
        }
        catch (NoSuchMethodException ex) {
            String message = "The canonical constructor for %s could not be found - presumably it has these parameters: %s".formatted(type, Arrays.toString(parameters));
            throw new IllegalStateException(message, ex);
        }
        catch (IllegalArgumentException ex) {
            String message = "Could not invoke the canonical constructor for %s with these arguments: %s".formatted(type, Arrays.toString(arguments));
            throw new IllegalStateException(message, ex);
        }
        catch (InstantiationException ex) {
            String message = "Apparently, %s is abstract, which should've been caught earlier.".formatted(type);
            throw new IllegalStateException(message, ex);
        }
        catch (IllegalAccessException | InaccessibleObjectException ex) {
            String message = "Make sure Args has reflective access to the args record %s, e.g. with an `opens ... to ...` directive.".formatted(type);
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.ILLEGAL_ACCESS, message, ex);
        }
        catch (ExceptionInInitializerError ex) {
            String message = "Invoking the constructor of %s caused an exception in the static initializer.".formatted(type);
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.FAULTY_STATIC_INITIALIZER, message, ex);
        }
        catch (InvocationTargetException ex) {
            return Construction.failed(new ArgsMessage.FailedConstruction(ex.getTargetException()));
        }
    }

    private static void throwOnErrors(List<ArgsMessage> errors) {
        Args.throwOnErrors(errors, List.of());
    }

    private static void throwOnErrors(List<ArgsMessage> errors, List<ArgsMessage> warnings) {
        if (errors.isEmpty() && warnings.isEmpty()) {
            return;
        }
        ArrayList<ArgsMessage> messages = new ArrayList<ArgsMessage>(errors);
        messages.addAll(warnings);
        throw new InternalArgsException(messages);
    }

    private static <ARGS_TYPE> ARGS_TYPE getFromInstanceMap(Map<Class<? extends Record>, Record> instanceMap, Class<ARGS_TYPE> type) {
        if (instanceMap.containsKey(type)) {
            return (ARGS_TYPE)instanceMap.get(type);
        }
        return (ARGS_TYPE)Arrays.stream(type.getPermittedSubclasses()).filter(instanceMap::containsKey).map(instanceMap::get).map(instance -> instance).findAny().orElseThrow(() -> new IllegalStateException("There should've been an instance of a subtype of '%s'. \ud83e\udd14".formatted(type)));
    }

    private static interface RecordPackager<T>
    extends Function<Map<Class<? extends Record>, Record>, T> {
    }

    private static class InferredArgs {
        private final Map<Class<? extends Record>, List<Arg<?>>> argsByType;

        private InferredArgs(Map<Class<? extends Record>, List<Arg<?>>> argsByType) {
            this.argsByType = argsByType;
        }

        public Stream<Arg<?>> all() {
            return this.argsByType.values().stream().flatMap(Collection::stream);
        }

        public Stream<Map.Entry<Class<? extends Record>, List<Arg<?>>>> allByType() {
            return this.argsByType.entrySet().stream();
        }
    }

    private record Constructions(Map<Class<? extends Record>, Record> argInstances, List<ArgsMessage> errors) {
        Constructions {
            argInstances = Map.copyOf(Check.internalErrorOnNull(argInstances));
            errors = List.copyOf((Collection)Check.internalErrorOnNull(errors));
        }
    }

    private record ConstructorArguments(Class<? extends Record> argType, Class<?>[] parameters, Object[] arguments, List<ArgsMessage> errors) {
    }

    private record Construction<T extends Record>(Optional<T> instance, List<ArgsMessage> errors) {
        private Construction {
            Check.internalErrorOnNull(instance);
            errors = List.copyOf((Collection)Check.internalErrorOnNull(errors));
            if (instance.isEmpty() && errors.isEmpty()) {
                throw new IllegalStateException("Construction yielded neither instance nor errors.");
            }
        }

        public static <T extends Record> Construction<T> successful(T instance) {
            return new Construction<T>(Optional.of(Check.internalErrorOnNull(instance)), List.of());
        }

        public static <T extends Record> Construction<T> failed(ArgsMessage ... errors) {
            return new Construction(Optional.empty(), List.of(errors));
        }
    }
}

