/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.Arg;
import dev.nipafx.args.ArgsDefinitionErrorCode;
import dev.nipafx.args.ArgsDefinitionException;
import dev.nipafx.args.Check;
import dev.nipafx.args.ListArg;
import dev.nipafx.args.MapArg;
import dev.nipafx.args.OptionalArg;
import dev.nipafx.args.SimpleArg;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;

abstract class AbstractArg<T> {
    private static final Set<Class<?>> SUPPORTED_TYPES = Set.of(String.class, Path.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE);
    private final String name;
    private final Class<T> type;

    protected AbstractArg(String name, Class<T> type) {
        this.name = Check.internalErrorOnNullOrBlank(name);
        this.type = Check.internalErrorOnNull(type);
    }

    static <T> Arg<T> of(String name, Type type) {
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class}, (Object)type2, n)) {
            case 0 -> {
                Class classType = (Class)type2;
                yield new SimpleArg<T>(name, AbstractArg.assertSupported(classType));
            }
            case 1 -> {
                ParameterizedType paramType = (ParameterizedType)type2;
                switch (paramType.getRawType().getTypeName()) {
                    case "java.util.Optional": {
                        Type valueType = paramType.getActualTypeArguments()[0];
                        if (valueType instanceof Class) {
                            Class classType = (Class)valueType;
                            yield new OptionalArg<T>(name, AbstractArg.assertSupported(classType));
                        }
                        throw AbstractArg.unexpectedArgumentException(type);
                    }
                    case "java.util.List": {
                        Type valueType = paramType.getActualTypeArguments()[0];
                        if (valueType instanceof Class) {
                            Class classType = (Class)valueType;
                            yield new ListArg<T>(name, AbstractArg.assertSupported(classType));
                        }
                        throw AbstractArg.unexpectedArgumentException(type);
                    }
                    case "java.util.Map": {
                        Type keyType = paramType.getActualTypeArguments()[0];
                        Type valueType = paramType.getActualTypeArguments()[1];
                        if (keyType instanceof Class) {
                            Class keyClass = (Class)keyType;
                            if (valueType instanceof Class) {
                                Class valueClass = (Class)valueType;
                                yield new MapArg<T, T>(name, AbstractArg.assertSupported(keyClass), AbstractArg.assertSupported(valueClass));
                            }
                        }
                        throw AbstractArg.unexpectedArgumentException(type);
                    }
                }
                throw AbstractArg.unexpectedArgumentException(type);
            }
            default -> throw AbstractArg.unexpectedArgumentException(type);
        };
    }

    private static IllegalArgumentException unexpectedArgumentException(Type type) {
        String message = "Unexpected argument type '%s'.".formatted(type);
        return new IllegalArgumentException(message);
    }

    private static <T> Class<T> assertSupported(Class<T> type) {
        if (!SUPPORTED_TYPES.contains(type)) {
            String message = "Argument type %s is not supported.".formatted(type.getSimpleName());
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.UNSUPPORTED_ARGUMENT_TYPE, message);
        }
        return type;
    }

    protected static <T> T parseValueToType(String value, Class<T> type) {
        return (T)(switch (type.getSimpleName()) {
            case "String" -> value;
            case "Path" -> Path.of(value, new String[0]);
            case "Integer", "int" -> Integer.parseInt(value);
            case "Long", "long" -> Long.parseLong(value);
            case "Float", "float" -> Float.valueOf(Float.parseFloat(value));
            case "Double", "double" -> Double.parseDouble(value);
            case "Boolean", "boolean" -> {
                boolean v1 = switch (value) {
                    case "true" -> true;
                    case "false" -> false;
                    default -> throw new IllegalArgumentException("Only 'true' and 'false' allowed for boolean args.");
                };
                yield v1;
            }
            default -> {
                String message = "The unsupported argument type %s (with value '%s') was encountered after those should already have been detected.";
                throw new IllegalStateException(message.formatted(type, value));
            }
        });
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    public final boolean equals(Object other) {
        Arg arg;
        return this == other || other instanceof Arg && this.name.equals((arg = (Arg)other).name());
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }
}

