/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.Arg;
import dev.nipafx.args.ArgsMessage;
import dev.nipafx.args.ArgsMessages;
import dev.nipafx.args.ArgsParseErrorCode;
import dev.nipafx.args.Check;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

class ArgsParser {
    private State state;
    private final List<Arg<?>> args;
    private final List<ArgsMessage> mutableErrors;
    private final List<ArgsMessage> mutableWarnings;

    private ArgsParser(List<Arg<?>> args) {
        this.args = List.copyOf((Collection)Check.internalErrorOnNull(args));
        this.mutableErrors = new ArrayList<ArgsMessage>();
        this.mutableWarnings = new ArrayList<ArgsMessage>();
        this.state = new ExpectingName();
    }

    static ArgsParser forArgs(List<Arg<?>> args) {
        return new ArgsParser(args);
    }

    public ArgsMessages parse(List<String> argStrings) {
        Check.internalErrorOnNull(argStrings);
        for (String argString : argStrings) {
            this.state = this.state.transition(argString);
        }
        this.state.finish();
        return new ArgsMessages(List.copyOf(this.mutableErrors), List.copyOf(this.mutableWarnings));
    }

    private final class ExpectingName
    extends GeneralState {
        private ExpectingName() {
        }

        @Override
        public State transition(String argString) {
            return this.transition(argString, x$0 -> new ExpectingValue((Arg<?>)x$0), unknownArgName -> new IgnoringValue(), string -> {
                String message = "Expected an option but got argument '%s' instead.".formatted(string);
                ArgsParser.this.mutableErrors.add(new ArgsMessage(ArgsParseErrorCode.UNEXPECTED_VALUE, message));
                return this;
            });
        }
    }

    private static interface State {
        public State transition(String var1);

        public void finish();
    }

    private final class IgnoringValue
    extends GeneralState {
        private IgnoringValue() {
        }

        @Override
        public State transition(String argString) {
            return new ExpectingName();
        }
    }

    private final class ExpectingNameOrAdditionalValue
    extends GeneralState {
        private final Arg<?> currentArg;

        ExpectingNameOrAdditionalValue(Arg<?> currentArg) {
            this.currentArg = Check.internalErrorOnNull(currentArg);
        }

        @Override
        public State transition(String argString) {
            return this.transition(argString, x$0 -> new ExpectingValue((Arg<?>)x$0), unknownArgName -> new IgnoringValue(), string -> {
                this.setValue(this.currentArg, (String)string);
                return this;
            });
        }
    }

    private final class ExpectingValue
    extends GeneralState {
        private final Arg<?> currentArg;

        ExpectingValue(Arg<?> currentArg) {
            this.currentArg = Check.internalErrorOnNull(currentArg);
        }

        @Override
        public State transition(String argString) {
            return this.transition(argString, arg -> {
                this.processMissingValue();
                return new ExpectingValue((Arg<?>)arg);
            }, unknownArgName -> new IgnoringValue(), string -> {
                this.setValue(this.currentArg, (String)string);
                return this.currentArg.type() == List.class | this.currentArg.type() == Map.class ? new ExpectingNameOrAdditionalValue(this.currentArg) : new ExpectingName();
            });
        }

        private void processMissingValue() {
            if (this.currentArg.type() == Boolean.class || this.currentArg.type() == Boolean.TYPE) {
                this.setValue(this.currentArg, "true");
            } else {
                String message = "No value was assigned to arg '%s'.".formatted(this.currentArg.name());
                ArgsParser.this.mutableErrors.add(new ArgsMessage(ArgsParseErrorCode.MISSING_VALUE, message));
            }
        }

        @Override
        public void finish() {
            this.processMissingValue();
        }
    }

    private abstract class GeneralState
    implements State {
        private GeneralState() {
        }

        protected final Optional<String> asArgName(String argString) {
            return argString.startsWith("--") ? Optional.of(argString.substring(2)) : Optional.empty();
        }

        protected final Optional<Arg<?>> findArgument(String argName) {
            return ArgsParser.this.args.stream().filter(arg -> arg.name().equals(argName)).findFirst();
        }

        protected final State transitionToArgumentState(String argName, Function<Arg<?>, ? extends State> createStateForArg, Function<String, ? extends State> createStateForUnknownArg) {
            return this.findArgument(argName).map(createStateForArg).orElseGet(() -> {
                String message = "Encountered name of unknown argument '%s'.".formatted(argName);
                ArgsParser.this.mutableWarnings.add(new ArgsMessage(ArgsParseErrorCode.UNKNOWN_ARGUMENT, message));
                return (State)createStateForUnknownArg.apply(argName);
            });
        }

        protected final State transition(String argString, Function<Arg<?>, ? extends State> createStateForArg, Function<String, ? extends State> createStateForUnknownArg, Function<String, ? extends State> createStateForValue) {
            return this.asArgName(argString).map(argName -> this.transitionToArgumentState((String)argName, createStateForArg, createStateForUnknownArg)).orElseGet(() -> (State)createStateForValue.apply(argString));
        }

        protected final void setValue(Arg<?> arg, String argString) {
            try {
                arg.setValue(argString);
            }
            catch (IllegalArgumentException ex) {
                String message = "Value '%s' could not be parsed to '%s's type %s.".formatted(argString, arg.name(), arg.type().getSimpleName());
                ArgsParser.this.mutableErrors.add(new ArgsMessage(ArgsParseErrorCode.UNPARSEABLE_VALUE, message, ex));
            }
        }

        @Override
        public void finish() {
        }
    }
}

