/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.ArgsAndTypes;
import dev.nipafx.args.ArgsDefinitionErrorCode;
import dev.nipafx.args.ArgsDefinitionException;
import dev.nipafx.args.ArgsMessage;
import dev.nipafx.args.ArgsParseErrorCode;
import dev.nipafx.args.Check;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class ArgsModeFilter {
    private final List<String> argList = new ArrayList<String>();
    private final List<ArgsMessage> errors = new ArrayList<ArgsMessage>();
    private final List<Class<? extends Record>> recordTypes = new ArrayList<Class<? extends Record>>();
    private boolean actionFound;

    public ArgsAndTypes processModes(String[] argStrings, Class<?>[] types) {
        Check.internalErrorOnNull(argStrings);
        Check.internalErrorOnNull(types);
        this.argList.addAll(List.of(argStrings));
        for (Class<?> type : types) {
            if (type.isRecord()) {
                this.processRecord(type);
                continue;
            }
            if (type.isInterface() && type.isSealed()) {
                this.processSealedInterface(type);
                continue;
            }
            String message = "Types must be records or sealed interfaces with exclusively record implementations, but '%s' isn't.";
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.ILL_DEFINED_ARGS_TYPE, message.formatted(type));
        }
        ArgsAndTypes argsAndTypes = new ArgsAndTypes(List.copyOf(this.argList), List.copyOf(this.recordTypes), List.copyOf(this.errors));
        this.argList.clear();
        this.recordTypes.clear();
        this.errors.clear();
        this.actionFound = false;
        return argsAndTypes;
    }

    private void processRecord(Class<?> type) {
        this.recordTypes.add(type);
    }

    private void processSealedInterface(Class<?> type) {
        if (Set.of("Action", "ActionArgs").contains(type.getSimpleName())) {
            this.processAction(type);
        } else {
            this.processMode(type);
        }
    }

    private void processAction(Class<?> type) {
        if (this.actionFound) {
            String message = "There can only be one action, but %s is the second such interface.".formatted(type);
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.MULTIPLE_ACTIONS, message);
        }
        this.actionFound = true;
        Map<String, Class<? extends Record>> valueTypesByName = ArgsModeFilter.createValuesByTypeName(type);
        String allowedValues = valueTypesByName.keySet().stream().collect(Collectors.joining("', '", "'", "'"));
        if (this.argList.size() == 0) {
            String message = "No arguments provided - first argument must be one of [ %s ].".formatted(allowedValues);
            this.errors.add(new ArgsMessage(ArgsParseErrorCode.FAULTY_ACTION, message));
        } else {
            String value = this.argList.get(0);
            Class<? extends Record> valueType = valueTypesByName.get(value);
            if (valueType == null) {
                String message = "First argument '%s' did not match any of the allowed values: [ %s ].".formatted(value, allowedValues);
                this.errors.add(new ArgsMessage(ArgsParseErrorCode.FAULTY_ACTION, message));
            } else {
                this.argList.remove(0);
                this.recordTypes.add(valueType);
            }
        }
    }

    private void processMode(Class<?> type) {
        String argumentName = "--" + ArgsModeFilter.createArgumentName(type);
        Map<String, Class<? extends Record>> valueTypesByName = ArgsModeFilter.createValuesByTypeName(type);
        int argumentIndex = this.argList.indexOf(argumentName);
        if (argumentIndex == -1) {
            String message = "No value for required argument '%s'.".formatted(argumentName);
            this.errors.add(new ArgsMessage(ArgsParseErrorCode.MISSING_ARGUMENT, message));
        } else if (argumentIndex == this.argList.size()) {
            String message = "No value for required argument '%s'.".formatted(argumentName);
            this.errors.add(new ArgsMessage(ArgsParseErrorCode.MISSING_ARGUMENT, message));
        } else {
            String value = this.argList.get(argumentIndex + 1);
            Class<? extends Record> valueType = valueTypesByName.get(value);
            if (valueType == null) {
                String allowedValues = valueTypesByName.keySet().stream().collect(Collectors.joining("', '", "'", "'"));
                String message = "Value '%s' did not match any of the values allowed for '%s': [ %s ].".formatted(value, argumentName, allowedValues);
                this.errors.add(new ArgsMessage(ArgsParseErrorCode.UNPARSEABLE_VALUE, message));
            } else {
                this.argList.remove(argumentIndex + 1);
                this.argList.remove(argumentIndex);
                this.recordTypes.add(valueType);
            }
        }
    }

    private static Map<String, Class<? extends Record>> createValuesByTypeName(Class<?> type) {
        return Arrays.stream(type.getPermittedSubclasses()).map(subtype -> {
            if (subtype.isRecord()) {
                return subtype;
            }
            String message = "Types must be records or sealed interfaces with exclusively record implementations, but '%s' isn't.";
            throw new ArgsDefinitionException(ArgsDefinitionErrorCode.ILL_DEFINED_ARGS_TYPE, message.formatted(subtype));
        }).collect(Collectors.toMap(ArgsModeFilter::createArgumentName, Function.identity()));
    }

    private static String createArgumentName(Class<?> type) {
        String originalName = type.getSimpleName();
        String argsLessName = originalName.endsWith("Args") ? originalName.substring(0, originalName.length() - 4) : originalName;
        return argsLessName.substring(0, 1).toLowerCase(Locale.US) + argsLessName.substring(1);
    }
}

