/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.ArgsParseErrorCode;
import dev.nipafx.args.Check;
import java.util.Optional;

public record ArgsMessage(ArgsParseErrorCode code, String message, Optional<Throwable> cause) {
    public ArgsMessage {
        Check.internalErrorOnNull(code);
        Check.internalErrorOnNull(message);
        Check.internalErrorOnNull(cause);
    }

    ArgsMessage(ArgsParseErrorCode code, String message) {
        this(code, message, Optional.empty());
    }

    ArgsMessage(ArgsParseErrorCode code, String message, Throwable cause) {
        this(code, message, Optional.of(cause));
    }

    @Override
    public String toString() {
        Object string = "%s: %s".formatted(new Object[]{this.code, this.message});
        if (this.cause.isPresent()) {
            string = (String)string + " (%s)".formatted(this.cause.get().getMessage());
        }
        return string;
    }
}

