/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.security.encryption;

import dev.netcode.security.encryption.AESEncrypter;
import dev.netcode.security.encryption.RSAEncrypter;
import dev.netcode.util.Result;
import dev.netcode.util.StringUtils;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class KeyGenerator {
    public static boolean generateKeys(int size, Path publicKeyFile, Path privateKeyFile) {
        if (!KeyGenerator.isPowerOfTwo(size)) {
            throw new IllegalArgumentException("Size must be a power of 2");
        }
        KeyPair keyPair = RSAEncrypter.generateKeyPair(size);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        String publicKeyString = "-----BEGIN PUBLIC KEY-----\n" + new String(StringUtils.chunkInsert((String)new String(Base64.getEncoder().encode(x509EncodedKeySpec.getEncoded())), (int)64, (char)'\n')) + "-----END PUBLIC KEY-----";
        if (!StringUtils.saveToFile((Path)publicKeyFile, (String)publicKeyString)) {
            return false;
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        String privateKeyString = "-----BEGIN PRIVATE KEY-----\n" + new String(StringUtils.chunkInsert((String)new String(Base64.getEncoder().encode(pkcs8EncodedKeySpec.getEncoded())), (int)64, (char)'\n')) + "-----END PRIVATE KEY-----";
        return StringUtils.saveToFile((Path)privateKeyFile, (String)privateKeyString);
    }

    public static boolean generateKeys(int size, Path publicKeyFile, Path privateKeyFile, String password) {
        if (!KeyGenerator.isPowerOfTwo(size)) {
            throw new IllegalArgumentException("Size must be a power of 2");
        }
        KeyPair keyPair = RSAEncrypter.generateKeyPair(size);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        String publicKeyString = "-----BEGIN PUBLIC KEY-----\n" + new String(StringUtils.chunkInsert((String)new String(Base64.getEncoder().encode(x509EncodedKeySpec.getEncoded())), (int)64, (char)'\n')) + "-----END PUBLIC KEY-----";
        Result<String> encrypted = AESEncrypter.encrypt(publicKeyString, password);
        if (!encrypted.wasSuccessful()) {
            return false;
        }
        if (!StringUtils.saveToFile((Path)publicKeyFile, (String)((String)encrypted.get()))) {
            return false;
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        String privateKeyString = "-----BEGIN PRIVATE KEY-----\n" + new String(StringUtils.chunkInsert((String)new String(Base64.getEncoder().encode(pkcs8EncodedKeySpec.getEncoded())), (int)64, (char)'\n')) + "-----END PRIVATE KEY-----";
        encrypted = AESEncrypter.encrypt(privateKeyString, password);
        if (!encrypted.wasSuccessful()) {
            return false;
        }
        return StringUtils.saveToFile((Path)privateKeyFile, (String)((String)encrypted.get()));
    }

    private static boolean isPowerOfTwo(int x) {
        return x != 0 && (x & x - 1) == 0;
    }
}

