/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.security.encryption;

import dev.netcode.security.encryption.Base58;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAEncrypter {
    public static KeyPair generateKeyPair(int size) {
        KeyPairGenerator keygen = null;
        try {
            keygen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keygen.initialize(size, new SecureRandom());
        return keygen.generateKeyPair();
    }

    public static String decrypt(byte[] cipher, PrivateKey privateKey) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] dec = new byte[]{};
        Cipher c = null;
        try {
            c = Cipher.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        c.init(2, privateKey);
        dec = c.doFinal(cipher);
        return new String(dec, StandardCharsets.UTF_8);
    }

    public static byte[] encrypt(String message, PublicKey publicKey) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = null;
        byte[] encrypted = null;
        try {
            cipher = Cipher.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        cipher.init(1, publicKey);
        encrypted = cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
        return encrypted;
    }

    public static String sign(PrivateKey privateKey, String input) throws InvalidKeyException, SignatureException {
        Signature privateSignature = null;
        try {
            privateSignature = Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        privateSignature.initSign(privateKey);
        privateSignature.update(input.getBytes(StandardCharsets.UTF_8));
        byte[] signature = privateSignature.sign();
        return Base64.getEncoder().encodeToString(signature);
    }

    public static boolean verifySignature(PublicKey publicKey, String data, String signature) {
        try {
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = Base64.getDecoder().decode(signature);
            return publicSignature.verify(signatureBytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PublicKey generatePublicKeyFromString(byte[] key) throws InvalidKeySpecException {
        KeyFactory kf;
        X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(key);
        try {
            kf = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return kf.generatePublic(X509publicKey);
    }

    public static PrivateKey generatePrivateKeyFromString(byte[] key) throws InvalidKeySpecException {
        KeyFactory kf;
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key);
        try {
            kf = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return kf.generatePrivate(pkcs8EncodedKeySpec);
    }

    public static String keyToString(Key key) {
        if (key == null) {
            return "null";
        }
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String getFingerprint(PublicKey key) {
        try {
            X509EncodedKeySpec pubkeyspec = new X509EncodedKeySpec(key.getEncoded());
            return Base58.encode(MessageDigest.getInstance("SHA-1").digest(pubkeyspec.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

