/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.security.identity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.netcode.security.encryption.AESEncrypter;
import dev.netcode.security.encryption.RSAEncrypter;
import dev.netcode.security.identity.Signature;
import dev.netcode.util.Result;
import dev.netcode.util.StringUtils;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;

public class Identity {
    private String possessor;
    private String publicKey;
    private String privateKey;
    private String identityID;
    private HashMap<String, String> data;
    private Signature signature;
    private transient KeyPair keyPair;

    public Identity(String possessor, HashMap<String, String> data, String password) {
        this.possessor = possessor;
        this.data = data;
        this.keyPair = RSAEncrypter.generateKeyPair(4096);
        this.publicKey = RSAEncrypter.keyToString(this.keyPair.getPublic());
        this.privateKey = (String)AESEncrypter.encrypt(RSAEncrypter.keyToString(this.keyPair.getPrivate()), password).get();
        this.identityID = RSAEncrypter.getFingerprint(this.keyPair.getPublic());
    }

    public static Identity load(Path path) {
        try {
            if (!path.toFile().exists()) {
                throw new FileNotFoundException("File \"" + path.toFile().getAbsolutePath() + "\" doesn't exist");
            }
            String fileContent = new String(Files.readAllBytes(path));
            return (Identity)new Gson().fromJson(fileContent, Identity.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Identity from file: " + e.getMessage());
        }
    }

    public boolean save(Path path) {
        try {
            Gson gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String identityString = new String(gsonBuilder.toJson((Object)this).getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(path.toFile()));
            fileWriter.write(identityString);
            fileWriter.close();
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save Identity to file: " + e.getMessage());
        }
    }

    public boolean unlock(String password) {
        Result<String> result = AESEncrypter.decrypt(this.privateKey, password);
        if (result.wasSuccessful()) {
            this.keyPair = new KeyPair(RSAEncrypter.generatePublicKeyFromString(Base64.getDecoder().decode(this.publicKey)), RSAEncrypter.generatePrivateKeyFromString(Base64.getDecoder().decode((String)result.get())));
            return true;
        }
        return false;
    }

    public boolean isValid(PublicKey publicKey) {
        if (this.signature == null) {
            return false;
        }
        return this.signature.isValid(publicKey, this);
    }

    public boolean isUnlocked() {
        return this.keyPair != null;
    }

    public String getHash() {
        return StringUtils.applySha256((String)(this.identityID + this.possessor + new Gson().toJson(this.data)));
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public String toIndentedString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    public String getPossessor() {
        return this.possessor;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getIdentityID() {
        return this.identityID;
    }

    public HashMap<String, String> getData() {
        return this.data;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }
}

