/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.plugin;

import dev.netcode.plugin.Plugin;
import dev.netcode.util.LogLevel;
import dev.netcode.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PluginManager {
    private BiConsumer<LogLevel, String> logFunction;
    private ArrayList<Plugin> plugins = new ArrayList();

    public PluginManager(BiConsumer<LogLevel, String> logFunction) {
        this.logFunction = logFunction;
    }

    public void start() {
        if (!new File("plugins").exists()) {
            new File("plugins").mkdir();
        }
        File[] files = new File("plugins").listFiles();
        for (File f : files) {
            this.loadPlugin(f);
        }
        for (Plugin p : this.plugins) {
            p.start();
        }
        this.logFunction.accept(LogLevel.INFO, this.plugins.size() + " Plugin(s) loaded!");
    }

    public void loadPlugin(File file) {
        if (StringUtils.getFileExtension((File)file).equalsIgnoreCase("jar")) {
            try {
                JarFile f = new JarFile("plugins" + File.separator + file.getName());
                Manifest manifest = f.getManifest();
                Attributes attrib = manifest.getMainAttributes();
                String main = attrib.getValue(Attributes.Name.MAIN_CLASS);
                Class<?> cl = new URLClassLoader(new URL[]{file.toURI().toURL()}).loadClass(main);
                Class<?>[] interfaces = cl.getInterfaces();
                boolean isPlugin = false;
                for (Class<?> intf : interfaces) {
                    if (!intf.getName().contentEquals("dev.netcode.plugin.Plugin")) continue;
                    isPlugin = true;
                }
                if (isPlugin) {
                    Plugin plugin = (Plugin)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.plugins.add(plugin);
                }
                f.close();
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logFunction.accept(LogLevel.ERROR, "Error while loading Plugin: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public int getPluginCount() {
        return this.plugins.size();
    }

    public void stop() {
        for (Plugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    public void clearPlugins() {
        this.plugins.clear();
    }
}

