/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain.util;

import dev.netcode.blockchain.Transaction;
import dev.netcode.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Utils {
    public static String getMerkleRoot(ArrayList<Transaction> transactions) {
        List previousTreeLayer;
        int count = transactions.size();
        List treeLayer = previousTreeLayer = transactions.stream().map(Transaction::getHash).collect(Collectors.toList());
        while (count > 1) {
            treeLayer = new ArrayList();
            for (int i = 1; i < previousTreeLayer.size(); ++i) {
                treeLayer.add(StringUtils.applySha256((String)((String)previousTreeLayer.get(i - 1) + (String)previousTreeLayer.get(i))));
            }
            count = treeLayer.size();
            previousTreeLayer = treeLayer;
        }
        String merkleRoot = treeLayer.size() == 1 ? (String)treeLayer.get(0) : "";
        return merkleRoot;
    }
}

