/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.blockchain.Transaction;
import dev.netcode.blockchain.TransactionBlockChain;
import dev.netcode.blockchain.TransactionInput;
import dev.netcode.blockchain.TransactionOutput;
import dev.netcode.blockchain.exceptions.InsufficientBalanceException;
import dev.netcode.security.encryption.RSAEncrypter;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Wallet {
    private KeyPair keyPair = RSAEncrypter.generateKeyPair((int)4096);
    private String walletID = RSAEncrypter.getFingerprint((PublicKey)this.keyPair.getPublic());
    private Map<String, TransactionOutput> UTXOs = new HashMap<String, TransactionOutput>();

    public Transaction createTransaction(TransactionBlockChain blockchain, String recipient, double value) throws InsufficientBalanceException {
        if (this.getBalance() < value) {
            throw new InsufficientBalanceException();
        }
        ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
        double total = 0.0;
        for (Map.Entry<String, TransactionOutput> entry : this.UTXOs.entrySet()) {
            TransactionOutput output = entry.getValue();
            total += output.getValue();
            inputs.add(new TransactionInput(output.getID()));
            if (!(total >= value)) continue;
            break;
        }
        Transaction transaction = new Transaction(this.keyPair.getPublic(), recipient, value, inputs);
        transaction.setSignature(this.sign(transaction.getData()));
        inputs.forEach(i -> this.UTXOs.remove(i.getTransactionOutputID()));
        return transaction;
    }

    public void updateBalance(TransactionBlockChain blockchain) {
        this.UTXOs = blockchain.getUTXOs(this.walletID);
    }

    private String sign(String data) {
        try {
            return RSAEncrypter.sign((PrivateKey)this.keyPair.getPrivate(), (String)data);
        }
        catch (InvalidKeyException | SignatureException e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getBalance() {
        return this.UTXOs.entrySet().stream().mapToDouble(i -> ((TransactionOutput)i.getValue()).getValue()).sum();
    }

    public String getWalletID() {
        return this.walletID;
    }
}

