/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.util.StringUtils;
import lombok.NonNull;

public class TransactionOutput {
    private static int UID;
    private int nonce;
    private String ID;
    private String recipient;
    private double value;
    private String parentTransactionID;

    public TransactionOutput(@NonNull String recipient, double value, String parentTransactionID) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.recipient = recipient;
        this.value = value;
        this.parentTransactionID = parentTransactionID;
        this.nonce = UID++;
        this.ID = StringUtils.applySha256((String)(this.nonce + recipient + Double.toString(value) + parentTransactionID));
    }

    public int getNonce() {
        return this.nonce;
    }

    public String getID() {
        return this.ID;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getParentTransactionID() {
        return this.parentTransactionID;
    }
}

