/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.blockchain.Block;
import dev.netcode.blockchain.BlockChain;
import dev.netcode.blockchain.Transaction;
import dev.netcode.blockchain.TransactionInput;
import dev.netcode.blockchain.TransactionOutput;
import dev.netcode.blockchain.exceptions.InsufficientTransactionInputsValueException;
import dev.netcode.blockchain.exceptions.InvalidSignatureException;
import dev.netcode.blockchain.exceptions.InvalidTransactionValueException;
import dev.netcode.blockchain.exceptions.TransactionOutputNotFoundException;
import dev.netcode.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TransactionBlockChain
extends BlockChain<ArrayList<Transaction>> {
    private double minimumTransactionValue = 0.0;
    private Map<String, TransactionOutput> UTXOs = new HashMap<String, TransactionOutput>();

    public boolean isValidTransactionValue(double value) {
        return value > this.minimumTransactionValue;
    }

    public boolean processTransaction(Transaction transaction) throws InvalidSignatureException, TransactionOutputNotFoundException, InvalidTransactionValueException, InsufficientTransactionInputsValueException {
        Map<String, TransactionOutput> UTXOs = this.getUTXOs(transaction.getSender());
        if (!transaction.verifySignature()) {
            throw new InvalidSignatureException();
        }
        for (TransactionInput i : transaction.getInputs()) {
            TransactionOutput output = UTXOs.get(i.getTransactionOutputID());
            if (output == null) {
                throw new TransactionOutputNotFoundException();
            }
            i.setUTXO(output);
        }
        if (!this.isValidTransactionValue(transaction.getValue())) {
            throw new InvalidTransactionValueException("Transaction value is not valid: " + transaction.getValue());
        }
        if (transaction.getInputsValue() < transaction.getValue()) {
            throw new InsufficientTransactionInputsValueException("The value of the Transaction Inputs is smaller than the transaction value");
        }
        if (transaction.isProcessed()) {
            return true;
        }
        double leftOver = transaction.getInputsValue() - transaction.getValue();
        transaction.getOutputs().add(new TransactionOutput(transaction.getRecipient(), transaction.getValue(), transaction.getHash()));
        if (leftOver > 0.0) {
            transaction.getOutputs().add(new TransactionOutput(transaction.getSender(), leftOver, transaction.getHash()));
        }
        transaction.setProcessed(true);
        return true;
    }

    public boolean verifyTransaction(Transaction transaction) throws InvalidSignatureException, InvalidTransactionValueException {
        if (!transaction.verifySignature()) {
            throw new InvalidSignatureException();
        }
        if (!this.isValidTransactionValue(transaction.getValue())) {
            throw new InvalidTransactionValueException("Transaction value is not valid");
        }
        for (TransactionOutput TXO : transaction.getOutputs()) {
            String TXOHash = StringUtils.applySha256((String)(TXO.getNonce() + TXO.getRecipient() + Double.toString(TXO.getValue()) + TXO.getParentTransactionID()));
            if (TXOHash.equals(TXO.getID())) continue;
            return false;
        }
        return true;
    }

    public Map<String, TransactionOutput> refreshUTXOs() {
        HashMap<String, TransactionOutput> UTXOs = new HashMap<String, TransactionOutput>();
        for (Block block : super.getBlocks()) {
            for (Transaction transaction : (ArrayList)block.getData()) {
                for (TransactionOutput transactionOutput : transaction.getOutputs()) {
                    UTXOs.put(transactionOutput.getID(), transactionOutput);
                }
            }
        }
        for (Block block : super.getBlocks()) {
            for (Transaction transaction : (ArrayList)block.getData()) {
                if (transaction.getInputs() == null) continue;
                for (TransactionInput transactionInput : transaction.getInputs()) {
                    UTXOs.remove(transactionInput.getUTXO().getID());
                }
            }
        }
        this.UTXOs = UTXOs;
        return this.UTXOs;
    }

    public Map<String, TransactionOutput> getUTXOs() {
        return this.UTXOs.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (TransactionOutput)e.getValue()));
    }

    public Map<String, TransactionOutput> getUTXOs(String address) {
        return this.UTXOs.entrySet().stream().filter(i -> ((TransactionOutput)i.getValue()).getRecipient().equals(address)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (TransactionOutput)e.getValue()));
    }

    public void addUTXO(TransactionOutput UTXO) {
        this.UTXOs.put(UTXO.getID(), UTXO);
    }
}

