/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.blockchain.Block;
import dev.netcode.blockchain.Transaction;
import dev.netcode.blockchain.util.Utils;
import dev.netcode.util.StringUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class TransactionBlock
extends Block<ArrayList<Transaction>> {
    public TransactionBlock(String previousHash, ArrayList<Transaction> transactions) {
        super(previousHash, transactions, Utils::getMerkleRoot, Map.of("timestamp", new Date().getTime(), "nonce", new SecureRandom().nextInt()));
    }

    @Override
    public String calculateHash() {
        return StringUtils.applySha256((String)(super.getPreviousHash() + Long.toString((Long)super.getMetadata().get("timestamp")) + Integer.toString((Integer)super.getMetadata().get("nonce")) + Utils.getMerkleRoot((ArrayList)super.getData())));
    }
}

