/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.blockchain.TransactionInput;
import dev.netcode.blockchain.TransactionOutput;
import dev.netcode.security.encryption.RSAEncrypter;
import dev.netcode.util.StringUtils;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Transaction {
    private int ID;
    private String hash;
    private String sender;
    private transient PublicKey publicKey;
    private String recipient;
    private String signature;
    private double value;
    private boolean processed;
    List<TransactionInput> inputs = new ArrayList<TransactionInput>();
    List<TransactionOutput> outputs = new ArrayList<TransactionOutput>();
    private static int transactionCounter = 0;

    public Transaction(@NonNull PublicKey sender, @NonNull String recipient, double value, List<TransactionInput> inputs) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.sender = RSAEncrypter.getFingerprint((PublicKey)sender);
        this.publicKey = sender;
        this.recipient = recipient;
        this.value = value;
        this.inputs = inputs;
        if (this.inputs == null) {
            this.inputs = new ArrayList<TransactionInput>();
        }
        this.ID = transactionCounter++;
        this.hash = this.calculateHash();
    }

    public String calculateHash() {
        String inputsHash = "";
        if (this.inputs.size() > 0) {
            inputsHash = StringUtils.applySha256((String)this.inputs.stream().map(TransactionInput::getTransactionOutputID).map(Object::toString).collect(Collectors.joining()));
        }
        return StringUtils.applySha256((String)(this.sender + this.recipient + Double.toString(this.value) + this.ID + inputsHash));
    }

    public boolean verifySignature() {
        return RSAEncrypter.verifySignature((PublicKey)this.publicKey, (String)this.getData(), (String)this.signature);
    }

    public String getData() {
        return this.sender + this.recipient + Double.toString(this.value) + this.hash;
    }

    public double getInputsValue() {
        return this.inputs.stream().filter(i -> i.getUTXO() != null).map(TransactionInput::getUTXO).collect(Collectors.summingDouble(TransactionOutput::getValue));
    }

    public double getOutputsValue() {
        return this.outputs.stream().collect(Collectors.summingDouble(TransactionOutput::getValue));
    }

    public int getID() {
        return this.ID;
    }

    public String getHash() {
        return this.hash;
    }

    public String getSender() {
        return this.sender;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public List<TransactionInput> getInputs() {
        return this.inputs;
    }

    public List<TransactionOutput> getOutputs() {
        return this.outputs;
    }
}

