/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.blockchain.Block;
import java.util.ArrayList;

public class BlockChain<T> {
    private ArrayList<Block<T>> blocks;

    public BlockChain() {
        this.blocks = new ArrayList();
    }

    public boolean validateChain() {
        Block<T> previousBlock = null;
        for (Block<T> block : this.blocks) {
            if (!block.validate()) {
                return false;
            }
            if (previousBlock != null && !block.getPreviousHash().equals(previousBlock.getHash())) {
                return false;
            }
            previousBlock = block;
        }
        return true;
    }

    public void restoreLastValidState() {
        while (!this.validateChain()) {
            this.blocks.remove(this.blocks.size() - 1);
        }
    }

    public void addBlock(Block<T> block) {
        this.blocks.add(block);
    }

    public Block<T> getBlock(int index) {
        if (this.blocks.size() == 0) {
            return null;
        }
        return this.blocks.get(index);
    }

    public Block<T> getLastBlock() {
        if (this.blocks.size() == 0) {
            return null;
        }
        return this.blocks.get(this.blocks.size() - 1);
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    public BlockChain(ArrayList<Block<T>> blocks) {
        this.blocks = blocks;
    }

    public ArrayList<Block<T>> getBlocks() {
        return this.blocks;
    }
}

