/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.blockchain;

import dev.netcode.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;

public class Block<T> {
    private long id;
    private String hash;
    private String previousHash;
    private T data;
    private Map<String, Object> metadata;
    Function<T, String> dataHashFunction;
    private static int blockCounter = 0;

    public Block(@NonNull String previousHash, T data) {
        if (previousHash == null) {
            throw new NullPointerException("previousHash is marked non-null but is null");
        }
        this.previousHash = previousHash;
        this.id = blockCounter++;
        this.data = data;
        this.dataHashFunction = Object::toString;
        this.metadata = new HashMap<String, Object>();
        this.hash = this.calculateHash();
    }

    public Block(@NonNull String previousHash, T data, Map<String, Object> metadata) {
        if (previousHash == null) {
            throw new NullPointerException("previousHash is marked non-null but is null");
        }
        this.previousHash = previousHash;
        this.id = blockCounter++;
        this.data = data;
        this.dataHashFunction = Object::toString;
        this.metadata = metadata;
        this.hash = this.calculateHash();
    }

    public Block(@NonNull String previousHash, T data, @NonNull Function<T, String> dataHasher) {
        if (previousHash == null) {
            throw new NullPointerException("previousHash is marked non-null but is null");
        }
        if (dataHasher == null) {
            throw new NullPointerException("dataHasher is marked non-null but is null");
        }
        this.previousHash = previousHash;
        this.id = blockCounter++;
        this.data = data;
        this.dataHashFunction = dataHasher;
        this.metadata = new HashMap<String, Object>();
        this.hash = this.calculateHash();
    }

    public Block(@NonNull String previousHash, T data, @NonNull Function<T, String> dataHasher, Map<String, Object> metadata) {
        if (previousHash == null) {
            throw new NullPointerException("previousHash is marked non-null but is null");
        }
        if (dataHasher == null) {
            throw new NullPointerException("dataHasher is marked non-null but is null");
        }
        this.previousHash = previousHash;
        this.id = blockCounter++;
        this.data = data;
        this.dataHashFunction = dataHasher;
        this.metadata = metadata;
        this.hash = this.calculateHash();
    }

    public String calculateHash() {
        return StringUtils.applySha256((String)(this.previousHash + this.dataHashFunction.apply(this.data)));
    }

    public boolean validate() {
        return this.hash.equals(this.calculateHash());
    }

    public void addMetadata(String key, Object metadata) {
        this.metadata.put(key, metadata);
    }

    public long getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public String getPreviousHash() {
        return this.previousHash;
    }

    public T getData() {
        return this.data;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setDataHashFunction(Function<T, String> dataHashFunction) {
        this.dataHashFunction = dataHashFunction;
    }

    public static int getBlockCounter() {
        return blockCounter;
    }

    public static void setBlockCounter(int blockCounter) {
        Block.blockCounter = blockCounter;
    }
}

