/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.lucene;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.driver.mongodb.exception.NotSupportedException;
import dev.mongocamp.driver.mongodb.lucene.MongoCampLuceneAnalyzer;
import dev.mongocamp.driver.mongodb.lucene.MongoCampLuceneAnalyzer$;
import dev.mongocamp.driver.mongodb.package$;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.bson.conversions.Bson;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class LuceneQueryConverter$
implements LazyLogging {
    public static final LuceneQueryConverter$ MODULE$ = new LuceneQueryConverter$();
    private static List<String> datePatters;
    private static transient Logger logger;
    private static volatile boolean bitmap$0;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        LuceneQueryConverter$ luceneQueryConverter$ = this;
        synchronized (luceneQueryConverter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Bson toDocument(Query query, boolean searchWithValueAndString) {
        return package$.MODULE$.documentFromScalaMap(this.getMongoDbSearchMap(query, false, searchWithValueAndString));
    }

    public boolean toDocument$default$2() {
        return false;
    }

    public Query parse(String queryString, String defaultField) {
        MongoCampLuceneAnalyzer analyzer = new MongoCampLuceneAnalyzer(MongoCampLuceneAnalyzer$.MODULE$.$lessinit$greater$default$1(), MongoCampLuceneAnalyzer$.MODULE$.$lessinit$greater$default$2());
        QueryParser queryParser = new QueryParser(defaultField, (Analyzer)analyzer);
        queryParser.setAllowLeadingWildcard(true);
        Query query = queryParser.parse(queryString);
        analyzer.close();
        analyzer = null;
        return query;
    }

    private Map<String, Object> getMongoDbSearchMap(Query query, boolean negated, boolean searchWithValueAndString) {
        scala.collection.mutable.Map searchMapResponse = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Query query2 = query;
        if (query2 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query2;
            this.appendBooleanQueryToSearchMap((scala.collection.mutable.Map<String, Object>)searchMapResponse, booleanQuery, searchWithValueAndString);
        } else if (query2 instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery = (TermRangeQuery)query2;
            this.appendTermRangeQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, termRangeQuery, searchWithValueAndString);
        } else if (query2 instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query2;
            this.appendTermQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, termQuery, searchWithValueAndString);
        } else if (query2 instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query2;
            this.appendPrefixQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, prefixQuery);
        } else if (query2 instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query2;
            this.appendWildCardQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, wildcardQuery);
        } else if (query2 instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query2;
            this.appendPhraseQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, phraseQuery);
        } else if (query2 != null) {
            Query query3 = query2;
            Option simpleNameOption = Option$.MODULE$.apply((Object)query3.getClass().getSimpleName()).filterNot((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LuceneQueryConverter$.$anonfun$getMongoDbSearchMap$1(s)));
            if (simpleNameOption.isDefined()) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected QueryType <{}>", (Object)query3.getClass().getSimpleName());
                }
            }
        } else {
            throw new MatchError((Object)query2);
        }
        return searchMapResponse.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void appendBooleanQueryToSearchMap(scala.collection.mutable.Map<String, Object> searchMapResponse, BooleanQuery booleanQuery, boolean searchWithValueAndString) {
        Buffer subQueries = CollectionConverters$.MODULE$.ListHasAsScala(booleanQuery.clauses()).asScala();
        ArrayBuffer listOfAnd = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer listOfOr = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef nextTypeAnd = BooleanRef.create((boolean)true);
        subQueries.foreach((Function1 & Serializable)c -> {
            LuceneQueryConverter$.$anonfun$appendBooleanQueryToSearchMap$1(searchWithValueAndString, nextTypeAnd, listOfAnd, listOfOr, c);
            return BoxedUnit.UNIT;
        });
        Object object = listOfAnd.nonEmpty() ? searchMapResponse.put((Object)"$and", (Object)listOfAnd.toList()) : BoxedUnit.UNIT;
        if (listOfOr.nonEmpty()) {
            searchMapResponse.put((Object)"$or", (Object)listOfOr.toList());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendTermRangeQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, TermRangeQuery termRangeQuery, boolean searchWithValueAndString) {
        lowerBoundString = new String(termRangeQuery.getLowerTerm().bytes);
        lowerBound = this.checkAndConvertValue(lowerBoundString);
        upperBoundString = new String(termRangeQuery.getUpperTerm().bytes);
        upperBound = this.checkAndConvertValue(upperBoundString);
        if (!searchWithValueAndString) ** GOTO lbl-1000
        v0 = lowerBoundString;
        var10_9 = lowerBound;
        if (v0 != null ? v0.equals(var10_9) == false : var10_9 != null) ** GOTO lbl-1000
        v1 = upperBoundString;
        var11_10 = upperBound;
        if (v1 == null ? var11_10 != null : v1.equals(var11_10) == false) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        searchWithStringValue = v2;
        inRangeSearch = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$lte"), upperBound), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$gte"), lowerBound)}));
        inRangeStringSearch = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$lte"), (Object)upperBoundString), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$gte"), (Object)lowerBoundString)}));
        if (negated) {
            if (searchWithStringValue) {
                searchMapResponse.put((Object)"$and", (Object)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termRangeQuery.getField()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), (Object)inRangeSearch)})))}))), (List)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termRangeQuery.getField()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), (Object)inRangeStringSearch)})))}))), (List)Nil$.MODULE$)));
                return;
            }
            searchMapResponse.put((Object)termRangeQuery.getField(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), (Object)inRangeSearch)})));
            return;
        }
        if (searchWithStringValue) {
            searchMapResponse.put((Object)"$or", (Object)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termRangeQuery.getField()), (Object)inRangeSearch)}))), (List)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termRangeQuery.getField()), (Object)inRangeStringSearch)}))), (List)Nil$.MODULE$)));
            return;
        }
        searchMapResponse.put((Object)termRangeQuery.getField(), (Object)inRangeSearch);
    }

    private void appendTermQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, TermQuery termQuery, boolean searchWithValueAndString) {
        Object convertedValue;
        block8: {
            block7: {
                block4: {
                    block6: {
                        block5: {
                            convertedValue = this.checkAndConvertValue(termQuery.getTerm().text());
                            if (!negated) break block4;
                            if (!searchWithValueAndString) break block5;
                            Object object = convertedValue;
                            String string = termQuery.getTerm().text();
                            if (object != null ? !object.equals(string) : string != null) break block6;
                        }
                        searchMapResponse.put((Object)termQuery.getTerm().field(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$ne"), convertedValue)})));
                        return;
                    }
                    searchMapResponse.put((Object)"$and", (Object)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termQuery.getTerm().field()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$ne"), convertedValue)})))}))), (List)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termQuery.getTerm().field()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$ne"), (Object)termQuery.getTerm().text())})))}))), (List)Nil$.MODULE$)));
                    return;
                }
                if (!searchWithValueAndString) break block7;
                Object object = convertedValue;
                String string = termQuery.getTerm().text();
                if (object != null ? !object.equals(string) : string != null) break block8;
            }
            searchMapResponse.put((Object)termQuery.getTerm().field(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$eq"), convertedValue)})));
            return;
        }
        searchMapResponse.put((Object)"$or", (Object)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termQuery.getTerm().field()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$eq"), convertedValue)})))}))), (List)new .colon.colon((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)termQuery.getTerm().field()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$eq"), (Object)termQuery.getTerm().text())})))}))), (List)Nil$.MODULE$)));
    }

    private void appendPrefixQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, PrefixQuery query) {
        String searchValue = new StringBuilder(5).append(this.checkAndConvertValue(query.getPrefix().text())).append("(.*?)").toString();
        .colon.colon listOfSearches = new .colon.colon((Object)package$.MODULE$.documentFromScalaMap((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)query.getField()), this.generateRegexQuery(String.valueOf(searchValue), "i"))})))), (List)Nil$.MODULE$);
        if (negated) {
            searchMapResponse.put((Object)"$nor", (Object)listOfSearches);
            return;
        }
        searchMapResponse.$plus$plus$eq((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$and"), (Object)listOfSearches)})));
    }

    private void appendWildCardQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, WildcardQuery query) {
        Object searchValue = this.checkAndConvertValue(query.getTerm().text().replace("*", "(.*?)"));
        if (negated) {
            searchMapResponse.put((Object)query.getField(), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), this.generateRegexQuery(String.valueOf(searchValue), "i"))})));
            return;
        }
        searchMapResponse.put((Object)query.getField(), this.generateRegexQuery(String.valueOf(searchValue), "i"));
    }

    private void appendPhraseQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, PhraseQuery query) {
        List listOfSearches = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])query.getTerms()), (Function1 & Serializable)term -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)term.field()), MODULE$.generateRegexQuery(new StringBuilder(10).append("(.*?)").append(MODULE$.checkAndConvertValue(term.text())).append("(.*?)").toString(), "i"))})), ClassTag$.MODULE$.apply(Map.class))).toList();
        if (negated) {
            searchMapResponse.put((Object)"$nor", (Object)listOfSearches);
            return;
        }
        searchMapResponse.$plus$plus$eq((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$and"), (Object)listOfSearches)})));
    }

    private Map<String, String> generateRegexQuery(String pattern, String options) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$regex"), (Object)pattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$options"), (Object)options)}));
    }

    private Object checkAndConvertValue(String s) {
        Object object;
        try {
            Option convertedValue = ((LinearSeqOps)((IterableOps)((IterableOps)Nil$.MODULE$.$plus$plus((IterableOnce)LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)), s))).$plus$plus((IterableOnce)LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)), s))).$plus$plus((IterableOnce)LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s)), s))).headOption();
            object = convertedValue.getOrElse((Function0 & Serializable)() -> {
                Option parsedOptions = MODULE$.datePatters().map((Function1 & Serializable)pattern -> {
                    None$ none$;
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat((String)pattern);
                        none$ = Option$.MODULE$.apply((Object)formatter.parse(s));
                    }
                    catch (Exception exception) {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return parsedOptions.getOrElse((Function0 & Serializable)() -> s);
            });
        }
        catch (Exception exception) {
            object = s;
        }
        return object;
    }

    private List<String> datePatters$lzycompute() {
        LuceneQueryConverter$ luceneQueryConverter$ = this;
        synchronized (luceneQueryConverter$) {
            if (!bitmap$0) {
                datePatters = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"yyyyMMdd'T'HHmmssSSSZZ", "yyyyMMdd'T'HHmmssZZ", "yyyyMMdd'T'HHmmZZ", "yyyyMMdd'T'HHmmssSSS", "yyyyMMdd'T'HHmmss", "yyyyMMdd'T'HHmm", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mmZZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm"}));
                bitmap$0 = true;
            }
        }
        return datePatters;
    }

    private List<String> datePatters() {
        if (!bitmap$0) {
            return this.datePatters$lzycompute();
        }
        return datePatters;
    }

    public static final /* synthetic */ boolean $anonfun$getMongoDbSearchMap$1(String s) {
        return s.trim().equalsIgnoreCase("");
    }

    public static final /* synthetic */ void $anonfun$appendBooleanQueryToSearchMap$1(boolean searchWithValueAndString$1, BooleanRef nextTypeAnd$1, ArrayBuffer listOfAnd$1, ArrayBuffer listOfOr$1, BooleanClause c) {
        Map<String, Object> queryMap = MODULE$.getMongoDbSearchMap(c.query(), c.isProhibited(), searchWithValueAndString$1);
        boolean thisTypeAnd = true;
        BooleanClause.Occur occur = c.occur();
        BooleanClause.Occur occur2 = BooleanClause.Occur.MUST;
        if (!(occur != null ? !occur.equals(occur2) : occur2 != null)) {
            thisTypeAnd = true;
        } else {
            BooleanClause.Occur occur3 = c.occur();
            BooleanClause.Occur occur4 = BooleanClause.Occur.SHOULD;
            if (!(occur3 != null ? !occur3.equals(occur4) : occur4 != null)) {
                thisTypeAnd = false;
            } else {
                BooleanClause.Occur occur5 = c.occur();
                BooleanClause.Occur occur6 = BooleanClause.Occur.MUST_NOT;
                if (occur5 == null ? occur6 != null : !occur5.equals(occur6)) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Unexpected Occur <{}>", (Object)c.occur().name());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NotSupportedException(new StringBuilder(24).append(c.occur().name()).append(" currently not supported").toString());
                }
            }
        }
        Growable growable = nextTypeAnd$1.elem && thisTypeAnd ? listOfAnd$1.$plus$eq(queryMap) : listOfOr$1.$plus$eq(queryMap);
        nextTypeAnd$1.elem = thisTypeAnd;
    }

    private static final Option checkOrReturn$1(Function0 f, String s$1) {
        None$ none$;
        block3: {
            try {
                Object value = f.apply();
                if (value.toString().equals(s$1)) {
                    none$ = Option$.MODULE$.apply(value);
                    break block3;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private LuceneQueryConverter$() {
    }
}

