/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.database;

import com.mongodb.MongoCommandException;
import dev.mongocamp.driver.mongodb.MongoDAO;
import dev.mongocamp.driver.mongodb.database.ChangeObserver;
import dev.mongocamp.driver.mongodb.database.CollectionInfo;
import dev.mongocamp.driver.mongodb.database.CollectionInfo$;
import dev.mongocamp.driver.mongodb.database.CollectionStatus;
import dev.mongocamp.driver.mongodb.database.CollectionStatus$;
import dev.mongocamp.driver.mongodb.database.CompactResult;
import dev.mongocamp.driver.mongodb.database.DatabaseInfo;
import dev.mongocamp.driver.mongodb.database.DatabaseInfo$;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider$;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider$DocumentDao$;
import dev.mongocamp.driver.mongodb.database.MongoConfig;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.driver.mongodb.package$;
import java.io.Serializable;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.mongodb.scala.ListCollectionsObservable;
import org.mongodb.scala.ListDatabasesObservable;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.Observable;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.gridfs.GridFSBucket;
import org.mongodb.scala.gridfs.GridFSBucket$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001B/_\u0001%D\u0001\u0002 \u0001\u0003\u0006\u0004%\t! \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nyD!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u00111\u0002\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA\u001a\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA3\u0011%\tI\t\u0001a\u0001\n\u0013\tY\tC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002\u001c\"A\u0011q\u0015\u0001!B\u0013\ti\tC\u0005\u0002*\u0002\u0001\r\u0011\"\u0003\u0002,\"I\u0011Q\u0016\u0001A\u0002\u0013%\u0011q\u0016\u0005\t\u0003g\u0003\u0001\u0015)\u0003\u0002D!9\u0011Q\u0017\u0001\u0005\u0002\u0005-\u0006bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011%\u0011y\u0001AI\u0001\n\u0003\u0011\t\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u0013\t}\u0002!%A\u0005\u0002\tE\u0001\"\u0003B!\u0001E\u0005I\u0011\u0001B\"\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013B\u0011B!\u0014\u0001#\u0003%\tAa\u0011\t\r}\u0003A\u0011\u0001B(\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011\t\u0002C\u0004\u0003V\u0001!\tAa\u0016\t\u0013\t\u0015\u0004!%A\u0005\u0002\tE\u0001b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\n\u0005g\u0002\u0011\u0013!C\u0001\u0005#AqA!\u001e\u0001\t\u0003\u00119\bC\u0005\u0003\u0004\u0002\t\n\u0011\"\u0001\u0003\u0012!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005\"\u0003BF\u0001E\u0005I\u0011\u0001B\t\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fC\u0011B!'\u0001#\u0003%\tA!\u0005\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\"I!\u0011\u0017\u0001\u0012\u0002\u0013\u0005!\u0011\u0003\u0005\b\u0003{\u0001A\u0011\u0001BZ\u0011\u001d\u00119\u000f\u0001C\u0001\u0005SDqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003v\u0002!\tAa>\t\u000f\r%\u0001\u0001\"\u0001\u0004\f!91q\u0002\u0001\u0005\u0002\rE\u0001bBB\n\u0001\u0011\u00051\u0011\u0003\u0004\u0007\u0007+\u0001\u0001ia\u0006\t\u0015\r}QG!f\u0001\n\u0003\u0019\t\u0003\u0003\u0006\u0004$U\u0012\t\u0012)A\u0005\u0003SA!B!,6\u0005+\u0007I\u0011AAV\u0011)\u0019)#\u000eB\tB\u0003%\u00111\t\u0005\b\u0003K)D\u0011AB\u0014\u0011%\u0019\t$NA\u0001\n\u0003\u0019\u0019\u0004C\u0005\u0004:U\n\n\u0011\"\u0001\u0004<!I1qH\u001b\u0012\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0007\u0003*\u0014\u0011!C!\u0003sC\u0011ba\u00116\u0003\u0003%\ta!\u0012\t\u0013\r\u001dS'!A\u0005\u0002\r%\u0003\"CB'k\u0005\u0005I\u0011IB(\u0011%\u0019I&NA\u0001\n\u0003\u0019Y\u0006C\u0005\u0004`U\n\t\u0011\"\u0011\u0004b!I1QM\u001b\u0002\u0002\u0013\u00053q\r\u0005\n\u0007S*\u0014\u0011!C!\u0007W:\u0011ba\u001c\u0001\u0003\u0003E\ta!\u001d\u0007\u0013\rU\u0001!!A\t\u0002\rM\u0004bBA\u0013\u000f\u0012\u000511\u0012\u0005\n\u0007\u001b;\u0015\u0011!C#\u0007\u001fC\u0011b!%H\u0003\u0003%\tia%\t\u0013\reu)!A\u0005\u0002\u000emuaBBU=\"\u000511\u0016\u0004\u0007;zC\ta!,\t\u000f\u0005\u0015R\n\"\u0001\u00040\"I1\u0011W'C\u0002\u0013\u0005\u0011\u0011\u0018\u0005\t\u0007gk\u0005\u0015!\u0003\u0002<\"I1QW'C\u0002\u0013\u0005\u0011\u0011\u0018\u0005\t\u0007ok\u0005\u0015!\u0003\u0002<\"I1\u0011X'C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0007wk\u0005\u0015!\u0003\u0002\f!I1QX'C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0007\u007fk\u0005\u0015!\u0003\u0002\f!91\u0011S'\u0005\u0002\r\u0005\u0007\"CBd\u001bF\u0005I\u0011ABe\u0011\u001d\u0019i-\u0014C\u0001\u0007\u001fD\u0011ba6N#\u0003%\tA!\u0005\t\u0013\reW*%A\u0005\u0002\r%\u0007\"CBn\u001b\u0006\u0005I\u0011BBo\u0005A!\u0015\r^1cCN,\u0007K]8wS\u0012,'O\u0003\u0002`A\u0006AA-\u0019;bE\u0006\u001cXM\u0003\u0002bE\u00069Qn\u001c8h_\u0012\u0014'BA2e\u0003\u0019!'/\u001b<fe*\u0011QMZ\u0001\n[>twm\\2b[BT\u0011aZ\u0001\u0004I\u001648\u0001A\n\u0004\u0001)\u0004\bCA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'AB!osJ+g\r\u0005\u0002rs:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k\"\fa\u0001\u0010:p_Rt\u0014\"A7\n\u0005ad\u0017a\u00029bG.\fw-Z\u0005\u0003un\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001f7\u0002\r\r|gNZ5h+\u0005q\bcA@\u0002\u00025\ta,C\u0002\u0002\u0004y\u00131\"T8oO>\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0003:fO&\u001cHO]=\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003?i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\t\u0005U\u0011qC\u0001\u0007G>$WmY:\u000b\t\u0005e\u00111D\u0001\u0005EN|gN\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012q\u0002\u0002\u000e\u0007>$Wm\u0019*fO&\u001cHO]=\u0002\u0013I,w-[:uef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004\u0002*\u0005-\u0012Q\u0006\t\u0003\u007f\u0002AQ\u0001`\u0003A\u0002yDq!a\u0002\u0006\u0001\u0004\tY!A\tdC\u000eDW\r\u001a#bi\u0006\u0014\u0017m]3NCB,\"!a\r\u0011\u0011\u0005U\u0012qHA\"\u0003'j!!a\u000e\u000b\t\u0005e\u00121H\u0001\b[V$\u0018M\u00197f\u0015\r\ti\u0004\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA!\u0003o\u0011q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002F\u00055c\u0002BA$\u0003\u0013\u0002\"a\u001d7\n\u0007\u0005-C.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017b\u0007\u0003BA+\u00037j!!a\u0016\u000b\u00075\fIFC\u0002b\u00037IA!!\u0018\u0002X\tiQj\u001c8h_\u0012\u000bG/\u00192bg\u0016\f!cY1dQ\u0016$G)\u0019;bE\u0006\u001cX-T1qA\u0005\t2-Y2iK\u0012luN\\4p\t\u0006{U*\u00199\u0016\u0005\u0005\u0015\u0004\u0003CA\u001b\u0003\u007f\t\u0019%a\u001a\u0011\r\u0005%\u00141NA8\u001b\u0005\u0001\u0017bAA7A\nAQj\u001c8h_\u0012\u000bu\n\u0005\u0003\u0002r\u0005\u0005e\u0002BA:\u0003\u007frA!!\u001e\u0002~9!\u0011qOA>\u001d\r\u0019\u0018\u0011P\u0005\u0003\u0003;I1!YA\u000e\u0013\ri\u0017\u0011L\u0005\u0004q\u0006]\u0013\u0002BAB\u0003\u000b\u0013\u0001\u0002R8dk6,g\u000e\u001e\u0006\u0004q\u0006]\u0013AE2bG\",G-T8oO>$\u0015iT'ba\u0002\nAbY1dQ\u0016$7\t\\5f]R,\"!!$\u0011\u000b-\fy)a%\n\u0007\u0005EEN\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\n)*\u0003\u0003\u0002\u0018\u0006]#aC'p]\u001e|7\t\\5f]R\f\u0001cY1dQ\u0016$7\t\\5f]R|F%Z9\u0015\t\u0005u\u00151\u0015\t\u0004W\u0006}\u0015bAAQY\n!QK\\5u\u0011%\t)kCA\u0001\u0002\u0004\ti)A\u0002yIE\nQbY1dQ\u0016$7\t\\5f]R\u0004\u0013a\u00053fM\u0006,H\u000e\u001e#bi\u0006\u0014\u0017m]3OC6,WCAA\"\u0003]!WMZ1vYR$\u0015\r^1cCN,g*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0006E\u0006\"CAS\u001d\u0005\u0005\t\u0019AA\"\u0003Q!WMZ1vYR$\u0015\r^1cCN,g*Y7fA\u0005\u0019B)\u001a4bk2$H)\u0019;bE\u0006\u001cXMT1nK\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8TiJLgnZ\u000b\u0003\u0003w\u0003B!!0\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0003mC:<'BAAc\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013qX\u0001\u0017g\u0016$H)\u001a4bk2$H)\u0019;bE\u0006\u001cXMT1nKR!\u0011QTAg\u0011\u001d\tyM\u0005a\u0001\u0003\u0007\nA\u0002Z1uC\n\f7/\u001a(b[\u0016\faa\u00197jK:$XCAAJ\u0003!I7o\u00117pg\u0016$WCAAm!\rY\u00171\\\u0005\u0004\u0003;d'a\u0002\"p_2,\u0017M\\\u0001\fG2|7/Z\"mS\u0016tG\u000f\u0006\u0002\u0002\u001e\u0006IA-\u0019;bE\u0006\u001cXm]\u000b\u0003\u0003O\u0004b!!\u0016\u0002j\u0006=\u0014\u0002BAv\u0003/\u0012q\u0003T5ti\u0012\u000bG/\u00192bg\u0016\u001cxJY:feZ\f'\r\\3\u0002\u001b\u0011\fG/\u00192bg\u0016LeNZ8t+\t\t\t\u0010E\u0003r\u0003g\f90C\u0002\u0002vn\u0014A\u0001T5tiB\u0019q0!?\n\u0007\u0005mhL\u0001\u0007ECR\f'-Y:f\u0013:4w.A\u0007eCR\f'-Y:f\u001d\u0006lWm]\u000b\u0003\u0005\u0003\u0001R!]Az\u0003\u0007\nA\u0002\u001a:pa\u0012\u000bG/\u00192bg\u0016$BAa\u0002\u0003\u000eA1\u0011Q\u000bB\u0005\u0003;KAAa\u0003\u0002X\t\u00012+\u001b8hY\u0016|%m]3sm\u0006\u0014G.\u001a\u0005\n\u0003\u001fL\u0002\u0013!a\u0001\u0003\u0007\na\u0003\u001a:pa\u0012\u000bG/\u00192bg\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005'QC!a\u0011\u0003\u0016-\u0012!q\u0003\t\u0005\u00053\u0011\u0019#\u0004\u0002\u0003\u001c)!!Q\u0004B\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0003\"1\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ca\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bd_6\u0004\u0018m\u0019;ECR\f'-Y:f)\u0019\u0011YCa\r\u00036A)\u0011/a=\u0003.A\u0019qPa\f\n\u0007\tEbLA\u0007D_6\u0004\u0018m\u0019;SKN,H\u000e\u001e\u0005\n\u0003\u001f\\\u0002\u0013!a\u0001\u0003\u0007B\u0011Ba\u000e\u001c!\u0003\u0005\rA!\u000f\u0002)5\f\u0007pV1jiB+'oQ8mY\u0016\u001cG/[8o!\rY'1H\u0005\u0004\u0005{a'aA%oi\u0006I2m\\7qC\u000e$H)\u0019;bE\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132\u0003e\u0019w.\u001c9bGR$\u0015\r^1cCN,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015#\u0006\u0002B\u001d\u0005+\tqaY8na\u0006\u001cG\u000f\u0006\u0003\u0003,\t-\u0003\"\u0003B\u001c=A\u0005\t\u0019\u0001B\u001d\u0003E\u0019w.\u001c9bGR$C-\u001a4bk2$H%\r\u000b\u0005\u0003'\u0012\t\u0006C\u0005\u0002P\u0002\u0002\n\u00111\u0001\u0002D\u0005\u0011B-\u0019;bE\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132\u0003E\tG\rZ\"iC:<Wm\u00142tKJ4XM\u001d\u000b\u0007\u00053\u0012yFa\u0019\u0011\u000b}\u0014Y&a\u001c\n\u0007\tucL\u0001\bDQ\u0006tw-Z(cg\u0016\u0014h/\u001a:\t\u000f\t\u0005$\u00051\u0001\u0003Z\u0005AqNY:feZ,'\u000fC\u0005\u0002P\n\u0002\n\u00111\u0001\u0002D\u0005Y\u0012\r\u001a3DQ\u0006tw-Z(cg\u0016\u0014h/\u001a:%I\u00164\u0017-\u001e7uII\n1bY8mY\u0016\u001cG/[8ogR!!1\u000eB9!\u0019\t)F!\u001c\u0002p%!!qNA,\u0005ea\u0015n\u001d;D_2dWm\u0019;j_:\u001cxJY:feZ\f'\r\\3\t\u0013\u0005=G\u0005%AA\u0002\u0005\r\u0013!F2pY2,7\r^5p]N$C-\u001a4bk2$H%M\u0001\u0010G>dG.Z2uS>t\u0017J\u001c4pgR!!\u0011\u0010BA!\u0015\t\u00181\u001fB>!\ry(QP\u0005\u0004\u0005\u007fr&AD\"pY2,7\r^5p]&sgm\u001c\u0005\n\u0003\u001f4\u0003\u0013!a\u0001\u0003\u0007\n\u0011dY8mY\u0016\u001cG/[8o\u0013:4wn\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005y1m\u001c7mK\u000e$\u0018n\u001c8OC6,7\u000f\u0006\u0003\u0003\u0002\t%\u0005\"CAhQA\u0005\t\u0019AA\"\u0003e\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002\u0015I,hnQ8n[\u0006tG\r\u0006\u0004\u0003\u0012\nM%q\u0013\t\u0007\u0003+\u0012I!a\u001c\t\u000f\tU%\u00061\u0001\u0002p\u0005AAm\\2v[\u0016tG\u000fC\u0005\u0002P*\u0002\n\u00111\u0001\u0002D\u0005!\"/\u001e8D_6l\u0017M\u001c3%I\u00164\u0017-\u001e7uII\n\u0001cY8mY\u0016\u001cG/[8o'R\fG/^:\u0015\r\t}%1\u0016BX!\u0019\t)F!)\u0003&&!!1UA,\u0005)y%m]3sm\u0006\u0014G.\u001a\t\u0004\u007f\n\u001d\u0016b\u0001BU=\n\u00012i\u001c7mK\u000e$\u0018n\u001c8Ti\u0006$Xo\u001d\u0005\b\u0005[c\u0003\u0019AA\"\u00039\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016D\u0011\"a4-!\u0003\u0005\r!a\u0011\u00025\r|G\u000e\\3di&|gn\u0015;biV\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tU&1\u0019\u000b\u0005\u0005o\u0013)\u000f\u0006\u0003\u0003:\nU\u0007CBA+\u0005w\u0013y,\u0003\u0003\u0003>\u0006]#aD'p]\u001e|7i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\t\u0005'1\u0019\u0007\u0001\t\u001d\u0011)M\fb\u0001\u0005\u000f\u0014\u0011!Q\t\u0005\u0005\u0013\u0014y\rE\u0002l\u0005\u0017L1A!4m\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u001bBi\u0013\r\u0011\u0019\u000e\u001c\u0002\u0004\u0003:L\bb\u0002Bl]\u0001\u000f!\u0011\\\u0001\u0003GR\u0004bAa7\u0003b\n}VB\u0001Bo\u0015\r\u0011y\u000e\\\u0001\be\u00164G.Z2u\u0013\u0011\u0011\u0019O!8\u0003\u0011\rc\u0017m]:UC\u001eDqA!,/\u0001\u0004\t\u0019%A\thk\u0016\u001c8\u000fR1uC\n\f7/\u001a(b[\u0016$B!a\u0011\u0003l\"9!Q^\u0018A\u0002\u0005\r\u0013AE7bs\n,7+\u001a9be\u0006$X\r\u001a(b[\u0016\f\u0011bZ;fgNt\u0015-\\3\u0015\t\u0005\r#1\u001f\u0005\b\u0005[\u0004\u0004\u0019AA\"\u0003\u0019\u0011WoY6fiR!!\u0011`B\u0003!\u0011\u0011Yp!\u0001\u000e\u0005\tu(\u0002\u0002B\u0000\u0003/\naa\u001a:jI\u001a\u001c\u0018\u0002BB\u0002\u0005{\u0014Ab\u0012:jI\u001a\u001b&)^2lKRDqaa\u00022\u0001\u0004\t\u0019%\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016\f1\u0001Z1p)\u0011\t9g!\u0004\t\u000f\t5&\u00071\u0001\u0002D\u0005\u00192-Y2iK\u0012$\u0015\r^1cCN,g*Y7fgR\u0011!\u0011A\u0001\u0016G\u0006\u001c\u0007.\u001a3D_2dWm\u0019;j_:t\u0015-\\3t\u0005-!unY;nK:$H)Y8\u0014\rU\n9g!\u0007q!\rY71D\u0005\u0004\u0007;a'a\u0002)s_\u0012,8\r^\u0001\taJ|g/\u001b3feV\u0011\u0011\u0011F\u0001\naJ|g/\u001b3fe\u0002\nqbY8mY\u0016\u001cG/[8o\u001d\u0006lW\r\t\u000b\u0007\u0007S\u0019ica\f\u0011\u0007\r-R'D\u0001\u0001\u0011\u001d\u0019yB\u000fa\u0001\u0003SAqA!,;\u0001\u0004\t\u0019%\u0001\u0003d_BLHCBB\u0015\u0007k\u00199\u0004C\u0005\u0004 m\u0002\n\u00111\u0001\u0002*!I!QV\u001e\u0011\u0002\u0003\u0007\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019iD\u000b\u0003\u0002*\tU\u0011AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\te\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001f\u001cY\u0005C\u0005\u0002&\u0002\u000b\t\u00111\u0001\u0003:\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004RA111KB+\u0005\u001fl!!a\u000f\n\t\r]\u00131\b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002Z\u000eu\u0003\"CAS\u0005\u0006\u0005\t\u0019\u0001Bh\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m61\r\u0005\n\u0003K\u001b\u0015\u0011!a\u0001\u0005s\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005s\ta!Z9vC2\u001cH\u0003BAm\u0007[B\u0011\"!*F\u0003\u0003\u0005\rAa4\u0002\u0017\u0011{7-^7f]R$\u0015m\u001c\t\u0004\u0007W95#B$\u0004v\r\u0005\u0005CCB<\u0007{\nI#a\u0011\u0004*5\u00111\u0011\u0010\u0006\u0004\u0007wb\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007\u007f\u001aIHA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Baa!\u0004\n6\u00111Q\u0011\u0006\u0005\u0007\u000f\u000b\u0019-\u0001\u0002j_&\u0019!p!\"\u0015\u0005\rE\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0016!B1qa2LHCBB\u0015\u0007+\u001b9\nC\u0004\u0004 )\u0003\r!!\u000b\t\u000f\t5&\n1\u0001\u0002D\u00059QO\\1qa2LH\u0003BBO\u0007K\u0003Ra[AH\u0007?\u0003ra[BQ\u0003S\t\u0019%C\u0002\u0004$2\u0014a\u0001V;qY\u0016\u0014\u0004\"CBT\u0017\u0006\u0005\t\u0019AB\u0015\u0003\rAH\u0005M\u0001\u0011\t\u0006$\u0018MY1tKB\u0013xN^5eKJ\u0004\"a`'\u0014\t5S7\u0011\u0011\u000b\u0003\u0007W\u000b1b\u00142kK\u000e$\u0018\nZ&fs\u0006aqJ\u00196fGRLEmS3zA\u0005\u00192i\u001c7mK\u000e$\u0018n\u001c8TKB\f'/\u0019;pe\u0006!2i\u001c7mK\u000e$\u0018n\u001c8TKB\f'/\u0019;pe\u0002\nabQ;ti>l'+Z4jgR\u0014\u00180A\bDkN$x.\u001c*fO&\u001cHO]=!\u00035\u0019w\u000eZ3d%\u0016<\u0017n\u001d;ss\u0006q1m\u001c3fGJ+w-[:uef\u0004CCBA\u0015\u0007\u0007\u001c)\rC\u0003}/\u0002\u0007a\u0010C\u0005\u0002\b]\u0003\n\u00111\u0001\u0002\f\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0004L*\"\u00111\u0002B\u000b\u0003!1'o\\7QCRDGCBA\u0015\u0007#\u001c)\u000eC\u0005\u0004Tf\u0003\n\u00111\u0001\u0002D\u0005Q1m\u001c8gS\u001e\u0004\u0016\r\u001e5\t\u0013\u0005\u001d\u0011\f%AA\u0002\u0005-\u0011A\u00054s_6\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIE\n!C\u001a:p[B\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111q\u001c\t\u0005\u0003{\u001b\t/\u0003\u0003\u0004d\u0006}&AB(cU\u0016\u001cG\u000f")
public class DatabaseProvider
implements Serializable {
    private volatile DatabaseProvider$DocumentDao$ DocumentDao$module;
    private final MongoConfig config;
    private final CodecRegistry registry;
    private final HashMap<String, MongoDatabase> cachedDatabaseMap;
    private final HashMap<String, MongoDAO<Document>> cachedMongoDAOMap;
    private Option<MongoClient> cachedClient;
    private String defaultDatabaseName;

    public static CodecRegistry fromPath$default$2() {
        return DatabaseProvider$.MODULE$.fromPath$default$2();
    }

    public static String fromPath$default$1() {
        return DatabaseProvider$.MODULE$.fromPath$default$1();
    }

    public static DatabaseProvider fromPath(String configPath, CodecRegistry registry) {
        return DatabaseProvider$.MODULE$.fromPath(configPath, registry);
    }

    public static CodecRegistry apply$default$2() {
        return DatabaseProvider$.MODULE$.apply$default$2();
    }

    public static DatabaseProvider apply(MongoConfig config, CodecRegistry registry) {
        return DatabaseProvider$.MODULE$.apply(config, registry);
    }

    public static String CollectionSeparator() {
        return DatabaseProvider$.MODULE$.CollectionSeparator();
    }

    public static String ObjectIdKey() {
        return DatabaseProvider$.MODULE$.ObjectIdKey();
    }

    public DatabaseProvider$DocumentDao$ DocumentDao() {
        if (this.DocumentDao$module == null) {
            this.DocumentDao$lzycompute$1();
        }
        return this.DocumentDao$module;
    }

    public MongoConfig config() {
        return this.config;
    }

    public CodecRegistry registry() {
        return this.registry;
    }

    private HashMap<String, MongoDatabase> cachedDatabaseMap() {
        return this.cachedDatabaseMap;
    }

    private HashMap<String, MongoDAO<Document>> cachedMongoDAOMap() {
        return this.cachedMongoDAOMap;
    }

    private Option<MongoClient> cachedClient() {
        return this.cachedClient;
    }

    private void cachedClient_$eq(Option<MongoClient> x$1) {
        this.cachedClient = x$1;
    }

    private String defaultDatabaseName() {
        return this.defaultDatabaseName;
    }

    private void defaultDatabaseName_$eq(String x$1) {
        this.defaultDatabaseName = x$1;
    }

    public String DefaultDatabaseName() {
        return this.defaultDatabaseName();
    }

    public String connectionString() {
        return new StringBuilder(12).append("mongodb://").append(this.config().host()).append(":").append(this.config().port()).append("/").append(this.config().database()).toString();
    }

    public void setDefaultDatabaseName(String databaseName) {
        this.defaultDatabaseName_$eq(databaseName);
    }

    public MongoClient client() {
        block0: {
            if (!this.isClosed()) break block0;
            this.cachedDatabaseMap().clear();
            this.cachedMongoDAOMap().clear();
            this.cachedClient_$eq((Option<MongoClient>)new Some((Object)MongoClient$.MODULE$.apply(this.config().clientSettings())));
        }
        return (MongoClient)this.cachedClient().get();
    }

    public boolean isClosed() {
        return this.cachedClient().isEmpty();
    }

    public void closeClient() {
        this.client().close();
        this.cachedClient_$eq((Option<MongoClient>)None$.MODULE$);
    }

    public ListDatabasesObservable<Document> databases() {
        return this.client().listDatabases(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public List<DatabaseInfo> databaseInfos() {
        ObservableIncludes.GenericObservable<Document> qual$1 = package$.MODULE$.GenericObservable(this.databases());
        int x$12 = qual$1.resultList$default$1();
        return (List)qual$1.resultList(x$12).map((Function1 & Serializable)doc -> DatabaseInfo$.MODULE$.apply((Document)doc)).sortBy((Function1 & Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$);
    }

    public List<String> databaseNames() {
        return this.databaseInfos().map((Function1 & Serializable)info -> info.name());
    }

    public SingleObservable<BoxedUnit> dropDatabase(String databaseName) {
        return this.database(databaseName).drop();
    }

    public String dropDatabase$default$1() {
        return this.DefaultDatabaseName();
    }

    public List<CompactResult> compactDatabase(String databaseName, int maxWaitPerCollection) {
        return this.collectionNames(databaseName).flatMap((Function1 & Serializable)collectionName -> package$.MODULE$.GenericObservable(this.dao((String)collectionName).compact()).result(maxWaitPerCollection));
    }

    public List<CompactResult> compact(int maxWaitPerCollection) {
        return this.databaseNames().flatMap((Function1 & Serializable)database -> {
            Nil$ nil$;
            try {
                nil$ = this.collectionNames((String)database).flatMap((Function1 & Serializable)collectionName -> package$.MODULE$.GenericObservable(this.dao((String)collectionName).compact()).result(maxWaitPerCollection));
            }
            catch (MongoCommandException e) {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        });
    }

    public String compactDatabase$default$1() {
        return this.DefaultDatabaseName();
    }

    public int compactDatabase$default$2() {
        return package$.MODULE$.DefaultMaxWait();
    }

    public int compact$default$1() {
        return package$.MODULE$.DefaultMaxWait();
    }

    public MongoDatabase database(String databaseName) {
        Object object = !this.cachedDatabaseMap().contains((Object)databaseName) ? this.cachedDatabaseMap().put((Object)databaseName, (Object)this.client().getDatabase(databaseName).withCodecRegistry(this.registry())) : BoxedUnit.UNIT;
        return (MongoDatabase)this.cachedDatabaseMap().apply((Object)databaseName);
    }

    public String database$default$1() {
        return this.DefaultDatabaseName();
    }

    public ChangeObserver<Document> addChangeObserver(ChangeObserver<Document> observer, String databaseName) {
        this.database(databaseName).watch(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).subscribe(observer);
        return observer;
    }

    public String addChangeObserver$default$2() {
        return this.DefaultDatabaseName();
    }

    public ListCollectionsObservable<Document> collections(String databaseName) {
        return this.database(databaseName).listCollections(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public List<CollectionInfo> collectionInfos(String databaseName) {
        ObservableIncludes.GenericObservable<Document> qual$1 = package$.MODULE$.GenericObservable(this.collections(databaseName));
        int x$1 = qual$1.resultList$default$1();
        return (List)qual$1.resultList(x$1).map((Function1 & Serializable)doc -> CollectionInfo$.MODULE$.apply((Document)doc)).sortBy((Function1 & Serializable)x$2 -> x$2.name(), (Ordering)Ordering.String$.MODULE$);
    }

    public List<String> collectionNames(String databaseName) {
        return this.collectionInfos(databaseName).map((Function1 & Serializable)info -> info.name());
    }

    public SingleObservable<Document> runCommand(Document document, String databaseName) {
        return this.database(databaseName).runCommand((Bson)document, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public String runCommand$default$2() {
        return this.DefaultDatabaseName();
    }

    public Observable<CollectionStatus> collectionStatus(String collectionName, String databaseName) {
        return this.runCommand(package$.MODULE$.documentFromScalaMap((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collStats"), (Object)collectionName)})))), databaseName).map((Function1 & Serializable)document -> CollectionStatus$.MODULE$.apply((Document)document));
    }

    public <A> MongoCollection<A> collection(String collectionName, ClassTag<A> ct) {
        if (collectionName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            String newDatabaseName = this.guessDatabaseName(collectionName);
            String newCollectionName = this.guessName(collectionName);
            return this.database(newDatabaseName).getCollection(newCollectionName, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ct);
        }
        return this.database(this.database$default$1()).getCollection(collectionName, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ct);
    }

    public String collections$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionInfos$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionNames$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionStatus$default$2() {
        return this.DefaultDatabaseName();
    }

    public String guessDatabaseName(String maybeSeparatedName) {
        if (maybeSeparatedName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            return maybeSeparatedName.substring(0, maybeSeparatedName.indexOf(DatabaseProvider$.MODULE$.CollectionSeparator()));
        }
        return this.DefaultDatabaseName();
    }

    public String guessName(String maybeSeparatedName) {
        if (maybeSeparatedName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            return maybeSeparatedName.substring(maybeSeparatedName.indexOf(DatabaseProvider$.MODULE$.CollectionSeparator()) + 1);
        }
        return maybeSeparatedName;
    }

    public GridFSBucket bucket(String bucketName) {
        if (bucketName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            String newDatabaseName = this.guessDatabaseName(bucketName);
            String newBucketName = this.guessName(bucketName);
            return GridFSBucket$.MODULE$.apply(this.database(newDatabaseName), newBucketName);
        }
        return GridFSBucket$.MODULE$.apply(this.database(this.database$default$1()), bucketName);
    }

    public MongoDAO<Document> dao(String collectionName) {
        Object object = !this.cachedMongoDAOMap().contains((Object)collectionName) ? this.cachedMongoDAOMap().put((Object)collectionName, (Object)new DocumentDao(this, this, collectionName)) : BoxedUnit.UNIT;
        return (MongoDAO)this.cachedMongoDAOMap().apply((Object)collectionName);
    }

    public List<String> cachedDatabaseNames() {
        return this.cachedDatabaseMap().keys().toList();
    }

    public List<String> cachedCollectionNames() {
        return this.cachedMongoDAOMap().keys().toList();
    }

    private final void DocumentDao$lzycompute$1() {
        DatabaseProvider databaseProvider = this;
        synchronized (databaseProvider) {
            if (this.DocumentDao$module == null) {
                this.DocumentDao$module = new DatabaseProvider$DocumentDao$(this);
            }
        }
    }

    public DatabaseProvider(MongoConfig config, CodecRegistry registry) {
        this.config = config;
        this.registry = registry;
        this.cachedDatabaseMap = new HashMap();
        this.cachedMongoDAOMap = new HashMap();
        this.cachedClient = None$.MODULE$;
        this.defaultDatabaseName = config.database();
    }

    public class DocumentDao
    extends MongoDAO<Document>
    implements Product,
    Serializable {
        private final DatabaseProvider provider;
        private final String collectionName;
        public final /* synthetic */ DatabaseProvider $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DatabaseProvider provider() {
            return this.provider;
        }

        public String collectionName() {
            return this.collectionName;
        }

        public DocumentDao copy(DatabaseProvider provider, String collectionName) {
            return new DocumentDao(this.dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer(), provider, collectionName);
        }

        public DatabaseProvider copy$default$1() {
            return this.provider();
        }

        public String copy$default$2() {
            return this.collectionName();
        }

        public String productPrefix() {
            return "DocumentDao";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.provider();
                }
                case 1: {
                    return this.collectionName();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DocumentDao;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "provider";
                }
                case 1: {
                    return "collectionName";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DocumentDao)) return false;
            if (((DocumentDao)object).dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer() != this.dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DocumentDao documentDao = (DocumentDao)x$1;
            DatabaseProvider databaseProvider = this.provider();
            DatabaseProvider databaseProvider2 = documentDao.provider();
            if (databaseProvider == null) {
                if (databaseProvider2 != null) {
                    return false;
                }
            } else if (!databaseProvider.equals(databaseProvider2)) return false;
            String string = this.collectionName();
            String string2 = documentDao.collectionName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!documentDao.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DatabaseProvider dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer() {
            return this.$outer;
        }

        public DocumentDao(DatabaseProvider $outer, DatabaseProvider provider, String collectionName) {
            this.provider = provider;
            this.collectionName = collectionName;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer, collectionName, ClassTag$.MODULE$.apply(Document.class));
            Product.$init$((Product)this);
        }
    }
}

