/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.database;

import com.mongodb.MongoCommandException;
import dev.mongocamp.driver.mongodb.MongoDAO;
import dev.mongocamp.driver.mongodb.database.ChangeObserver;
import dev.mongocamp.driver.mongodb.database.CollectionInfo;
import dev.mongocamp.driver.mongodb.database.CollectionInfo$;
import dev.mongocamp.driver.mongodb.database.CollectionStatus;
import dev.mongocamp.driver.mongodb.database.CollectionStatus$;
import dev.mongocamp.driver.mongodb.database.CompactResult;
import dev.mongocamp.driver.mongodb.database.DatabaseInfo;
import dev.mongocamp.driver.mongodb.database.DatabaseInfo$;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider$;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider$DocumentDao$;
import dev.mongocamp.driver.mongodb.database.MongoConfig;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.driver.mongodb.package$;
import java.io.Serializable;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.mongodb.scala.ListCollectionsObservable;
import org.mongodb.scala.ListDatabasesObservable;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.Observable;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.gridfs.GridFSBucket;
import org.mongodb.scala.gridfs.GridFSBucket$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rMg\u0001B-[\u0001\u0015D\u0001\u0002\u001f\u0001\u0003\u0006\u0004%\t!\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005u\"Iq\u0010\u0001BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u00037\u0001!\u0011!Q\u0001\n\u0005\r\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003SA\u0001\"a\u0016\u0001A\u0003%\u00111\u0006\u0005\n\u00033\u0002!\u0019!C\u0005\u00037B\u0001\"a \u0001A\u0003%\u0011Q\f\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0011\"!%\u0001\u0001\u0004%I!a%\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003\u000bC\u0011\"!)\u0001\u0005\u0004%\t!a)\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003wAq!a*\u0001\t\u0003\tI\u000bC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\tI\u000e\u0001C\u0001\u00037D\u0011\"a>\u0001#\u0003%\t!!?\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!I!q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005S\u0001\u0011\u0013!C\u0001\u0005WAqAa\f\u0001\t\u0003\u0011\t\u0004C\u0005\u00036\u0001\t\n\u0011\"\u0001\u0003,!11\f\u0001C\u0001\u0005oA\u0011Ba\u000f\u0001#\u0003%\t!!?\t\u000f\tu\u0002\u0001\"\u0001\u0003@!I!Q\n\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011%\u0011Y\u0006AI\u0001\n\u0003\tI\u0010C\u0004\u0003^\u0001!\tAa\u0018\t\u0013\t-\u0004!%A\u0005\u0002\u0005e\bb\u0002B7\u0001\u0011\u0005!q\u000e\u0005\n\u0005g\u0002\u0011\u0013!C\u0001\u0003sDqA!\u001e\u0001\t\u0003\u00119\bC\u0005\u0003\u0002\u0002\t\n\u0011\"\u0001\u0002z\"9!1\u0011\u0001\u0005\u0002\t\u0015\u0005\"\u0003BM\u0001E\u0005I\u0011AA}\u0011\u001d\t)\u0004\u0001C\u0001\u00057CqAa4\u0001\t\u0003\u0011\t\u000eC\u0004\u0003X\u0002!\tA!7\t\u000f\tu\u0007\u0001\"\u0001\u0003`\"9!\u0011\u001f\u0001\u0005\u0002\tM\bb\u0002B|\u0001\u0011\u0005!\u0011 \u0005\b\u0005w\u0004A\u0011\u0001B}\r\u0019\u0011i\u0010\u0001!\u0003\u0000\"Q1qA\u0019\u0003\u0016\u0004%\ta!\u0003\t\u0015\r-\u0011G!E!\u0002\u0013\t\t\u0003\u0003\u0006\u0003\u0016F\u0012)\u001a!C\u0001\u0003GC!b!\u00042\u0005#\u0005\u000b\u0011BA\u001e\u0011\u001d\ti\"\rC\u0001\u0007\u001fA\u0011b!\u00072\u0003\u0003%\taa\u0007\t\u0013\r\u0005\u0012'%A\u0005\u0002\r\r\u0002\"CB\u0014cE\u0005I\u0011AA}\u0011%\u0019I#MA\u0001\n\u0003\u001aY\u0003C\u0005\u00042E\n\t\u0011\"\u0001\u00044!I1QG\u0019\u0002\u0002\u0013\u00051q\u0007\u0005\n\u0007w\t\u0014\u0011!C!\u0007{A\u0011ba\u00122\u0003\u0003%\ta!\u0013\t\u0013\r5\u0013'!A\u0005B\r=\u0003\"CB*c\u0005\u0005I\u0011IB+\u0011%\u00199&MA\u0001\n\u0003\u001aIfB\u0005\u0004^\u0001\t\t\u0011#\u0001\u0004`\u0019I!Q \u0001\u0002\u0002#\u00051\u0011\r\u0005\b\u0003;\u0019E\u0011AB=\u0011%\u0019YhQA\u0001\n\u000b\u001ai\bC\u0005\u0004\u0000\r\u000b\t\u0011\"!\u0004\u0002\"I1qQ\"\u0002\u0002\u0013\u00055\u0011R\u0004\b\u0007/S\u0006\u0012ABM\r\u0019I&\f#\u0001\u0004\u001c\"9\u0011QD%\u0005\u0002\ru\u0005\"CBP\u0013\n\u0007I\u0011AB\u0016\u0011!\u0019\t+\u0013Q\u0001\n\r5\u0002\"CBR\u0013\n\u0007I\u0011AB\u0016\u0011!\u0019)+\u0013Q\u0001\n\r5\u0002\"CBT\u0013\n\u0007I\u0011BA\u0001\u0011!\u0019I+\u0013Q\u0001\n\u0005\r\u0001\"CBV\u0013\n\u0007I\u0011BA\u0001\u0011!\u0019i+\u0013Q\u0001\n\u0005\r\u0001bBB@\u0013\u0012\u00051q\u0016\u0005\n\u0007kK\u0015\u0013!C\u0001\u0007oCqaa/J\t\u0003\u0019i\fC\u0005\u0004F&\u000b\n\u0011\"\u0001\u0002z\"I1qY%\u0012\u0002\u0013\u00051q\u0017\u0005\n\u0007\u0013L\u0015\u0011!C\u0005\u0007\u0017\u0014\u0001\u0003R1uC\n\f7/\u001a)s_ZLG-\u001a:\u000b\u0005mc\u0016\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u0005us\u0016aB7p]\u001e|GM\u0019\u0006\u0003?\u0002\fa\u0001\u001a:jm\u0016\u0014(BA1c\u0003%iwN\\4pG\u0006l\u0007OC\u0001d\u0003\r!WM^\u0002\u0001'\r\u0001a\r\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0002S\u0006)1oY1mC&\u00111\u000e\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055,hB\u00018t\u001d\ty'/D\u0001q\u0015\t\tH-\u0001\u0004=e>|GOP\u0005\u0002S&\u0011A\u000f[\u0001\ba\u0006\u001c7.Y4f\u0013\t1xO\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002uQ\u000611m\u001c8gS\u001e,\u0012A\u001f\t\u0003wrl\u0011AW\u0005\u0003{j\u00131\"T8oO>\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0003:fO&\u001cHO]=\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003/i!!a\u0002\u000b\t\u0005%\u00111B\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\t\u00055\u0011qB\u0001\u0007G>$WmY:\u000b\t\u0005E\u00111C\u0001\u0005EN|gN\u0003\u0002\u0002\u0016\u0005\u0019qN]4\n\t\u0005e\u0011q\u0001\u0002\u000e\u0007>$Wm\u0019*fO&\u001cHO]=\u0002\u0013I,w-[:uef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004\u0002\"\u0005\r\u0012Q\u0005\t\u0003w\u0002AQ\u0001_\u0003A\u0002iDaa`\u0003A\u0002\u0005\r\u0011!E2bG\",G\rR1uC\n\f7/Z'baV\u0011\u00111\u0006\t\t\u0003[\t9$a\u000f\u0002L5\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0004nkR\f'\r\\3\u000b\u0007\u0005U\u0002.\u0001\u0006d_2dWm\u0019;j_:LA!!\u000f\u00020\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u001f\u0003\u000brA!a\u0010\u0002BA\u0011q\u000e[\u0005\u0004\u0003\u0007B\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0005%#AB*ue&twMC\u0002\u0002D!\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004S\u0006E#bA/\u0002\u0014%!\u0011QKA(\u00055iuN\\4p\t\u0006$\u0018MY1tK\u0006\u00112-Y2iK\u0012$\u0015\r^1cCN,W*\u00199!\u0003E\u0019\u0017m\u00195fI6{gnZ8E\u0003>k\u0015\r]\u000b\u0003\u0003;\u0002\u0002\"!\f\u00028\u0005m\u0012q\f\t\u0007\u0003C\n\u0019'a\u001a\u000e\u0003qK1!!\u001a]\u0005!iuN\\4p\t\u0006{\u0005\u0003BA5\u0003srA!a\u001b\u0002x9!\u0011QNA;\u001d\u0011\ty'a\u001d\u000f\u0007=\f\t(\u0003\u0002\u0002\u0016%\u0019Q,a\u0005\n\u0007%\f\t&C\u0002u\u0003\u001fJA!a\u001f\u0002~\tAAi\\2v[\u0016tGOC\u0002u\u0003\u001f\n!cY1dQ\u0016$Wj\u001c8h_\u0012\u000bu*T1qA\u0005a1-Y2iK\u0012\u001cE.[3oiV\u0011\u0011Q\u0011\t\u0006O\u0006\u001d\u00151R\u0005\u0004\u0003\u0013C'AB(qi&|g\u000e\u0005\u0003\u0002N\u00055\u0015\u0002BAH\u0003\u001f\u00121\"T8oO>\u001cE.[3oi\u0006\u00012-Y2iK\u0012\u001cE.[3oi~#S-\u001d\u000b\u0005\u0003+\u000bY\nE\u0002h\u0003/K1!!'i\u0005\u0011)f.\u001b;\t\u0013\u0005u5\"!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005i1-Y2iK\u0012\u001cE.[3oi\u0002\n1\u0003R3gCVdG\u000fR1uC\n\f7/\u001a(b[\u0016,\"!a\u000f\u0002)\u0011+g-Y;mi\u0012\u000bG/\u00192bg\u0016t\u0015-\\3!\u0003\u0019\u0019G.[3oiV\u0011\u00111R\u0001\tSN\u001cEn\\:fIV\u0011\u0011q\u0016\t\u0004O\u0006E\u0016bAAZQ\n9!i\\8mK\u0006t\u0017aC2m_N,7\t\\5f]R$\"!!&\u0002\u0013\u0011\fG/\u00192bg\u0016\u001cXCAA_!\u0019\ti%a0\u0002h%!\u0011\u0011YA(\u0005]a\u0015n\u001d;ECR\f'-Y:fg>\u00137/\u001a:wC\ndW-A\u0007eCR\f'-Y:f\u0013:4wn]\u000b\u0003\u0003\u000f\u0004R!\\Ae\u0003\u001bL1!a3x\u0005\u0011a\u0015n\u001d;\u0011\u0007m\fy-C\u0002\u0002Rj\u0013A\u0002R1uC\n\f7/Z%oM>\fQ\u0002Z1uC\n\f7/\u001a(b[\u0016\u001cXCAAl!\u0015i\u0017\u0011ZA\u001e\u00031!'o\u001c9ECR\f'-Y:f)\u0011\ti.a=\u0011\r\u00055\u0013q\\Ar\u0013\u0011\t\t/a\u0014\u0003!MKgn\u001a7f\u001f\n\u001cXM\u001d<bE2,\u0007\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0006!!.\u0019<b\u0013\u0011\t\t0a:\u0003\tY{\u0017\u000e\u001a\u0005\n\u0003k,\u0002\u0013!a\u0001\u0003w\tA\u0002Z1uC\n\f7/\u001a(b[\u0016\fa\u0003\u001a:pa\u0012\u000bG/\u00192bg\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003wTC!a\u000f\u0002~.\u0012\u0011q \t\u0005\u0005\u0003\u0011Y!\u0004\u0002\u0003\u0004)!!Q\u0001B\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0003\n!\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iAa\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bd_6\u0004\u0018m\u0019;ECR\f'-Y:f)\u0019\u0011\u0019Ba\u0007\u0003\u001eA)Q.!3\u0003\u0016A\u00191Pa\u0006\n\u0007\te!LA\u0007D_6\u0004\u0018m\u0019;SKN,H\u000e\u001e\u0005\n\u0003k<\u0002\u0013!a\u0001\u0003wA\u0011Ba\b\u0018!\u0003\u0005\rA!\t\u0002)5\f\u0007pV1jiB+'oQ8mY\u0016\u001cG/[8o!\r9'1E\u0005\u0004\u0005KA'aA%oi\u0006I2m\\7qC\u000e$H)\u0019;bE\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132\u0003e\u0019w.\u001c9bGR$\u0015\r^1cCN,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t5\"\u0006\u0002B\u0011\u0003{\fqaY8na\u0006\u001cG\u000f\u0006\u0003\u0003\u0014\tM\u0002\"\u0003B\u00105A\u0005\t\u0019\u0001B\u0011\u0003E\u0019w.\u001c9bGR$C-\u001a4bk2$H%\r\u000b\u0005\u0003\u0017\u0012I\u0004C\u0005\u0002vr\u0001\n\u00111\u0001\u0002<\u0005\u0011B-\u0019;bE\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00132\u0003E\tG\rZ\"iC:<Wm\u00142tKJ4XM\u001d\u000b\u0007\u0005\u0003\u00129Ea\u0013\u0011\u000bm\u0014\u0019%a\u001a\n\u0007\t\u0015#L\u0001\bDQ\u0006tw-Z(cg\u0016\u0014h/\u001a:\t\u000f\t%c\u00041\u0001\u0003B\u0005AqNY:feZ,'\u000fC\u0005\u0002vz\u0001\n\u00111\u0001\u0002<\u0005Y\u0012\r\u001a3DQ\u0006tw-Z(cg\u0016\u0014h/\u001a:%I\u00164\u0017-\u001e7uII\n1bY8mY\u0016\u001cG/[8ogR!!1\u000bB-!\u0019\tiE!\u0016\u0002h%!!qKA(\u0005ea\u0015n\u001d;D_2dWm\u0019;j_:\u001cxJY:feZ\f'\r\\3\t\u0013\u0005U\b\u0005%AA\u0002\u0005m\u0012!F2pY2,7\r^5p]N$C-\u001a4bk2$H%M\u0001\u0010G>dG.Z2uS>t\u0017J\u001c4pgR!!\u0011\rB5!\u0015i\u0017\u0011\u001aB2!\rY(QM\u0005\u0004\u0005OR&AD\"pY2,7\r^5p]&sgm\u001c\u0005\n\u0003k\u0014\u0003\u0013!a\u0001\u0003w\t\u0011dY8mY\u0016\u001cG/[8o\u0013:4wn\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005y1m\u001c7mK\u000e$\u0018n\u001c8OC6,7\u000f\u0006\u0003\u0002X\nE\u0004\"CA{IA\u0005\t\u0019AA\u001e\u0003e\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002\u0015I,hnQ8n[\u0006tG\r\u0006\u0004\u0003z\tm$q\u0010\t\u0007\u0003\u001b\ny.a\u001a\t\u000f\tud\u00051\u0001\u0002h\u0005AAm\\2v[\u0016tG\u000fC\u0005\u0002v\u001a\u0002\n\u00111\u0001\u0002<\u0005!\"/\u001e8D_6l\u0017M\u001c3%I\u00164\u0017-\u001e7uII\n\u0001cY8mY\u0016\u001cG/[8o'R\fG/^:\u0015\r\t\u001d%1\u0013BL!\u0019\tiE!#\u0003\u000e&!!1RA(\u0005)y%m]3sm\u0006\u0014G.\u001a\t\u0004w\n=\u0015b\u0001BI5\n\u00012i\u001c7mK\u000e$\u0018n\u001c8Ti\u0006$Xo\u001d\u0005\b\u0005+C\u0003\u0019AA\u001e\u00039\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016D\u0011\"!>)!\u0003\u0005\r!a\u000f\u00025\r|G\u000e\\3di&|gn\u0015;biV\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tu%1\u0016\u000b\u0005\u0005?\u0013i\r\u0006\u0003\u0003\"\nu\u0006CBA'\u0005G\u00139+\u0003\u0003\u0003&\u0006=#aD'p]\u001e|7i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\t%&1\u0016\u0007\u0001\t\u001d\u0011iK\u000bb\u0001\u0005_\u0013\u0011!Q\t\u0005\u0005c\u00139\fE\u0002h\u0005gK1A!.i\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u001aB]\u0013\r\u0011Y\f\u001b\u0002\u0004\u0003:L\bb\u0002B`U\u0001\u000f!\u0011Y\u0001\u0003GR\u0004bAa1\u0003J\n\u001dVB\u0001Bc\u0015\r\u00119\r[\u0001\be\u00164G.Z2u\u0013\u0011\u0011YM!2\u0003\u0011\rc\u0017m]:UC\u001eDqA!&+\u0001\u0004\tY$A\thk\u0016\u001c8\u000fR1uC\n\f7/\u001a(b[\u0016$B!a\u000f\u0003T\"9!Q[\u0016A\u0002\u0005m\u0012AE7bs\n,7+\u001a9be\u0006$X\r\u001a(b[\u0016\f\u0011bZ;fgNt\u0015-\\3\u0015\t\u0005m\"1\u001c\u0005\b\u0005+d\u0003\u0019AA\u001e\u0003\u0019\u0011WoY6fiR!!\u0011\u001dBw!\u0011\u0011\u0019O!;\u000e\u0005\t\u0015(\u0002\u0002Bt\u0003\u001f\naa\u001a:jI\u001a\u001c\u0018\u0002\u0002Bv\u0005K\u0014Ab\u0012:jI\u001a\u001b&)^2lKRDqAa<.\u0001\u0004\tY$\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016\f1\u0001Z1p)\u0011\tyF!>\t\u000f\tUe\u00061\u0001\u0002<\u0005\u00192-Y2iK\u0012$\u0015\r^1cCN,g*Y7fgR\u0011\u0011q[\u0001\u0016G\u0006\u001c\u0007.\u001a3D_2dWm\u0019;j_:t\u0015-\\3t\u0005-!unY;nK:$H)Y8\u0014\rE\nyf!\u0001m!\r971A\u0005\u0004\u0007\u000bA'a\u0002)s_\u0012,8\r^\u0001\taJ|g/\u001b3feV\u0011\u0011\u0011E\u0001\naJ|g/\u001b3fe\u0002\nqbY8mY\u0016\u001cG/[8o\u001d\u0006lW\r\t\u000b\u0007\u0007#\u0019)ba\u0006\u0011\u0007\rM\u0011'D\u0001\u0001\u0011\u001d\u00199A\u000ea\u0001\u0003CAqA!&7\u0001\u0004\tY$\u0001\u0003d_BLHCBB\t\u0007;\u0019y\u0002C\u0005\u0004\b]\u0002\n\u00111\u0001\u0002\"!I!QS\u001c\u0011\u0002\u0003\u0007\u00111H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019)C\u000b\u0003\u0002\"\u0005u\u0018AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r5\u0002\u0003BAs\u0007_IA!a\u0012\u0002h\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00119l!\u000f\t\u0013\u0005uE(!AA\u0002\t\u0005\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r}\u0002CBB!\u0007\u0007\u00129,\u0004\u0002\u00024%!1QIA\u001a\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=61\n\u0005\n\u0003;s\u0014\u0011!a\u0001\u0005o\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!1QFB)\u0011%\tijPA\u0001\u0002\u0004\u0011\t#\u0001\u0005iCND7i\u001c3f)\t\u0011\t#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u001bY\u0006C\u0005\u0002\u001e\u0006\u000b\t\u00111\u0001\u00038\u0006YAi\\2v[\u0016tG\u000fR1p!\r\u0019\u0019bQ\n\u0006\u0007\u000e\r4q\u000e\t\u000b\u0007K\u001aY'!\t\u0002<\rEQBAB4\u0015\r\u0019I\u0007[\u0001\beVtG/[7f\u0013\u0011\u0019iga\u001a\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004r\r]TBAB:\u0015\u0011\u0019)(a;\u0002\u0005%|\u0017b\u0001<\u0004tQ\u00111qL\u0001\ti>\u001cFO]5oOR\u00111QF\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0007#\u0019\u0019i!\"\t\u000f\r\u001da\t1\u0001\u0002\"!9!Q\u0013$A\u0002\u0005m\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0017\u001b\u0019\nE\u0003h\u0003\u000f\u001bi\tE\u0004h\u0007\u001f\u000b\t#a\u000f\n\u0007\rE\u0005N\u0001\u0004UkBdWM\r\u0005\n\u0007+;\u0015\u0011!a\u0001\u0007#\t1\u0001\u001f\u00131\u0003A!\u0015\r^1cCN,\u0007K]8wS\u0012,'\u000f\u0005\u0002|\u0013N!\u0011JZB8)\t\u0019I*A\u0006PE*,7\r^%e\u0017\u0016L\u0018\u0001D(cU\u0016\u001cG/\u00133LKf\u0004\u0013aE\"pY2,7\r^5p]N+\u0007/\u0019:bi>\u0014\u0018\u0001F\"pY2,7\r^5p]N+\u0007/\u0019:bi>\u0014\b%\u0001\bDkN$x.\u001c*fO&\u001cHO]=\u0002\u001f\r+8\u000f^8n%\u0016<\u0017n\u001d;ss\u0002\nQbY8eK\u000e\u0014VmZ5tiJL\u0018AD2pI\u0016\u001c'+Z4jgR\u0014\u0018\u0010\t\u000b\u0007\u0003C\u0019\tla-\t\u000ba\u001c\u0006\u0019\u0001>\t\u0011}\u001c\u0006\u0013!a\u0001\u0003\u0007\tq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0007sSC!a\u0001\u0002~\u0006AaM]8n!\u0006$\b\u000e\u0006\u0004\u0002\"\r}61\u0019\u0005\n\u0007\u0003,\u0006\u0013!a\u0001\u0003w\t!bY8oM&<\u0007+\u0019;i\u0011!yX\u000b%AA\u0002\u0005\r\u0011A\u00054s_6\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIE\n!C\u001a:p[B\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111Q\u001a\t\u0005\u0003K\u001cy-\u0003\u0003\u0004R\u0006\u001d(AB(cU\u0016\u001cG\u000f")
public class DatabaseProvider
implements Serializable {
    private volatile DatabaseProvider$DocumentDao$ DocumentDao$module;
    private final MongoConfig config;
    private final CodecRegistry registry;
    private final HashMap<String, MongoDatabase> cachedDatabaseMap;
    private final HashMap<String, MongoDAO<Document>> cachedMongoDAOMap;
    private Option<MongoClient> cachedClient;
    private final String DefaultDatabaseName;

    public static CodecRegistry fromPath$default$2() {
        return DatabaseProvider$.MODULE$.fromPath$default$2();
    }

    public static String fromPath$default$1() {
        return DatabaseProvider$.MODULE$.fromPath$default$1();
    }

    public static DatabaseProvider fromPath(String configPath, CodecRegistry registry) {
        return DatabaseProvider$.MODULE$.fromPath(configPath, registry);
    }

    public static CodecRegistry apply$default$2() {
        return DatabaseProvider$.MODULE$.apply$default$2();
    }

    public static DatabaseProvider apply(MongoConfig config, CodecRegistry registry) {
        return DatabaseProvider$.MODULE$.apply(config, registry);
    }

    public static String CollectionSeparator() {
        return DatabaseProvider$.MODULE$.CollectionSeparator();
    }

    public static String ObjectIdKey() {
        return DatabaseProvider$.MODULE$.ObjectIdKey();
    }

    public DatabaseProvider$DocumentDao$ DocumentDao() {
        if (this.DocumentDao$module == null) {
            this.DocumentDao$lzycompute$1();
        }
        return this.DocumentDao$module;
    }

    public MongoConfig config() {
        return this.config;
    }

    public CodecRegistry registry() {
        return this.registry;
    }

    private HashMap<String, MongoDatabase> cachedDatabaseMap() {
        return this.cachedDatabaseMap;
    }

    private HashMap<String, MongoDAO<Document>> cachedMongoDAOMap() {
        return this.cachedMongoDAOMap;
    }

    private Option<MongoClient> cachedClient() {
        return this.cachedClient;
    }

    private void cachedClient_$eq(Option<MongoClient> x$1) {
        this.cachedClient = x$1;
    }

    public String DefaultDatabaseName() {
        return this.DefaultDatabaseName;
    }

    public MongoClient client() {
        block0: {
            if (!this.isClosed()) break block0;
            this.cachedDatabaseMap().clear();
            this.cachedMongoDAOMap().clear();
            this.cachedClient_$eq((Option<MongoClient>)new Some((Object)MongoClient$.MODULE$.apply(this.config().clientSettings())));
        }
        return (MongoClient)this.cachedClient().get();
    }

    public boolean isClosed() {
        return this.cachedClient().isEmpty();
    }

    public void closeClient() {
        this.client().close();
        this.cachedClient_$eq((Option<MongoClient>)None$.MODULE$);
    }

    public ListDatabasesObservable<Document> databases() {
        return this.client().listDatabases(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public List<DatabaseInfo> databaseInfos() {
        ObservableIncludes.GenericObservable<Document> qual$1 = package$.MODULE$.GenericObservable(this.databases());
        int x$12 = qual$1.resultList$default$1();
        return (List)qual$1.resultList(x$12).map((Function1 & Serializable)doc -> DatabaseInfo$.MODULE$.apply((Document)doc)).sortBy((Function1 & Serializable)x$1 -> x$1.name(), (Ordering)Ordering.String$.MODULE$);
    }

    public List<String> databaseNames() {
        return this.databaseInfos().map((Function1 & Serializable)info -> info.name());
    }

    public SingleObservable<Void> dropDatabase(String databaseName) {
        return this.database(databaseName).drop();
    }

    public String dropDatabase$default$1() {
        return this.DefaultDatabaseName();
    }

    public List<CompactResult> compactDatabase(String databaseName, int maxWaitPerCollection) {
        return this.collectionNames(databaseName).flatMap((Function1 & Serializable)collectionName -> package$.MODULE$.GenericObservable(this.dao((String)collectionName).compact()).result(maxWaitPerCollection));
    }

    public List<CompactResult> compact(int maxWaitPerCollection) {
        return this.databaseNames().flatMap((Function1 & Serializable)database -> {
            Nil$ nil$;
            try {
                nil$ = this.collectionNames((String)database).flatMap((Function1 & Serializable)collectionName -> package$.MODULE$.GenericObservable(this.dao((String)collectionName).compact()).result(maxWaitPerCollection));
            }
            catch (MongoCommandException e) {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        });
    }

    public String compactDatabase$default$1() {
        return this.DefaultDatabaseName();
    }

    public int compactDatabase$default$2() {
        return package$.MODULE$.DefaultMaxWait();
    }

    public int compact$default$1() {
        return package$.MODULE$.DefaultMaxWait();
    }

    public MongoDatabase database(String databaseName) {
        Object object = !this.cachedDatabaseMap().contains((Object)databaseName) ? this.cachedDatabaseMap().put((Object)databaseName, (Object)this.client().getDatabase(databaseName).withCodecRegistry(this.registry())) : BoxedUnit.UNIT;
        return (MongoDatabase)this.cachedDatabaseMap().apply((Object)databaseName);
    }

    public String database$default$1() {
        return this.DefaultDatabaseName();
    }

    public ChangeObserver<Document> addChangeObserver(ChangeObserver<Document> observer, String databaseName) {
        this.database(databaseName).watch(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).subscribe(observer);
        return observer;
    }

    public String addChangeObserver$default$2() {
        return this.DefaultDatabaseName();
    }

    public ListCollectionsObservable<Document> collections(String databaseName) {
        return this.database(databaseName).listCollections(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public List<CollectionInfo> collectionInfos(String databaseName) {
        ObservableIncludes.GenericObservable<Document> qual$1 = package$.MODULE$.GenericObservable(this.collections(databaseName));
        int x$1 = qual$1.resultList$default$1();
        return (List)qual$1.resultList(x$1).map((Function1 & Serializable)doc -> CollectionInfo$.MODULE$.apply((Document)doc)).sortBy((Function1 & Serializable)x$2 -> x$2.name(), (Ordering)Ordering.String$.MODULE$);
    }

    public List<String> collectionNames(String databaseName) {
        return this.collectionInfos(databaseName).map((Function1 & Serializable)info -> info.name());
    }

    public SingleObservable<Document> runCommand(Document document, String databaseName) {
        return this.database(databaseName).runCommand((Bson)document, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public String runCommand$default$2() {
        return this.DefaultDatabaseName();
    }

    public Observable<CollectionStatus> collectionStatus(String collectionName, String databaseName) {
        return this.runCommand(package$.MODULE$.documentFromScalaMap((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collStats"), (Object)collectionName)})))), databaseName).map((Function1 & Serializable)document -> CollectionStatus$.MODULE$.apply((Document)document));
    }

    public <A> MongoCollection<A> collection(String collectionName, ClassTag<A> ct) {
        if (collectionName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            String newDatabaseName = this.guessDatabaseName(collectionName);
            String newCollectionName = this.guessName(collectionName);
            return this.database(newDatabaseName).getCollection(newCollectionName, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ct);
        }
        return this.database(this.database$default$1()).getCollection(collectionName, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ct);
    }

    public String collections$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionInfos$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionNames$default$1() {
        return this.DefaultDatabaseName();
    }

    public String collectionStatus$default$2() {
        return this.DefaultDatabaseName();
    }

    public String guessDatabaseName(String maybeSeparatedName) {
        if (maybeSeparatedName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            return maybeSeparatedName.substring(0, maybeSeparatedName.indexOf(DatabaseProvider$.MODULE$.CollectionSeparator()));
        }
        return this.DefaultDatabaseName();
    }

    public String guessName(String maybeSeparatedName) {
        if (maybeSeparatedName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            return maybeSeparatedName.substring(maybeSeparatedName.indexOf(DatabaseProvider$.MODULE$.CollectionSeparator()) + 1);
        }
        return maybeSeparatedName;
    }

    public GridFSBucket bucket(String bucketName) {
        if (bucketName.contains(DatabaseProvider$.MODULE$.CollectionSeparator())) {
            String newDatabaseName = this.guessDatabaseName(bucketName);
            String newBucketName = this.guessName(bucketName);
            return GridFSBucket$.MODULE$.apply(this.database(newDatabaseName), newBucketName);
        }
        return GridFSBucket$.MODULE$.apply(this.database(this.database$default$1()), bucketName);
    }

    public MongoDAO<Document> dao(String collectionName) {
        Object object = !this.cachedMongoDAOMap().contains((Object)collectionName) ? this.cachedMongoDAOMap().put((Object)collectionName, (Object)new DocumentDao(this, this, collectionName)) : BoxedUnit.UNIT;
        return (MongoDAO)this.cachedMongoDAOMap().apply((Object)collectionName);
    }

    public List<String> cachedDatabaseNames() {
        return this.cachedDatabaseMap().keys().toList();
    }

    public List<String> cachedCollectionNames() {
        return this.cachedMongoDAOMap().keys().toList();
    }

    private final void DocumentDao$lzycompute$1() {
        DatabaseProvider databaseProvider = this;
        synchronized (databaseProvider) {
            if (this.DocumentDao$module == null) {
                this.DocumentDao$module = new DatabaseProvider$DocumentDao$(this);
            }
        }
    }

    public DatabaseProvider(MongoConfig config, CodecRegistry registry) {
        this.config = config;
        this.registry = registry;
        this.cachedDatabaseMap = new HashMap();
        this.cachedMongoDAOMap = new HashMap();
        this.cachedClient = None$.MODULE$;
        this.DefaultDatabaseName = config.database();
    }

    public class DocumentDao
    extends MongoDAO<Document>
    implements Product,
    Serializable {
        private final DatabaseProvider provider;
        private final String collectionName;
        public final /* synthetic */ DatabaseProvider $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public DatabaseProvider provider() {
            return this.provider;
        }

        public String collectionName() {
            return this.collectionName;
        }

        public DocumentDao copy(DatabaseProvider provider, String collectionName) {
            return new DocumentDao(this.dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer(), provider, collectionName);
        }

        public DatabaseProvider copy$default$1() {
            return this.provider();
        }

        public String copy$default$2() {
            return this.collectionName();
        }

        public String productPrefix() {
            return "DocumentDao";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.provider();
                }
                case 1: {
                    return this.collectionName();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DocumentDao;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "provider";
                }
                case 1: {
                    return "collectionName";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DocumentDao)) return false;
            if (((DocumentDao)object).dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer() != this.dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DocumentDao documentDao = (DocumentDao)x$1;
            DatabaseProvider databaseProvider = this.provider();
            DatabaseProvider databaseProvider2 = documentDao.provider();
            if (databaseProvider == null) {
                if (databaseProvider2 != null) {
                    return false;
                }
            } else if (!databaseProvider.equals(databaseProvider2)) return false;
            String string = this.collectionName();
            String string2 = documentDao.collectionName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!documentDao.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DatabaseProvider dev$mongocamp$driver$mongodb$database$DatabaseProvider$DocumentDao$$$outer() {
            return this.$outer;
        }

        public DocumentDao(DatabaseProvider $outer, DatabaseProvider provider, String collectionName) {
            this.provider = provider;
            this.collectionName = collectionName;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer, collectionName, ClassTag$.MODULE$.apply(Document.class));
            Product.$init$((Product)this);
        }
    }
}

