/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.bson;

import dev.mongocamp.driver.mongodb.bson.AbstractConverterPlugin;
import dev.mongocamp.driver.mongodb.bson.BaseConverterPlugin;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDecimal128$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonDouble$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonRegularExpression$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.mutable.Document$;
import org.mongodb.scala.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class BsonConverter$ {
    public static final BsonConverter$ MODULE$ = new BsonConverter$();
    private static final String DocumentKeyDivider = ".";
    private static AbstractConverterPlugin converterPlugin = new BaseConverterPlugin();

    public String DocumentKeyDivider() {
        return DocumentKeyDivider;
    }

    public boolean hasRelation(String key) {
        return key.indexOf(this.DocumentKeyDivider()) != -1;
    }

    public String relationKey(String key) {
        return key.substring(0, key.indexOf(this.DocumentKeyDivider()));
    }

    public String newKeyFromRelation(String key) {
        return key.substring(key.indexOf(this.DocumentKeyDivider()) + 1);
    }

    public String lastKeyFromRelation(String key) {
        return key.substring(key.lastIndexOf(this.DocumentKeyDivider()) + 1);
    }

    public Option<Object> documentValueOption(Document document, String key) {
        while (this.hasRelation(key)) {
            String newKey = this.newKeyFromRelation(key);
            String relation = this.relationKey(key);
            if (document.contains(relation) && this.documentValueOption(document, relation).isDefined()) {
                Object value = this.documentValueOption(document, relation).get();
                Object object = value;
                if (object instanceof Document) {
                    Document document2 = (Document)object;
                    key = newKey;
                    document = document2;
                    continue;
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        if (document.contains(key)) {
            return new Some(this.fromBson(document.apply(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class))));
        }
        return None$.MODULE$;
    }

    public Document updateDocumentValue(Document document, String key, Object value) {
        org.mongodb.scala.bson.collection.mutable.Document doc = Document$.MODULE$.apply(document.toJson());
        org.mongodb.scala.bson.collection.mutable.Document result = this.updateDocumentValueInternal(doc, key, value, this.updateDocumentValueInternal$default$4());
        return package$.MODULE$.Document().apply(result.toJson());
    }

    private org.mongodb.scala.bson.collection.mutable.Document updateDocumentValueInternal(org.mongodb.scala.bson.collection.mutable.Document document, String key, Object value, Option<org.mongodb.scala.bson.collection.mutable.Document> root) {
        while (this.hasRelation(key)) {
            String newKey = this.newKeyFromRelation(key);
            String relation = this.relationKey(key);
            Document relatedDocument = package$.MODULE$.Document().apply();
            Option<Object> relationValue = this.documentValueOption(package$.MODULE$.Document().apply(document.toJson()), relation);
            if (relationValue.isDefined()) {
                Object value2 = relationValue.get();
                Object object = value2;
                if (object instanceof Document) {
                    Document document2;
                    relatedDocument = document2 = (Document)object;
                }
            }
            org.mongodb.scala.bson.collection.mutable.Document mutableDoc = Document$.MODULE$.apply(relatedDocument.toJson());
            document.put(relation, (Object)mutableDoc, (BsonTransformer)BsonTransformer$.MODULE$.TransformMutableDocument());
            if (root.isEmpty()) {
                root = new Some((Object)document);
                key = newKey;
                document = mutableDoc;
                continue;
            }
            key = newKey;
            document = mutableDoc;
        }
        document.put(key, (Object)this.toBson(value), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        if (root.isEmpty()) {
            return document;
        }
        return (org.mongodb.scala.bson.collection.mutable.Document)root.get();
    }

    private Option<org.mongodb.scala.bson.collection.mutable.Document> updateDocumentValueInternal$default$4() {
        return None$.MODULE$;
    }

    public AbstractConverterPlugin converterPlugin() {
        return converterPlugin;
    }

    public void converterPlugin_$eq(AbstractConverterPlugin x$1) {
        converterPlugin = x$1;
    }

    public BsonValue toBson(Object value) {
        Object object;
        block27: {
            while (true) {
                if ((object = value) instanceof BsonValue) {
                    BsonValue bsonValue = (BsonValue)object;
                    return bsonValue;
                }
                if (!(object instanceof Option)) break block27;
                Option option = (Option)object;
                if (!option.isDefined()) break;
                value = option.get();
            }
            return BsonNull$.MODULE$.apply();
        }
        if (object instanceof Object) {
            Object object2 = object;
            if (this.converterPlugin().hasCustomClass(object2)) {
                return this.converterPlugin().toBson(object2);
            }
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return BsonBoolean$.MODULE$.apply(bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            return BsonString$.MODULE$.apply(string);
        }
        if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            return BsonString$.MODULE$.apply(Character.toString(c));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return BsonBinary$.MODULE$.apply(byArray);
        }
        if (object instanceof Regex) {
            Regex regex = (Regex)object;
            return BsonRegularExpression$.MODULE$.apply(regex);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return BsonDateTime$.MODULE$.apply(date);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return BsonDateTime$.MODULE$.apply(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return BsonDateTime$.MODULE$.apply(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (object instanceof ObjectId) {
            ObjectId objectId = (ObjectId)object;
            return BsonObjectId$.MODULE$.apply(objectId);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return BsonInt32$.MODULE$.apply(n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return BsonInt64$.MODULE$.apply(l);
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            return BsonInt64$.MODULE$.apply(bigInt.toLong());
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return BsonInt64$.MODULE$.apply(bigInteger.longValue());
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return BsonDouble$.MODULE$.apply(d);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return BsonDouble$.MODULE$.apply((double)f);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BsonDecimal128$.MODULE$.apply(bigDecimal);
        }
        if (object instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
            return BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            return BsonDocument$.MODULE$.apply((Iterable)document);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            ObjectRef doc = ObjectRef.create((Object)package$.MODULE$.Document().apply());
            map.keys().foreach((Function1 & Serializable)key -> {
                BsonConverter$.$anonfun$toBson$1(map, doc, key);
                return BoxedUnit.UNIT;
            });
            return BsonDocument$.MODULE$.apply((Iterable)((Document)doc.elem));
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            ObjectRef doc = ObjectRef.create((Object)package$.MODULE$.Document().apply());
            CollectionConverters$.MODULE$.SetHasAsScala(map.keySet()).asScala().foreach((Function1 & Serializable)key -> {
                BsonConverter$.$anonfun$toBson$2(map, doc, key);
                return BoxedUnit.UNIT;
            });
            return BsonDocument$.MODULE$.apply((Iterable)((Document)doc.elem));
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return BsonArray$.MODULE$.fromIterable((Iterable)iterable.map((Function1 & Serializable)v -> MODULE$.toBson(v)));
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            return BsonArray$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)v -> MODULE$.toBson(v)));
        }
        if (object instanceof Object) {
            Object object3 = object;
            return this.converterPlugin().objectToBson(object3);
        }
        return BsonNull$.MODULE$.apply();
    }

    public Object fromBson(BsonValue value) {
        BsonValue bsonValue = value;
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean bsonBoolean = (BsonBoolean)bsonValue;
            return BoxesRunTime.boxToBoolean((boolean)bsonBoolean.getValue());
        }
        if (bsonValue instanceof BsonString) {
            BsonString bsonString = (BsonString)bsonValue;
            return bsonString.getValue();
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary bsonBinary = (BsonBinary)bsonValue;
            return bsonBinary.getData();
        }
        if (bsonValue instanceof BsonRegularExpression) {
            BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)bsonValue;
            return bsonRegularExpression.getPattern();
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime bsonDateTime = (BsonDateTime)bsonValue;
            return new Date(bsonDateTime.getValue());
        }
        if (bsonValue instanceof BsonTimestamp) {
            BsonTimestamp bsonTimestamp = (BsonTimestamp)bsonValue;
            return new Date(bsonTimestamp.getTime());
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId bsonObjectId = (BsonObjectId)bsonValue;
            return bsonObjectId.getValue();
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 bsonInt32 = (BsonInt32)bsonValue;
            return BoxesRunTime.boxToInteger((int)bsonInt32.getValue());
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 bsonInt64 = (BsonInt64)bsonValue;
            return BoxesRunTime.boxToLong((long)bsonInt64.getValue());
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble bsonDouble = (BsonDouble)bsonValue;
            return BoxesRunTime.boxToDouble((double)bsonDouble.doubleValue());
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 bsonDecimal128 = (BsonDecimal128)bsonValue;
            return bsonDecimal128.getValue().bigDecimalValue();
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)bsonValue;
            return package$.MODULE$.Document().apply(bsonDocument);
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)bsonValue;
            return CollectionConverters$.MODULE$.ListHasAsScala(bsonArray.getValues()).asScala().toList().map((Function1 & Serializable)v -> MODULE$.fromBson((BsonValue)v));
        }
        if (bsonValue instanceof BsonNull) {
            return null;
        }
        return value;
    }

    public scala.collection.immutable.Map<String, Object> asMap(Document document) {
        HashMap result = new HashMap();
        document.keySet().foreach((Function1 & Serializable)key -> {
            Object value = MODULE$.fromBson(document.apply(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
            Object object = value;
            if (object instanceof Document) {
                Document document = (Document)object;
                return (HashMap)result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), MODULE$.asMap(document)));
            }
            if (object instanceof List) {
                List list = (List)object;
                return (HashMap)result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)list.map((Function1 & Serializable)d -> {
                    if (d instanceof Document) {
                        return MODULE$.asMap((Document)d);
                    }
                    return d;
                })));
            }
            return (HashMap)result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public List<scala.collection.immutable.Map<String, Object>> asMapList(List<Document> documents) {
        ArrayBuffer result = new ArrayBuffer();
        documents.foreach((Function1 & Serializable)document -> (ArrayBuffer)result.$plus$eq(MODULE$.asMap((Document)document)));
        return result.toList();
    }

    public static final /* synthetic */ void $anonfun$toBson$1(Map x23$1, ObjectRef doc$1, Object key) {
        Object v = x23$1.apply(key);
        doc$1.elem = (Document)((Document)doc$1.elem).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)MODULE$.toBson(v)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue())}));
    }

    public static final /* synthetic */ void $anonfun$toBson$2(java.util.Map x24$1, ObjectRef doc$2, Object key) {
        Object v = x24$1.get(key);
        doc$2.elem = (Document)((Document)doc$2.elem).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)MODULE$.toBson(v)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue())}));
    }

    private BsonConverter$() {
    }
}

