/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.server;

import com.typesafe.config.Config;
import dev.mongocamp.driver.mongodb.database.ConfigHelper;
import dev.mongocamp.driver.mongodb.server.H2BackendConfig;
import dev.mongocamp.driver.mongodb.server.ServerBackend$;
import dev.mongocamp.driver.mongodb.server.ServerConfig;
import java.io.Serializable;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ServerConfig$
implements ConfigHelper,
Serializable {
    public static final ServerConfig$ MODULE$ = new ServerConfig$();
    private static final String DefaultServerConfigPathPrefix;
    private static final String DefaultServerName;
    private static final String DefaultHost;
    private static final int DefaultPort;
    private static Config conf;

    static {
        ConfigHelper.$init$(MODULE$);
        DefaultServerConfigPathPrefix = "local.mongodb.server";
        DefaultServerName = "local-mongodb-server";
        DefaultHost = "localhost";
        DefaultPort = 28018;
    }

    @Override
    public Option<String> stringConfig(String configPath, String key, String string) {
        return ConfigHelper.stringConfig$(this, configPath, key, string);
    }

    @Override
    public String stringConfig$default$3() {
        return ConfigHelper.stringConfig$default$3$(this);
    }

    @Override
    public int intConfig(String configPath, String key, int n) {
        return ConfigHelper.intConfig$(this, configPath, key, n);
    }

    @Override
    public int intConfig$default$3() {
        return ConfigHelper.intConfig$default$3$(this);
    }

    @Override
    public boolean booleanConfig(String configPath, String key, boolean bl) {
        return ConfigHelper.booleanConfig$(this, configPath, key, bl);
    }

    @Override
    public boolean booleanConfig$default$3() {
        return ConfigHelper.booleanConfig$default$3$(this);
    }

    @Override
    public Config conf() {
        return conf;
    }

    @Override
    public void dev$mongocamp$driver$mongodb$database$ConfigHelper$_setter_$conf_$eq(Config x$1) {
        conf = x$1;
    }

    public String $lessinit$greater$default$1() {
        return this.DefaultServerName();
    }

    public String $lessinit$greater$default$2() {
        return this.DefaultHost();
    }

    public int $lessinit$greater$default$3() {
        return this.DefaultPort();
    }

    public Enumeration.Value $lessinit$greater$default$4() {
        return ServerBackend$.MODULE$.Memory();
    }

    public Option<H2BackendConfig> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public String DefaultServerConfigPathPrefix() {
        return DefaultServerConfigPathPrefix;
    }

    public String DefaultServerName() {
        return DefaultServerName;
    }

    public String DefaultHost() {
        return DefaultHost;
    }

    public int DefaultPort() {
        return DefaultPort;
    }

    public Enumeration.Value serverBackendFromString(String backendName) {
        return ServerBackend$.MODULE$.H2().toString().toLowerCase().equals(backendName.toLowerCase()) ? ServerBackend$.MODULE$.H2() : ServerBackend$.MODULE$.Memory();
    }

    /*
     * Unable to fully structure code
     */
    public ServerConfig fromPath(String configPath) {
        name = (String)this.stringConfig(configPath, "serverName", this.DefaultServerName()).get();
        host = (String)this.stringConfig(configPath, "host", this.DefaultHost()).get();
        port = this.intConfig(configPath, "port", this.DefaultPort());
        backend = (String)this.stringConfig(configPath, "backend", this.stringConfig$default$3()).get();
        v0 = serverBackend = this.serverBackendFromString(backend);
        var8_7 = ServerBackend$.MODULE$.H2();
        if (v0 != null ? v0.equals(var8_7) == false : var8_7 != null) ** GOTO lbl-1000
        if (this.conf().hasPath(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s.%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{configPath, "h2.inMemory"})))) {
            inMemory = this.booleanConfig(configPath, "h2.inMemory", this.booleanConfig$default$3());
            path = this.stringConfig(configPath, "h2.path", this.stringConfig$default$3());
            v1 = new Some((Object)new H2BackendConfig(inMemory, path));
        } else lbl-1000:
        // 2 sources

        {
            v1 = None$.MODULE$;
        }
        h2BackendConfig = v1;
        return new ServerConfig(name, host, port, serverBackend, (Option<H2BackendConfig>)h2BackendConfig);
    }

    public String fromPath$default$1() {
        return this.DefaultServerConfigPathPrefix();
    }

    public ServerConfig apply(String serverName, String host, int port, Enumeration.Value backend, Option<H2BackendConfig> h2BackendConfig) {
        return new ServerConfig(serverName, host, port, backend, h2BackendConfig);
    }

    public String apply$default$1() {
        return this.DefaultServerName();
    }

    public String apply$default$2() {
        return this.DefaultHost();
    }

    public int apply$default$3() {
        return this.DefaultPort();
    }

    public Enumeration.Value apply$default$4() {
        return ServerBackend$.MODULE$.Memory();
    }

    public Option<H2BackendConfig> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<Tuple5<String, String, Object, Enumeration.Value, Option<H2BackendConfig>>> unapply(ServerConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.serverName(), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.backend(), x$0.h2BackendConfig()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerConfig$.class);
    }

    private ServerConfig$() {
    }
}

