/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.database;

import com.mongodb.MongoClientSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.typesafe.config.Config;
import dev.mongocamp.driver.mongodb.database.ConfigHelper;
import dev.mongocamp.driver.mongodb.database.MongoConfig;
import dev.mongocamp.driver.mongodb.database.MongoPoolOptions;
import dev.mongocamp.driver.mongodb.database.MongoPoolOptions$;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class MongoConfig$
implements ConfigHelper,
Serializable {
    public static final MongoConfig$ MODULE$ = new MongoConfig$();
    private static final String DefaultHost;
    private static final int DefaultPort;
    private static final String DefaultAuthenticationDatabaseName;
    private static final String DefaultApplicationName;
    private static final int DefaultPoolMaxConnectionIdleTime;
    private static final int DefaultPoolMaxSize;
    private static final int DefaultPoolMinSize;
    private static final int DefaultPoolMaxWaitQueueSize;
    private static final int DefaultPoolMaintenanceInitialDelay;
    private static final String ComressionSnappy;
    private static final String ComressionZlib;
    private static final String ComressionZstd;
    private static final String DefaultConfigPathPrefix;
    private static Config conf;

    static {
        ConfigHelper.$init$(MODULE$);
        DefaultHost = "127.0.0.1";
        DefaultPort = 27017;
        DefaultAuthenticationDatabaseName = "admin";
        DefaultApplicationName = "mongocampdb-app";
        DefaultPoolMaxConnectionIdleTime = 60;
        DefaultPoolMaxSize = 50;
        DefaultPoolMinSize = 0;
        DefaultPoolMaxWaitQueueSize = 500;
        DefaultPoolMaintenanceInitialDelay = 0;
        ComressionSnappy = "snappy";
        ComressionZlib = "zlib";
        ComressionZstd = "zstd";
        DefaultConfigPathPrefix = "mongodb";
    }

    @Override
    public Option<String> stringConfig(String configPath, String key, String string) {
        return ConfigHelper.stringConfig$(this, configPath, key, string);
    }

    @Override
    public String stringConfig$default$3() {
        return ConfigHelper.stringConfig$default$3$(this);
    }

    @Override
    public int intConfig(String configPath, String key, int n) {
        return ConfigHelper.intConfig$(this, configPath, key, n);
    }

    @Override
    public int intConfig$default$3() {
        return ConfigHelper.intConfig$default$3$(this);
    }

    @Override
    public boolean booleanConfig(String configPath, String key, boolean bl) {
        return ConfigHelper.booleanConfig$(this, configPath, key, bl);
    }

    @Override
    public boolean booleanConfig$default$3() {
        return ConfigHelper.booleanConfig$default$3$(this);
    }

    @Override
    public Config conf() {
        return conf;
    }

    @Override
    public void dev$mongocamp$driver$mongodb$database$ConfigHelper$_setter_$conf_$eq(Config x$1) {
        conf = x$1;
    }

    public String $lessinit$greater$default$2() {
        return this.DefaultHost();
    }

    public int $lessinit$greater$default$3() {
        return this.DefaultPort();
    }

    public String $lessinit$greater$default$4() {
        return this.DefaultApplicationName();
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public String $lessinit$greater$default$7() {
        return this.DefaultAuthenticationDatabaseName();
    }

    public MongoPoolOptions $lessinit$greater$default$8() {
        return new MongoPoolOptions(MongoPoolOptions$.MODULE$.apply$default$1(), MongoPoolOptions$.MODULE$.apply$default$2(), MongoPoolOptions$.MODULE$.apply$default$3(), MongoPoolOptions$.MODULE$.apply$default$4());
    }

    public List<String> $lessinit$greater$default$9() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public List<ConnectionPoolListener> $lessinit$greater$default$10() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public List<CommandListener> $lessinit$greater$default$11() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public Option<MongoClientSettings> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public String DefaultHost() {
        return DefaultHost;
    }

    public int DefaultPort() {
        return DefaultPort;
    }

    public String DefaultAuthenticationDatabaseName() {
        return DefaultAuthenticationDatabaseName;
    }

    public String DefaultApplicationName() {
        return DefaultApplicationName;
    }

    public int DefaultPoolMaxConnectionIdleTime() {
        return DefaultPoolMaxConnectionIdleTime;
    }

    public int DefaultPoolMaxSize() {
        return DefaultPoolMaxSize;
    }

    public int DefaultPoolMinSize() {
        return DefaultPoolMinSize;
    }

    public int DefaultPoolMaxWaitQueueSize() {
        return DefaultPoolMaxWaitQueueSize;
    }

    public int DefaultPoolMaintenanceInitialDelay() {
        return DefaultPoolMaintenanceInitialDelay;
    }

    public String ComressionSnappy() {
        return ComressionSnappy;
    }

    public String ComressionZlib() {
        return ComressionZlib;
    }

    public String ComressionZstd() {
        return ComressionZstd;
    }

    public String DefaultConfigPathPrefix() {
        return DefaultConfigPathPrefix;
    }

    public MongoConfig fromPath(String configPath) {
        int port = this.intConfig(configPath, "port", this.DefaultPort());
        List compressors = this.conf().hasPath(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s.compressors"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{configPath}))) ? CollectionConverters$.MODULE$.ListHasAsScala(this.conf().getStringList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s.compressors"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{configPath})))).asScala().toList() : (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
        String host = (String)this.stringConfig(configPath, "host", this.DefaultHost()).get();
        String database = (String)this.stringConfig(configPath, "database", this.stringConfig$default$3()).get();
        Option<String> userName = this.stringConfig(configPath, "userName", this.stringConfig$default$3());
        Option<String> password = this.stringConfig(configPath, "password", this.stringConfig$default$3());
        String authDatabase = (String)this.stringConfig(configPath, "authDatabase", this.DefaultAuthenticationDatabaseName()).get();
        String applicationName = (String)this.stringConfig(configPath, "applicationName", this.DefaultApplicationName()).get();
        MongoPoolOptions poolOptions = new MongoPoolOptions(this.poolOptionsConfig$1("maxConnectionIdleTime", this.DefaultPoolMaxConnectionIdleTime(), configPath), this.poolOptionsConfig$1("maxSize", this.DefaultPoolMaxSize(), configPath), this.poolOptionsConfig$1("minSize", this.DefaultPoolMinSize(), configPath), this.poolOptionsConfig$1("maintenanceInitialDelay", this.DefaultPoolMaintenanceInitialDelay(), configPath));
        return new MongoConfig(database, host, port, applicationName, userName, password, authDatabase, poolOptions, (List<String>)compressors, this.apply$default$10(), this.apply$default$11(), this.apply$default$12());
    }

    public String fromPath$default$1() {
        return this.DefaultConfigPathPrefix();
    }

    public MongoConfig apply(String database, String host, int port, String applicationName, Option<String> userName, Option<String> password, String authDatabase, MongoPoolOptions poolOptions, List<String> compressors, List<ConnectionPoolListener> connectionPoolListener, List<CommandListener> commandListener, Option<MongoClientSettings> customClientSettings) {
        return new MongoConfig(database, host, port, applicationName, userName, password, authDatabase, poolOptions, compressors, connectionPoolListener, commandListener, customClientSettings);
    }

    public List<ConnectionPoolListener> apply$default$10() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public List<CommandListener> apply$default$11() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public Option<MongoClientSettings> apply$default$12() {
        return None$.MODULE$;
    }

    public String apply$default$2() {
        return this.DefaultHost();
    }

    public int apply$default$3() {
        return this.DefaultPort();
    }

    public String apply$default$4() {
        return this.DefaultApplicationName();
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public String apply$default$7() {
        return this.DefaultAuthenticationDatabaseName();
    }

    public MongoPoolOptions apply$default$8() {
        return new MongoPoolOptions(MongoPoolOptions$.MODULE$.apply$default$1(), MongoPoolOptions$.MODULE$.apply$default$2(), MongoPoolOptions$.MODULE$.apply$default$3(), MongoPoolOptions$.MODULE$.apply$default$4());
    }

    public List<String> apply$default$9() {
        return (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public Option<Tuple12<String, String, Object, String, Option<String>, Option<String>, String, MongoPoolOptions, List<String>, List<ConnectionPoolListener>, List<CommandListener>, Option<MongoClientSettings>>> unapply(MongoConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.database(), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.applicationName(), x$0.userName(), x$0.password(), (Object)x$0.authDatabase(), (Object)x$0.poolOptions(), x$0.compressors(), x$0.connectionPoolListener(), x$0.commandListener(), x$0.customClientSettings()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MongoConfig$.class);
    }

    private final int poolOptionsConfig$1(String key, int n, String configPath$1) {
        return this.conf().hasPath(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s.pool.%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{configPath$1, key}))) ? this.conf().getInt(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s.pool.%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{configPath$1, key}))) : n;
    }

    private MongoConfig$() {
    }
}

