/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.bson;

import dev.mongocamp.driver.mongodb.bson.AbstractConverterPlugin;
import dev.mongocamp.driver.mongodb.bson.BaseConverterPlugin;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDecimal128$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonDouble$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonRegularExpression$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.mutable.Document$;
import org.mongodb.scala.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class BsonConverter$ {
    public static BsonConverter$ MODULE$;
    private final String DocumentKeyDivider;
    private AbstractConverterPlugin converterPlugin;

    static {
        new BsonConverter$();
    }

    public String DocumentKeyDivider() {
        return this.DocumentKeyDivider;
    }

    public boolean hasRelation(String key) {
        return key.indexOf(this.DocumentKeyDivider()) != -1;
    }

    public String relationKey(String key) {
        return key.substring(0, key.indexOf(this.DocumentKeyDivider()));
    }

    public String newKeyFromRelation(String key) {
        return key.substring(key.indexOf(this.DocumentKeyDivider()) + 1);
    }

    public String lastKeyFromRelation(String key) {
        return key.substring(key.lastIndexOf(this.DocumentKeyDivider()) + 1);
    }

    public Option<Object> documentValueOption(Document document, String key) {
        Object object;
        block4: {
            while (this.hasRelation(key)) {
                String newKey = this.newKeyFromRelation(key);
                String relation = this.relationKey(key);
                if (document.contains(relation) && this.documentValueOption(document, relation).isDefined()) {
                    None$ none$;
                    Object value = this.documentValueOption(document, relation).get();
                    Object object2 = value;
                    if (object2 instanceof Document) {
                        Document document2 = (Document)object2;
                        key = newKey;
                        document = document2;
                        continue;
                    }
                    object = none$ = None$.MODULE$;
                } else {
                    object = None$.MODULE$;
                }
                break block4;
            }
            object = document.contains(key) ? new Some(this.fromBson(document.apply(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)))) : None$.MODULE$;
        }
        return object;
    }

    public Document updateDocumentValue(Document document, String key, Object value) {
        org.mongodb.scala.bson.collection.mutable.Document doc = Document$.MODULE$.apply(document.toJson());
        org.mongodb.scala.bson.collection.mutable.Document result = this.updateDocumentValueInternal(doc, key, value, this.updateDocumentValueInternal$default$4());
        return package$.MODULE$.Document().apply(result.toJson());
    }

    private org.mongodb.scala.bson.collection.mutable.Document updateDocumentValueInternal(org.mongodb.scala.bson.collection.mutable.Document document, String key, Object value, Option<org.mongodb.scala.bson.collection.mutable.Document> root) {
        while (this.hasRelation(key)) {
            String newKey = this.newKeyFromRelation(key);
            String relation = this.relationKey(key);
            Document relatedDocument = package$.MODULE$.Document().apply();
            Option<Object> relationValue = this.documentValueOption(package$.MODULE$.Document().apply(document.toJson()), relation);
            if (relationValue.isDefined()) {
                BoxedUnit boxedUnit;
                Object value2 = relationValue.get();
                Object object = value2;
                if (object instanceof Document) {
                    Document document2;
                    relatedDocument = document2 = (Document)object;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            org.mongodb.scala.bson.collection.mutable.Document mutableDoc = Document$.MODULE$.apply(relatedDocument.toJson());
            document.put(relation, (Object)mutableDoc, (BsonTransformer)BsonTransformer$.MODULE$.TransformMutableDocument());
            if (root.isEmpty()) {
                root = new Some((Object)document);
                key = newKey;
                document = mutableDoc;
                continue;
            }
            key = newKey;
            document = mutableDoc;
        }
        document.put(key, (Object)this.toBson(value), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return root.isEmpty() ? document : (org.mongodb.scala.bson.collection.mutable.Document)root.get();
    }

    private Option<org.mongodb.scala.bson.collection.mutable.Document> updateDocumentValueInternal$default$4() {
        return None$.MODULE$;
    }

    public AbstractConverterPlugin converterPlugin() {
        return this.converterPlugin;
    }

    public void converterPlugin_$eq(AbstractConverterPlugin x$1) {
        this.converterPlugin = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BsonValue toBson(Object value) {
        Object object;
        while (true) {
            if ((object = value) instanceof BsonValue) {
                BsonValue bsonValue = (BsonValue)object;
                return bsonValue;
            }
            if (!(object instanceof Option)) break;
            Option option = (Option)object;
            if (!option.isDefined()) return BsonNull$.MODULE$.apply();
            value = option.get();
        }
        if (object instanceof Object) {
            Object object2 = object;
            if (this.converterPlugin().hasCustomClass(object2)) {
                return this.converterPlugin().toBson(object2);
            }
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return BsonBoolean$.MODULE$.apply(bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            return BsonString$.MODULE$.apply(string);
        }
        if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            return BsonString$.MODULE$.apply(Character.toString(c));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return BsonBinary$.MODULE$.apply(byArray);
        }
        if (object instanceof Regex) {
            Regex regex = (Regex)object;
            return BsonRegularExpression$.MODULE$.apply(regex);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return BsonDateTime$.MODULE$.apply(date);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return BsonDateTime$.MODULE$.apply(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return BsonDateTime$.MODULE$.apply(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (object instanceof ObjectId) {
            ObjectId objectId = (ObjectId)object;
            return BsonObjectId$.MODULE$.apply(objectId);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return BsonInt32$.MODULE$.apply(n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return BsonInt64$.MODULE$.apply(l);
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            return BsonInt64$.MODULE$.apply(bigInt.toLong());
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            return BsonInt64$.MODULE$.apply(bigInteger.longValue());
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return BsonDouble$.MODULE$.apply(d);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return BsonDouble$.MODULE$.apply((double)f);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return BsonDecimal128$.MODULE$.apply(bigDecimal);
        }
        if (object instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
            return BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            return BsonDocument$.MODULE$.apply((Traversable)document);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            ObjectRef doc = ObjectRef.create((Object)package$.MODULE$.Document().apply());
            map.keys().foreach((Function1 & Serializable & scala.Serializable)key -> {
                BsonConverter$.$anonfun$toBson$1(map, doc, key);
                return BoxedUnit.UNIT;
            });
            return BsonDocument$.MODULE$.apply((Traversable)((Document)doc.elem));
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            ObjectRef doc = ObjectRef.create((Object)package$.MODULE$.Document().apply());
            ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(map.keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                BsonConverter$.$anonfun$toBson$2(map, doc, key);
                return BoxedUnit.UNIT;
            });
            return BsonDocument$.MODULE$.apply((Traversable)((Document)doc.elem));
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return BsonArray$.MODULE$.fromIterable((Iterable)iterable.map((Function1 & Serializable & scala.Serializable)v -> MODULE$.toBson(v), Iterable$.MODULE$.canBuildFrom()));
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            return BsonArray$.MODULE$.fromIterable((Iterable)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.toBson(v), Buffer$.MODULE$.canBuildFrom()));
        }
        if (!(object instanceof Object)) return BsonNull$.MODULE$.apply();
        Object object3 = object;
        return this.converterPlugin().objectToBson(object3);
    }

    public Object fromBson(BsonValue value) {
        Object object;
        BsonValue bsonValue = value;
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean bsonBoolean = (BsonBoolean)bsonValue;
            object = BoxesRunTime.boxToBoolean((boolean)bsonBoolean.getValue());
        } else if (bsonValue instanceof BsonString) {
            BsonString bsonString = (BsonString)bsonValue;
            object = bsonString.getValue();
        } else if (bsonValue instanceof BsonBinary) {
            BsonBinary bsonBinary = (BsonBinary)bsonValue;
            object = bsonBinary.getData();
        } else if (bsonValue instanceof BsonRegularExpression) {
            BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)bsonValue;
            object = bsonRegularExpression.getPattern();
        } else if (bsonValue instanceof BsonDateTime) {
            BsonDateTime bsonDateTime = (BsonDateTime)bsonValue;
            object = new Date(bsonDateTime.getValue());
        } else if (bsonValue instanceof BsonTimestamp) {
            BsonTimestamp bsonTimestamp = (BsonTimestamp)bsonValue;
            object = new Date(bsonTimestamp.getTime());
        } else if (bsonValue instanceof BsonObjectId) {
            BsonObjectId bsonObjectId = (BsonObjectId)bsonValue;
            object = bsonObjectId.getValue();
        } else if (bsonValue instanceof BsonInt32) {
            BsonInt32 bsonInt32 = (BsonInt32)bsonValue;
            object = BoxesRunTime.boxToInteger((int)bsonInt32.getValue());
        } else if (bsonValue instanceof BsonInt64) {
            BsonInt64 bsonInt64 = (BsonInt64)bsonValue;
            object = BoxesRunTime.boxToLong((long)bsonInt64.getValue());
        } else if (bsonValue instanceof BsonDouble) {
            BsonDouble bsonDouble = (BsonDouble)bsonValue;
            object = BoxesRunTime.boxToDouble((double)bsonDouble.doubleValue());
        } else if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 bsonDecimal128 = (BsonDecimal128)bsonValue;
            object = bsonDecimal128.getValue().bigDecimalValue();
        } else if (bsonValue instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)bsonValue;
            object = package$.MODULE$.Document().apply(bsonDocument);
        } else if (bsonValue instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)bsonValue;
            object = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(bsonArray.getValues()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)v -> MODULE$.fromBson((BsonValue)v), List$.MODULE$.canBuildFrom());
        } else {
            object = bsonValue instanceof BsonNull ? null : value;
        }
        return object;
    }

    public scala.collection.immutable.Map<String, Object> asMap(Document document) {
        HashMap result = new HashMap();
        document.keySet().foreach((Function1 & Serializable & scala.Serializable)key -> {
            HashMap hashMap;
            Object value = MODULE$.fromBson(document.apply(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
            Object object = value;
            if (object instanceof Document) {
                Document document = (Document)object;
                hashMap = result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), MODULE$.asMap(document)));
            } else if (object instanceof List) {
                List list = (List)object;
                hashMap = result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), list.map((Function1 & Serializable & scala.Serializable)d -> d instanceof Document ? MODULE$.asMap((Document)d) : d, List$.MODULE$.canBuildFrom())));
            } else {
                hashMap = result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
            }
            return hashMap;
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public List<scala.collection.immutable.Map<String, Object>> asMapList(List<Document> documents) {
        ArrayBuffer result = new ArrayBuffer();
        documents.foreach((Function1 & Serializable & scala.Serializable)document -> result.$plus$eq(MODULE$.asMap((Document)document)));
        return result.toList();
    }

    public static final /* synthetic */ void $anonfun$toBson$1(Map x23$1, ObjectRef doc$1, Object key) {
        Object v = x23$1.apply(key);
        doc$1.elem = (Document)((Document)doc$1.elem).$plus((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)MODULE$.toBson(v)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue())}));
    }

    public static final /* synthetic */ void $anonfun$toBson$2(java.util.Map x24$1, ObjectRef doc$2, Object key) {
        Object v = x24$1.get(key);
        doc$2.elem = (Document)((Document)doc$2.elem).$plus((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)MODULE$.toBson(v)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue())}));
    }

    private BsonConverter$() {
        MODULE$ = this;
        this.DocumentKeyDivider = ".";
        this.converterPlugin = new BaseConverterPlugin();
    }
}

