/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.test;

import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.server.RestServer;
import dev.mongocamp.server.database.TestAdditions$;
import dev.mongocamp.server.service.ReflectionService$;
import dev.mongocamp.server.test.MongoTestServer$;
import dev.mongocamp.server.test.client.api.InformationApi$;
import dev.mongocamp.server.test.client.model.Version;
import io.circe.Error;
import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Random$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.ResponseException;

public final class TestServer$
implements LazyLogging {
    public static final TestServer$ MODULE$ = new TestServer$();
    private static RestServer server;
    private static boolean serverRunning;
    private static boolean mongoServerStarted;
    private static int retries;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        serverRunning = false;
        mongoServerStarted = false;
        System.setProperty("CONNECTION_HOST", "localhost");
        System.setProperty("CONNECTION_DATABASE", "test");
        System.setProperty("PLUGINS_DIRECTORY", ((File)File$.MODULE$.temporaryDirectory(File$.MODULE$.temporaryDirectory$default$1(), File$.MODULE$.temporaryDirectory$default$2(), File$.MODULE$.temporaryDirectory$default$3()).get()).toString());
        retries = 0;
        while (!MODULE$.serverRunning()) {
            try {
                if (!MODULE$.mongoServerStarted()) {
                    MongoTestServer$.MODULE$.startMongoDatabase();
                    MODULE$.setPort();
                    MODULE$.server().registerMongoCampServerDefaultConfigs();
                    Future$.MODULE$.successful((Object)MODULE$.server().startServer((ExecutionContext)ExecutionContext$.MODULE$.global()));
                    MODULE$.mongoServerStarted_$eq(true);
                }
                RequestT<Object, Either<ResponseException<String, Error>, Version>, Object> versionRequest = InformationApi$.MODULE$.apply(InformationApi$.MODULE$.apply$default$1()).version();
                Response versionFuture = (Response)TestAdditions$.MODULE$.backend().send(versionRequest);
                ((Either)versionFuture.body()).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("error");
                });
                MODULE$.serverRunning_$eq(true);
            }
            catch (Exception e) {
                MODULE$.serverRunning_$eq(false);
                MODULE$.setPort();
                if (MODULE$.retries() > 60) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error(e.getMessage(), (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new Exception(new StringBuilder(34).append("could not start server in ").append(MODULE$.retries()).append(" seconds").toString());
                }
                MODULE$.retries_$eq(MODULE$.retries() + 1);
            }
        }
    }

    private Logger logger$lzycompute() {
        TestServer$ testServer$ = this;
        synchronized (testServer$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private boolean serverRunning() {
        return serverRunning;
    }

    private void serverRunning_$eq(boolean x$1) {
        serverRunning = x$1;
    }

    private boolean mongoServerStarted() {
        return mongoServerStarted;
    }

    private void mongoServerStarted_$eq(boolean x$1) {
        mongoServerStarted = x$1;
    }

    public int retries() {
        return retries;
    }

    public void retries_$eq(int x$1) {
        retries = x$1;
    }

    private RestServer server$lzycompute() {
        TestServer$ testServer$ = this;
        synchronized (testServer$) {
            if (!bitmap$0) {
                List servers = ReflectionService$.MODULE$.instancesForType(RestServer.class);
                if (servers.size() != 1) {
                    throw new Exception("more than one implementation for rest server found");
                }
                server = (RestServer)servers.head();
                bitmap$0 = true;
            }
        }
        return server;
    }

    public RestServer server() {
        if (!bitmap$0) {
            return this.server$lzycompute();
        }
        return server;
    }

    public boolean isServerRunning() {
        return this.serverRunning();
    }

    public String serverBaseUrl() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("http://%s:%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.server().interface(), BoxesRunTime.boxToInteger((int)this.server().port())}));
    }

    public void setPort() {
        int port = Random$.MODULE$.nextInt(10000) + TestAdditions$.MODULE$.minPort();
        System.setProperty("SERVER_PORT", Integer.toString(port));
    }

    private TestServer$() {
    }
}

