/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.test;

import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongoProcess;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.mongo.types.DatabaseDir;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.transitions.Start;
import dev.mongocamp.server.database.TestAdditions$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Random$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.model.Method$;

public final class MongoTestServer$
implements LazyLogging {
    public static final MongoTestServer$ MODULE$ = new MongoTestServer$();
    private static boolean running;
    private static int mongoPort;
    private static TransitionWalker.ReachedState<RunningMongodProcess> process;
    private static Mongod mongodExecutable;
    private static File tempDir;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        running = false;
        mongoPort = MODULE$.setPort();
        process = null;
        mongodExecutable = MODULE$.initMonoExecutable();
        String x$1 = File$.MODULE$.newTemporaryDirectory$default$1();
        Option x$2 = File$.MODULE$.newTemporaryDirectory$default$2();
        Seq x$3 = File$.MODULE$.newTemporaryDirectory$default$3(x$1, x$2);
        tempDir = File$.MODULE$.newTemporaryDirectory(x$1, x$2, x$3);
    }

    private Logger logger$lzycompute() {
        MongoTestServer$ mongoTestServer$ = this;
        synchronized (mongoTestServer$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private boolean running() {
        return running;
    }

    private void running_$eq(boolean x$1) {
        running = x$1;
    }

    public int mongoPort() {
        return mongoPort;
    }

    public void mongoPort_$eq(int x$1) {
        mongoPort = x$1;
    }

    public TransitionWalker.ReachedState<RunningMongodProcess> process() {
        return process;
    }

    public void process_$eq(TransitionWalker.ReachedState<RunningMongodProcess> x$1) {
        process = x$1;
    }

    public int setPort() {
        int port = Random$.MODULE$.nextInt(10000) + TestAdditions$.MODULE$.minPort();
        System.setProperty("CONNECTION_PORT", Integer.toString(port));
        this.mongoPort_$eq(port);
        return this.mongoPort();
    }

    private Mongod mongodExecutable() {
        return mongodExecutable;
    }

    private void mongodExecutable_$eq(Mongod x$1) {
        mongodExecutable = x$1;
    }

    private File tempDir() {
        return tempDir;
    }

    private void tempDir_$eq(File x$1) {
        tempDir = x$1;
    }

    private Mongod initMonoExecutable() {
        ImmutableMongod mongod = Mongod.builder().net((Transition)Start.to(Net.class).providedBy(() -> Net.builder().port(MODULE$.mongoPort()).bindIp(Net.defaults().getBindIp()).isIpv6(false).build())).databaseDir((Transition)Start.to(DatabaseDir.class).providedBy(() -> DatabaseDir.of((Path)MODULE$.tempDir().path()))).processOutput((Transition)Start.to(ProcessOutput.class).providedBy(() -> ProcessOutput.silent())).build();
        return mongod;
    }

    public boolean isRunning() {
        return this.running();
    }

    public void checkForLocalRunningMongoDb() {
        if (!this.running()) {
            try {
                RequestT checkRequest = sttp.client3.package$.MODULE$.basicRequest().method(Method$.MODULE$.GET(), sttp.client3.package$.MODULE$.UriContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"http://localhost:4711"}))).uri((Seq)Nil$.MODULE$)).response(sttp.client3.package$.MODULE$.asString());
                String responseResult = (String)((Either)((Response)TestAdditions$.MODULE$.backend().send(checkRequest)).body()).getOrElse((Function0 & Serializable)() -> "not found");
                if (responseResult.contains("HTTP on the native driver port.")) {
                    Predef$.MODULE$.println((Object)"Use local running MongoDb");
                    System.setProperty("CONNECTION_PORT", "4711");
                    this.running_$eq(true);
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
            return;
        }
    }

    public void startMongoDatabase() {
        this.checkForLocalRunningMongoDb();
        if (!this.running()) {
            this.process_$eq((TransitionWalker.ReachedState<RunningMongodProcess>)this.mongodExecutable().start((de.flapdoodle.embed.process.distribution.Version)Version.V6_0_5, new Listener[0]));
            this.running_$eq(true);
            package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Predef$.MODULE$.println((Object)"Shutdown for MongoDB Server triggered.");
                MODULE$.stopMongoDatabase();
            });
            return;
        }
    }

    public void stopMongoDatabase() {
        if (this.running()) {
            ((RunningMongoProcess)this.process().current()).stop();
            this.process_$eq(null);
            this.running_$eq(false);
            File qual$1 = this.tempDir();
            boolean x$1 = qual$1.delete$default$1();
            Seq x$2 = qual$1.delete$default$2();
            qual$1.delete(x$1, x$2);
            String x$3 = File$.MODULE$.newTemporaryDirectory$default$1();
            Option x$4 = File$.MODULE$.newTemporaryDirectory$default$2();
            Seq x$5 = File$.MODULE$.newTemporaryDirectory$default$3(x$3, x$4);
            this.tempDir_$eq(File$.MODULE$.newTemporaryDirectory(x$3, x$4, x$5));
            this.mongodExecutable_$eq(this.initMonoExecutable());
            return;
        }
    }

    private MongoTestServer$() {
    }
}

