/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.database;

import better.files.File;
import better.files.File$;
import better.files.Resource$;
import com.mongodb.client.model.IndexOptions;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.server.converter.CirceSchema;
import dev.mongocamp.server.database.MongoDatabase$;
import dev.mongocamp.server.database.TestAdditions;
import dev.mongocamp.server.database.TestAdditions$FilesDAO$1$;
import dev.mongocamp.server.model.ModelConstants$;
import dev.mongocamp.server.model.MongoCampConfiguration;
import dev.mongocamp.server.service.SystemFileService$;
import dev.mongocamp.server.test.CountingTestJob;
import dev.mongocamp.server.test.client.api.AdminApi$;
import dev.mongocamp.server.test.client.api.JobsApi$;
import dev.mongocamp.server.test.client.model.Grant;
import dev.mongocamp.server.test.client.model.JobConfig;
import dev.mongocamp.server.test.client.model.JobInformation;
import dev.mongocamp.server.test.client.model.JsonValueBoolean;
import dev.mongocamp.server.test.client.model.PasswordUpdateRequest;
import dev.mongocamp.server.test.client.model.Role;
import dev.mongocamp.server.test.client.model.UserInformation;
import dev.mongocamp.server.test.client.model.UserProfile;
import io.circe.Encoder;
import io.circe.Error;
import io.circe.Json;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.mongodb.scala.Observable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Random$;
import sttp.client3.HttpClientSyncBackend$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.ResponseException;
import sttp.client3.SttpBackend;

public final class TestAdditions$
implements CirceSchema {
    public static final TestAdditions$ MODULE$ = new TestAdditions$();
    private static int minPort;
    private static SttpBackend<Object, Object> backend;
    private static String adminUser;
    private static String adminPassword;
    private static String testUser;
    private static String testPassword;
    private static boolean dataImported;
    private static final File tempDir;
    private static Encoder<Date> DateFormat;
    private static Encoder<DateTime> DateTimeFormat;
    private static Encoder<ObjectId> ObjectIdFormat;
    private static Encoder<Map<String, Object>> MapStringAnyFormat;
    private static Encoder<Object> AnyFormat;
    private static Encoder<MongoCampConfiguration> ConfigFormat;
    private static volatile byte bitmap$0;

    static {
        CirceSchema.$init$((CirceSchema)MODULE$);
        dataImported = false;
        String x$1 = File$.MODULE$.newTemporaryDirectory$default$1();
        Option x$2 = File$.MODULE$.newTemporaryDirectory$default$2();
        Seq x$3 = File$.MODULE$.newTemporaryDirectory$default$3(x$1, x$2);
        tempDir = File$.MODULE$.newTemporaryDirectory(x$1, x$2, x$3);
    }

    public Json encodeMapStringAny(Map<String, Object> a) {
        return CirceSchema.encodeMapStringAny$((CirceSchema)this, a);
    }

    public Object decodeFromJson(Json json) {
        return CirceSchema.decodeFromJson$((CirceSchema)this, (Json)json);
    }

    public Json encodeAnyToJson(Object a, int deepth) {
        return CirceSchema.encodeAnyToJson$((CirceSchema)this, (Object)a, (int)deepth);
    }

    public int encodeAnyToJson$default$2() {
        return CirceSchema.encodeAnyToJson$default$2$((CirceSchema)this);
    }

    public Encoder<Date> DateFormat() {
        return DateFormat;
    }

    public Encoder<DateTime> DateTimeFormat() {
        return DateTimeFormat;
    }

    public Encoder<ObjectId> ObjectIdFormat() {
        return ObjectIdFormat;
    }

    public Encoder<Map<String, Object>> MapStringAnyFormat() {
        return MapStringAnyFormat;
    }

    public Encoder<Object> AnyFormat() {
        return AnyFormat;
    }

    public Encoder<MongoCampConfiguration> ConfigFormat() {
        return ConfigFormat;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$DateFormat_$eq(Encoder<Date> x$1) {
        DateFormat = x$1;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$DateTimeFormat_$eq(Encoder<DateTime> x$1) {
        DateTimeFormat = x$1;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$ObjectIdFormat_$eq(Encoder<ObjectId> x$1) {
        ObjectIdFormat = x$1;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$MapStringAnyFormat_$eq(Encoder<Map<String, Object>> x$1) {
        MapStringAnyFormat = x$1;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$AnyFormat_$eq(Encoder<Object> x$1) {
        AnyFormat = x$1;
    }

    public void dev$mongocamp$server$converter$CirceSchema$_setter_$ConfigFormat_$eq(Encoder<MongoCampConfiguration> x$1) {
        ConfigFormat = x$1;
    }

    private int minPort$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                minPort = 1000;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return minPort;
    }

    public int minPort() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.minPort$lzycompute();
        }
        return minPort;
    }

    private SttpBackend<Object, Object> backend$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                backend = HttpClientSyncBackend$.MODULE$.apply(HttpClientSyncBackend$.MODULE$.apply$default$1(), HttpClientSyncBackend$.MODULE$.apply$default$2(), HttpClientSyncBackend$.MODULE$.apply$default$3());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return backend;
    }

    public SttpBackend<Object, Object> backend() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.backend$lzycompute();
        }
        return backend;
    }

    private String adminUser$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                adminUser = "admin";
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return adminUser;
    }

    public String adminUser() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.adminUser$lzycompute();
        }
        return adminUser;
    }

    private String adminPassword$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                adminPassword = Random$.MODULE$.alphanumeric().take(10).mkString();
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return adminPassword;
    }

    public String adminPassword() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.adminPassword$lzycompute();
        }
        return adminPassword;
    }

    private String testUser$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                testUser = "mongocamp_test";
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return testUser;
    }

    public String testUser() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.testUser$lzycompute();
        }
        return testUser;
    }

    private String testPassword$lzycompute() {
        TestAdditions$ testAdditions$ = this;
        synchronized (testAdditions$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                testPassword = Random$.MODULE$.alphanumeric().take(10).mkString();
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return testPassword;
    }

    public String testPassword() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.testPassword$lzycompute();
        }
        return testPassword;
    }

    private boolean dataImported() {
        return dataImported;
    }

    private void dataImported_$eq(boolean x$1) {
        dataImported = x$1;
    }

    public File tempDir() {
        return tempDir;
    }

    public boolean importData() {
        LazyRef FilesDAO$module = new LazyRef();
        ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(new TestAdditions.MapCollectionDao("accounts").insertMany((Seq)SystemFileService$.MODULE$.readJsonList("accounts.json")));
        int x$1 = qual$1.result$default$1();
        qual$1.result(x$1);
        ObservableIncludes.GenericObservable qual$2 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(new TestAdditions.MapCollectionDao("users").insertMany((Seq)SystemFileService$.MODULE$.readJsonList("users.json")));
        int x$2 = qual$2.result$default$1();
        qual$2.result(x$2);
        ObservableIncludes.GenericObservable qual$3 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(new TestAdditions.MapCollectionDao("users").insertMany((Seq)SystemFileService$.MODULE$.readJsonList("users.json")));
        int x$3 = qual$3.result$default$1();
        qual$3.result(x$3);
        ObservableIncludes.GenericObservable qual$4 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(new TestAdditions.MapCollectionDao("pokemon").insertMany((Seq)SystemFileService$.MODULE$.readJsonList("pokedex.json")));
        int x$4 = qual$4.result$default$1();
        qual$4.result(x$4);
        TestAdditions.MapCollectionDao geoDataDao = new TestAdditions.MapCollectionDao("geodata:locations");
        List<Map<String, Object>> geoJson = this.readGeoDataJson();
        ObservableIncludes.GenericObservable qual$5 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(geoDataDao.insertMany((Seq)geoJson));
        int x$5 = qual$5.result$default$1();
        qual$5.result(x$5);
        ObservableIncludes.GenericObservable qual$6 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)geoDataDao.createIndex((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geodata"), (Object)"2dsphere")}))), geoDataDao.createIndex$default$2()));
        int x$6 = qual$6.result$default$1();
        qual$6.result(x$6);
        ObservableIncludes.GenericObservable qual$7 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(new TestAdditions.MapCollectionDao("geodata:companies").insertMany((Seq)geoJson));
        int x$7 = qual$7.result$default$1();
        qual$7.result(x$7);
        TestAdditions.MapCollectionDao qual$8 = new TestAdditions.MapCollectionDao("test");
        String x$8 = "index";
        boolean x$9 = qual$8.createIndexForField$default$2();
        IndexOptions x$10 = qual$8.createIndexForField$default$3();
        ObservableIncludes.GenericObservable qual$9 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)qual$8.createIndexForField("index", x$9, x$10));
        int x$11 = qual$9.result$default$1();
        qual$9.result(x$11);
        TestAdditions.MapCollectionDao qual$10 = new TestAdditions.MapCollectionDao("admin-test");
        String x$12 = "index";
        boolean x$13 = qual$10.createIndexForField$default$2();
        IndexOptions x$14 = qual$10.createIndexForField$default$3();
        ObservableIncludes.GenericObservable qual$11 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)qual$10.createIndexForField("index", x$13, x$14));
        int x$15 = qual$11.result$default$1();
        qual$11.result(x$15);
        File accountFile = this.copyResourceFileToTempDir(this.tempDir(), "accounts.json");
        File geoFile = this.copyResourceFileToTempDir(this.tempDir(), "geodata.json");
        File userFile = this.copyResourceFileToTempDir(this.tempDir(), "users.json");
        File mongocampLogoFile = this.copyResourceFileToTempDir(this.tempDir(), "mongocamp.png");
        ObservableIncludes.GenericObservable qual$12 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(this.FilesDAO$2(FilesDAO$module).uploadFile(accountFile.name(), accountFile, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)Random$.MODULE$.alphanumeric().take(10).mkString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fullPath"), (Object)accountFile.toString())})), this.FilesDAO$2(FilesDAO$module).uploadFile$default$4()));
        int x$16 = qual$12.result$default$1();
        qual$12.result(x$16);
        ObservableIncludes.GenericObservable qual$13 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(this.FilesDAO$2(FilesDAO$module).uploadFile(geoFile.name(), geoFile, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)Random$.MODULE$.alphanumeric().take(10).mkString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fullPath"), (Object)geoFile.toString())})), this.FilesDAO$2(FilesDAO$module).uploadFile$default$4()));
        int x$17 = qual$13.result$default$1();
        qual$13.result(x$17);
        ObservableIncludes.GenericObservable qual$14 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(this.FilesDAO$2(FilesDAO$module).uploadFile(userFile.name(), userFile, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)Random$.MODULE$.alphanumeric().take(10).mkString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fullPath"), (Object)userFile.toString())})), this.FilesDAO$2(FilesDAO$module).uploadFile$default$4()));
        int x$18 = qual$14.result$default$1();
        qual$14.result(x$18);
        ObservableIncludes.GenericObservable qual$15 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(this.FilesDAO$2(FilesDAO$module).uploadFile(mongocampLogoFile.name(), userFile, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)Random$.MODULE$.alphanumeric().take(10).mkString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fullPath"), (Object)mongocampLogoFile.toString())})), this.FilesDAO$2(FilesDAO$module).uploadFile$default$4()));
        int x$19 = qual$15.result$default$1();
        qual$15.result(x$19);
        return this.dataImported();
    }

    public File copyResourceFileToTempDir(File tempDir, String file) {
        Some x$1 = new Some((Object)tempDir);
        String x$2 = File$.MODULE$.newTemporaryFile$default$1();
        String x$3 = File$.MODULE$.newTemporaryFile$default$2();
        String x$4 = x$2;
        String x$5 = x$3;
        Some x$6 = x$1;
        Seq x$7 = File$.MODULE$.newTemporaryFile$default$4(x$4, x$5, (Option)x$6);
        File tempFile = File$.MODULE$.newTemporaryFile(x$4, x$5, (Option)x$6, x$7);
        File accountFile = tempFile.moveTo(File$.MODULE$.apply(tempFile.path().resolveSibling(file)), File.CopyOptions$.MODULE$.apply(true));
        String x$8 = file;
        int x$9 = Resource$.MODULE$.asString$default$2();
        Charset x$10 = Resource$.MODULE$.asString$default$3(x$8, x$9);
        String x$11 = (String)Resource$.MODULE$.asString(x$8, x$9, x$10).getOrElse((Function0 & Serializable)() -> "");
        Charset x$12 = accountFile.append$default$2(x$11);
        accountFile.append(x$11, x$12);
        return accountFile;
    }

    public void insertUsersAndRoles() {
        if (!this.dataImported()) {
            TestAdditions.MapCollectionDao userDao = new TestAdditions.MapCollectionDao(MongoDatabase$.MODULE$.CollectionNameUsers());
            String apiKey = "special";
            String apiUserID = "insertApiUser";
            Map apiUser = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userId"), (Object)apiUserID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)"invalidPwd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"apiKey"), (Object)apiKey), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"roles"), (Object)new .colon.colon((Object)"adminRole", (List)Nil$.MODULE$))}));
            ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(userDao.insertOne(apiUser));
            int x$1 = qual$1.result$default$1();
            qual$1.result(x$1);
            RequestT<Object, Either<ResponseException<String, Error>, UserProfile>, Object> addUserRequest = AdminApi$.MODULE$.apply(AdminApi$.MODULE$.apply$default$1()).addUser(null, null, null, apiKey, new UserInformation(this.testUser(), this.testPassword(), (Option<String>)None$.MODULE$, (Seq<String>)new .colon.colon((Object)"test", (List)Nil$.MODULE$)));
            Response addUserResponse = (Response)this.backend().send(addUserRequest);
            RequestT<Object, Either<ResponseException<String, Error>, Role>, Object> addRoleRequest = AdminApi$.MODULE$.apply(AdminApi$.MODULE$.apply$default$1()).addRole(null, null, null, apiKey, new Role("test", false, (Seq<Grant>)new .colon.colon((Object)new Grant("geodata:locations", true, false, false, ModelConstants$.MODULE$.grantTypeCollection()), (List)new .colon.colon((Object)new Grant("accounts", true, true, false, ModelConstants$.MODULE$.grantTypeCollection()), (List)new .colon.colon((Object)new Grant("test", true, true, true, ModelConstants$.MODULE$.grantTypeCollection()), (List)new .colon.colon((Object)new Grant("users", true, true, true, ModelConstants$.MODULE$.grantTypeCollection()), (List)new .colon.colon((Object)new Grant("deleteTest", true, false, false, ModelConstants$.MODULE$.grantTypeCollection()), (List)Nil$.MODULE$)))))));
            Response addRoleResponse = (Response)this.backend().send(addRoleRequest);
            RequestT<Object, Either<ResponseException<String, Error>, JsonValueBoolean>, Object> updatePasswordRequest = AdminApi$.MODULE$.apply(AdminApi$.MODULE$.apply$default$1()).updatePasswordForUser(null, null, null, apiKey, this.adminUser(), new PasswordUpdateRequest(this.adminPassword()));
            Response updatePasswordResponse = (Response)this.backend().send(updatePasswordRequest);
            RequestT<Object, Either<ResponseException<String, Error>, JobInformation>, Object> registerJobRequest = JobsApi$.MODULE$.apply(JobsApi$.MODULE$.apply$default$1()).registerJob(null, null, null, apiKey, new JobConfig("CountingTestJob", CountingTestJob.class.getName(), "", "0/5 * * ? * * *", ModelConstants$.MODULE$.jobDefaultGroup(), ModelConstants$.MODULE$.jobDefaultPriority()));
            Response registerJobResponse = (Response)this.backend().send(registerJobRequest);
            ObservableIncludes.GenericObservable qual$2 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(userDao.deleteMany((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userId"), (Object)apiUserID)})))));
            int x$2 = qual$2.resultOption$default$1();
            Option deleteResult = qual$2.resultOption(x$2);
            this.dataImported_$eq(true);
            return;
        }
    }

    public List<Map<String, Object>> readGeoDataJson() {
        List list = SystemFileService$.MODULE$.readJsonList("geodata.json").map((Function1 & Serializable)element -> {
            scala.collection.mutable.Map newElement = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newElement.put((Object)"name", element.apply((Object)"name"));
            String[] geoData = element.apply((Object)"geodata").toString().split(", ");
            double longitude = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])geoData))));
            double latitude = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])geoData))));
            newElement.put((Object)"geodata", Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"Point"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{longitude, latitude})))})));
            newElement.put((Object)"type", (Object)"company");
            newElement.put((Object)"checkedAt", (Object)new DateTime(element.apply((Object)"checkedAt")).toDate());
            return newElement.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        });
        return list;
    }

    private static final /* synthetic */ TestAdditions$FilesDAO$1$ FilesDAO$lzycompute$1(LazyRef FilesDAO$module$1) {
        TestAdditions$FilesDAO$1$ testAdditions$FilesDAO$1$;
        LazyRef lazyRef = FilesDAO$module$1;
        synchronized (lazyRef) {
            testAdditions$FilesDAO$1$ = FilesDAO$module$1.initialized() ? (TestAdditions$FilesDAO$1$)((Object)FilesDAO$module$1.value()) : (TestAdditions$FilesDAO$1$)((Object)FilesDAO$module$1.initialize((Object)new TestAdditions$FilesDAO$1$()));
        }
        return testAdditions$FilesDAO$1$;
    }

    private final TestAdditions$FilesDAO$1$ FilesDAO$2(LazyRef FilesDAO$module$1) {
        if (FilesDAO$module$1.initialized()) {
            return (TestAdditions$FilesDAO$1$)((Object)FilesDAO$module$1.value());
        }
        return TestAdditions$.FilesDAO$lzycompute$1(FilesDAO$module$1);
    }

    private TestAdditions$() {
    }
}

