/** mongocamp-server No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
  *
  * The version of the OpenAPI document: 1.4.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech). https://openapi-generator.tech Do not edit the class manually.
  */
package dev.mongocamp.server.test.client.api

import dev.mongocamp.server.converter.CirceSchema
import dev.mongocamp.server.test.TestServer
import dev.mongocamp.server.test.client.core.JsonSupport._
import dev.mongocamp.server.test.client.model._
import sttp.client3._
import sttp.model.Method

object IndexApi {

  def apply(baseUrl: String = TestServer.serverBaseUrl) = new IndexApi(baseUrl)
}

class IndexApi(baseUrl: String) extends CirceSchema {

  /** Create expiring Index by Field for given Collection
    *
    * Expected answers: code 200 : IndexCreateResponse () code 400 : String (Invalid value for: query parameter sortAscending, Invalid value for: query
    * parameter name) code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the MongoCampException
    * x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param fieldName
    *   The field Name for your index
    * @param duration
    *   Expiring Duration in format 15d (https://www.scala-lang.org/api/2.13.7/scala/concurrent/duration/Duration.html)
    * @param sortAscending
    *   Sort your index ascending
    * @param name
    *   Name for your index
    */
  def createExpiringIndex(
      username: String,
      password: String,
      bearerToken: String,
      apiKey: String
  )(collectionName: String, fieldName: String, duration: String, sortAscending: Option[Boolean] = None, name: Option[String] = None) =
    basicRequest
      .method(
        Method.PUT,
        uri"$baseUrl/mongodb/collections/${collectionName}/index/field/${fieldName}/${duration}/expiring?sortAscending=${sortAscending}&name=${name}"
      )
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[IndexCreateResponse])

  /** Create Index for given Collection
    *
    * Expected answers: code 200 : IndexCreateResponse () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code -
    * Error Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param indexCreateRequest
    */
  def createIndex(username: String, password: String, bearerToken: String, apiKey: String)(collectionName: String, indexCreateRequest: IndexCreateRequest) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/mongodb/collections/${collectionName}/index")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(indexCreateRequest)
      .response(asJson[IndexCreateResponse])

  /** Create Index by Field for given Collection
    *
    * Expected answers: code 200 : IndexCreateResponse () code 400 : String (Invalid value for: query parameter sortAscending, Invalid value for: body) code 0 :
    * ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional
    * information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param fieldName
    *   The field Name for your index
    * @param sortAscending
    *   Sort your index ascending
    * @param indexOptionsRequest
    */
  def createIndexForField(
      username: String,
      password: String,
      bearerToken: String,
      apiKey: String
  )(collectionName: String, fieldName: String, sortAscending: Option[Boolean] = None, indexOptionsRequest: Option[IndexOptionsRequest] = None) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/mongodb/collections/${collectionName}/index/field/${fieldName}?sortAscending=${sortAscending}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(indexOptionsRequest)
      .response(asJson[IndexCreateResponse])

  /** Create text index by field for given collection
    *
    * Expected answers: code 200 : IndexCreateResponse () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code -
    * Error Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param fieldName
    *   The field Name for your index
    * @param indexOptionsRequest
    */
  def createTextIndex(username: String, password: String, bearerToken: String, apiKey: String)(
      collectionName: String,
      fieldName: String,
      indexOptionsRequest: Option[IndexOptionsRequest] = None
  ) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/mongodb/collections/${collectionName}/index/field/${fieldName}/text")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(indexOptionsRequest)
      .response(asJson[IndexCreateResponse])

  /** Create Unique Index by Field for given Collection
    *
    * Expected answers: code 200 : IndexCreateResponse () code 400 : String (Invalid value for: query parameter sortAscending, Invalid value for: query
    * parameter name) code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the MongoCampException
    * x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param fieldName
    *   The field Name for your index
    * @param sortAscending
    *   Sort your index ascending
    * @param name
    *   Name for your index
    */
  def createUniqueIndex(
      username: String,
      password: String,
      bearerToken: String,
      apiKey: String
  )(collectionName: String, fieldName: String, sortAscending: Option[Boolean] = None, name: Option[String] = None) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/mongodb/collections/${collectionName}/index/field/${fieldName}/unique?sortAscending=${sortAscending}&name=${name}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[IndexCreateResponse])

  /** Delete Index by Name for given Collection
    *
    * Expected answers: code 200 : IndexDropResponse () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param indexName
    *   The name of your Index
    */
  def deleteIndex(username: String, password: String, bearerToken: String, apiKey: String)(collectionName: String, indexName: String) =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/mongodb/collections/${collectionName}/index/${indexName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[IndexDropResponse])

  /** Index by Name for given Collection
    *
    * Expected answers: code 200 : MongoIndex () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    * @param indexName
    *   The name of your Index
    */
  def index(username: String, password: String, bearerToken: String, apiKey: String)(collectionName: String, indexName: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/collections/${collectionName}/index/${indexName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[MongoIndex])

  /** List all Indices for given Collection
    *
    * Expected answers: code 200 : Seq[MongoIndex] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param collectionName
    *   The name of your MongoDb Collection
    */
  def listIndices(username: String, password: String, bearerToken: String, apiKey: String)(collectionName: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/collections/${collectionName}/index")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[MongoIndex]])
}
