/** mongocamp-server No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
  *
  * The version of the OpenAPI document: 1.4.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech). https://openapi-generator.tech Do not edit the class manually.
  */
package dev.mongocamp.server.test.client.api

import dev.mongocamp.server.converter.CirceSchema
import dev.mongocamp.server.test.TestServer
import dev.mongocamp.server.test.client.core.JsonSupport._
import dev.mongocamp.server.test.client.model._
import sttp.client3._
import sttp.model.Method

object DatabaseApi {

  def apply(baseUrl: String = TestServer.serverBaseUrl) = new DatabaseApi(baseUrl)
}

class DatabaseApi(baseUrl: String) extends CirceSchema {

  /** List of all Databases Infos
    *
    * Expected answers: code 200 : Seq[DatabaseInfo] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def databaseInfos(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/databases/infos")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[DatabaseInfo]])

  /** Delete given Database
    *
    * Expected answers: code 200 : JsonValueBoolean () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param databaseName
    *   Name of your Database
    */
  def deleteDatabase(username: String, password: String, bearerToken: String, apiKey: String)(databaseName: String) =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/mongodb/databases/${databaseName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[JsonValueBoolean])

  /** All Information about given Database
    *
    * Expected answers: code 200 : DatabaseInfo () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param databaseName
    *   Name of your Database
    */
  def getDatabaseInfo(username: String, password: String, bearerToken: String, apiKey: String)(databaseName: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/databases/${databaseName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[DatabaseInfo])

  /** List of all Collections of the given database
    *
    * Expected answers: code 200 : Seq[String] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param databaseName
    *   Name of your Database
    */
  def listCollectionsByDatabase(username: String, password: String, bearerToken: String, apiKey: String)(databaseName: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/databases/${databaseName}/collections")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[String]])

  /** List of all Databases
    *
    * Expected answers: code 200 : Seq[String] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def listDatabases(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/databases")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[String]])

}
