/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.test;

import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.server.ActorHandler$;
import dev.mongocamp.server.Server$;
import dev.mongocamp.server.test.MongoTestServer$;
import dev.mongocamp.server.test.TestAdditions$;
import dev.mongocamp.server.test.client.api.InformationApi$;
import dev.mongocamp.server.test.client.model.Version;
import io.circe.Error;
import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Random$;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.ResponseException;

public final class TestServer$
implements LazyLogging {
    public static final TestServer$ MODULE$ = new TestServer$();
    private static final ExecutionContext ex;
    private static boolean serverRunning;
    private static boolean mongoServerStarted;
    private static int retries;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    /*
     * WARNING - void declaration
     */
    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ex = ActorHandler$.MODULE$.requestExecutionContext();
        serverRunning = false;
        mongoServerStarted = false;
        System.setProperty("CONNECTION_HOST", "localhost");
        System.setProperty("CONNECTION_DATABASE", "test");
        System.setProperty("PLUGINS_DIRECTORY", ((File)File$.MODULE$.temporaryDirectory(File$.MODULE$.temporaryDirectory$default$1(), File$.MODULE$.temporaryDirectory$default$2(), File$.MODULE$.temporaryDirectory$default$3()).get()).toString());
        retries = 0;
        while (!MODULE$.serverRunning()) {
            try {
                if (!MODULE$.mongoServerStarted()) {
                    void var0;
                    MongoTestServer$.MODULE$.startMongoDatabase();
                    MODULE$.setPort();
                    Future server = Server$.MODULE$.startServer(MODULE$.ex());
                    Future$.MODULE$.successful((Object)var0);
                    MODULE$.mongoServerStarted_$eq(true);
                }
                RequestT<Object, Either<ResponseException<String, Error>, Version>, Object> versionRequest = InformationApi$.MODULE$.apply(InformationApi$.MODULE$.apply$default$1()).version();
                Future versionFuture = (Future)TestAdditions$.MODULE$.backend().send(versionRequest);
                Response versionResponse = (Response)Await$.MODULE$.result((Awaitable)versionFuture, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
                ((Either)versionResponse.body()).getOrElse((Function0 & Serializable)() -> {
                    throw new Exception("error");
                });
                MODULE$.serverRunning_$eq(true);
            }
            catch (Exception e) {
                MODULE$.serverRunning_$eq(false);
                MODULE$.setPort();
                if (MODULE$.retries() > 60) {
                    throw new Exception(new StringBuilder(34).append("could not start server in ").append(MODULE$.retries()).append(" seconds").toString());
                }
                MODULE$.retries_$eq(MODULE$.retries() + 1);
            }
        }
    }

    private Logger logger$lzycompute() {
        TestServer$ testServer$ = this;
        synchronized (testServer$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public ExecutionContext ex() {
        return ex;
    }

    private boolean serverRunning() {
        return serverRunning;
    }

    private void serverRunning_$eq(boolean x$1) {
        serverRunning = x$1;
    }

    private boolean mongoServerStarted() {
        return mongoServerStarted;
    }

    private void mongoServerStarted_$eq(boolean x$1) {
        mongoServerStarted = x$1;
    }

    public int retries() {
        return retries;
    }

    public void retries_$eq(int x$1) {
        retries = x$1;
    }

    public boolean isServerRunning() {
        return this.serverRunning();
    }

    public String serverBaseUrl() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("http://%s:%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Server$.MODULE$.interface(), BoxesRunTime.boxToInteger((int)Server$.MODULE$.port())}));
    }

    public void setPort() {
        int port = Random$.MODULE$.nextInt(10000) + TestAdditions$.MODULE$.minPort();
        System.setProperty("SERVER_PORT", Integer.toString(port));
    }

    private TestServer$() {
    }
}

