/** mongocamp-server No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
  *
  * The version of the OpenAPI document: 1.4.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech). https://openapi-generator.tech Do not edit the class manually.
  */
package dev.mongocamp.server.test.client.api

import dev.mongocamp.server.test.TestServer
import dev.mongocamp.server.test.client.core.JsonSupport._
import dev.mongocamp.server.test.client.model._
import sttp.client3._
import sttp.model.Method
import dev.mongocamp.server.converter.CirceSchema

object JobsApi {
  def apply(baseUrl: String = TestServer.serverBaseUrl) = new JobsApi(baseUrl)
}

class JobsApi(baseUrl: String) extends CirceSchema {

  /** Delete Job and reload all Job Information
    *
    * Expected answers: code 200 : JsonValueBoolean () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param jobGroup
    *   Group Name of the Job
    * @param jobName
    *   Name of the Job
    */
  def deleteJob(username: String, password: String, bearerToken: String, apiKey: String)(jobGroup: String, jobName: String) =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/system/jobs/${jobGroup}/${jobName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[JsonValueBoolean])

  /** Execute scheduled Job manually
    *
    * Expected answers: code 200 : JsonValueBoolean () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param jobGroup
    *   Group Name of the Job
    * @param jobName
    *   Name of the Job
    */
  def executeJob(username: String, password: String, bearerToken: String, apiKey: String)(jobGroup: String, jobName: String) =
    basicRequest
      .method(Method.POST, uri"$baseUrl/system/jobs/${jobGroup}/${jobName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[JsonValueBoolean])

  /** Returns the List of all registered Jobs with full information
    *
    * Expected answers: code 200 : Seq[JobInformation] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def jobsList(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/system/jobs")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[JobInformation]])

  /** Returns the List of possible job classes
    *
    * Expected answers: code 200 : Seq[String] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def possibleJobsList(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/system/jobs/classes")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[String]])

  /** Register an Job and return the JobInformation with next schedule information
    *
    * Expected answers: code 200 : JobInformation () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code - Error
    * Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param jobConfig
    */
  def registerJob(username: String, password: String, bearerToken: String, apiKey: String)(jobConfig: JobConfig) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/system/jobs")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(jobConfig)
      .response(asJson[JobInformation])

  /** Add Job and get JobInformation back
    *
    * Expected answers: code 200 : JobInformation () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code - Error
    * Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param jobGroup
    *   Group Name of the Job
    * @param jobName
    *   Name of the Job
    * @param jobConfig
    */
  def updateJob(username: String, password: String, bearerToken: String, apiKey: String)(jobGroup: String, jobName: String, jobConfig: JobConfig) =
    basicRequest
      .method(Method.PATCH, uri"$baseUrl/system/jobs/${jobGroup}/${jobName}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(jobConfig)
      .response(asJson[JobInformation])

}
