/** mongocamp-server No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
  *
  * The version of the OpenAPI document: 1.4.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech). https://openapi-generator.tech Do not edit the class manually.
  */
package dev.mongocamp.server.test.client.api

import dev.mongocamp.server.test.TestServer
import dev.mongocamp.server.test.client.core.JsonSupport._
import dev.mongocamp.server.test.client.model._
import sttp.client3._
import sttp.model.Method

import java.io.File
import scala.collection.Seq
import dev.mongocamp.server.converter.CirceSchema

object FileApi {

  def apply(baseUrl: String = TestServer.serverBaseUrl) = new FileApi(baseUrl)
}

class FileApi(baseUrl: String) extends CirceSchema {

  /** Delete one File from given Bucket
    *
    * Expected answers: code 200 : DeleteResponse () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param fileId
    *   fileId to delete
    */
  def deleteFile(username: String, password: String, bearerToken: String, apiKey: String)(bucketName: String, fileId: String) =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/mongodb/buckets/${bucketName}/files/${fileId}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[DeleteResponse])

  /** Alternative to GET Route for more complex queries and URL max. Length
    *
    * Expected answers: code 200 : Seq[FileInformation] () Headers : x-pagination-count-rows - count all elements x-pagination-rows-per-page - Count elements
    * per page x-pagination-current-page - Current page x-pagination-count-pages - Count pages code 400 : String (Invalid value for: body, Invalid value for:
    * query parameter rowsPerPage, Invalid value for: query parameter page) code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message -
    * Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param mongoFindRequest
    * @param rowsPerPage
    *   Count elements per page
    * @param page
    *   Requested page of the ResultSets
    */
  def findFiles(
      username: String,
      password: String,
      bearerToken: String,
      apiKey: String
  )(bucketName: String, mongoFindRequest: MongoFindRequest, rowsPerPage: Option[Long] = None, page: Option[Long] = None) =
    basicRequest
      .method(Method.POST, uri"$baseUrl/mongodb/buckets/${bucketName}/files?rowsPerPage=${rowsPerPage}&page=${page}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(mongoFindRequest)
      .response(asJson[Seq[FileInformation]])

  /** Get File from given Bucket
    *
    * Expected answers: code 200 : File () Headers : Content-Length - Content-Disposition - Content-Type - cache-control - code 0 : ErrorDescription () Headers
    * : x-error-code - Error Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the
    * MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param fileId
    *   FileId to read
    */
  def getFile(username: String, password: String, bearerToken: String, apiKey: String)(bucketName: String, fileId: String, file: File) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/buckets/${bucketName}/files/${fileId}/file")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asFile(file))

  /** Get one FileInformation from given Bucket
    *
    * Expected answers: code 200 : FileInformation () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param fileId
    *   fileId to read
    */
  def getFileInformation(username: String, password: String, bearerToken: String, apiKey: String)(bucketName: String, fileId: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/mongodb/buckets/${bucketName}/files/${fileId}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[FileInformation])

  /** Insert one File in given Bucket
    *
    * Expected answers: code 200 : InsertResponse () code 400 : String (Invalid value for: body, Invalid value for: query parameter fileName) code 0 :
    * ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional
    * information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param file
    * @param metaData
    * @param fileName
    *   override filename of uploaded file
    */
  def insertFile(
      username: String,
      password: String,
      bearerToken: String,
      apiKey: String
  )(bucketName: String, file: File, metaData: String, fileName: Option[String] = None) =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/mongodb/buckets/${bucketName}/files?fileName=${fileName}")
      .contentType("multipart/form-data")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .multipartBody(
        multipartFile("file", file),
        multipart("metaData", metaData)
      )
      .response(asJson[InsertResponse])

  /** Get Files paginated from given Bucket
    *
    * Expected answers: code 200 : Seq[FileInformation] () Headers : x-pagination-count-rows - count all elements x-pagination-rows-per-page - Count elements
    * per page x-pagination-current-page - Current page x-pagination-count-pages - Count pages code 400 : String (Invalid value for: query parameter filter,
    * Invalid value for: query parameter sort, Invalid value for: query parameter projection, Invalid value for: query parameter rowsPerPage, Invalid value for:
    * query parameter page) code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the MongoCampException
    * x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param filter
    *   MongoDB Filter Query by Default all filter
    * @param sort
    *   MongoDB sorting
    * @param projection
    *   MongoDB projection
    * @param rowsPerPage
    *   Count elements per page
    * @param page
    *   Requested page of the ResultSets
    */
  def listFiles(username: String, password: String, bearerToken: String, apiKey: String)(
      bucketName: String,
      filter: Option[String] = None,
      sort: Option[String] = None,
      projection: Option[String] = None,
      rowsPerPage: Option[Long] = None,
      page: Option[Long] = None
  ) =
    basicRequest
      .method(
        Method.GET,
        uri"$baseUrl/mongodb/buckets/${bucketName}/files?filter=${filter}&sort=${sort}&projection=${projection}&rowsPerPage=${rowsPerPage}&page=${page}"
      )
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[FileInformation]])

  /** Replace MetaData and potential update FileName
    *
    * Expected answers: code 200 : UpdateResponse () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code - Error
    * Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param bucketName
    *   The name of your MongoDb Collection
    * @param fileId
    *   fileId to update
    * @param updateFileInformationRequest
    */
  def updateFileInformation(username: String, password: String, bearerToken: String, apiKey: String)(
      bucketName: String,
      fileId: String,
      updateFileInformationRequest: UpdateFileInformationRequest
  ) =
    basicRequest
      .method(Method.PATCH, uri"$baseUrl/mongodb/buckets/${bucketName}/files/${fileId}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(updateFileInformationRequest)
      .response(asJson[UpdateResponse])

}
