/** mongocamp-server No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
  *
  * The version of the OpenAPI document: 1.4.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech). https://openapi-generator.tech Do not edit the class manually.
  */
package dev.mongocamp.server.test.client.api

import dev.mongocamp.server.converter.CirceSchema
import dev.mongocamp.server.test.TestServer
import dev.mongocamp.server.test.client.core.JsonSupport._
import dev.mongocamp.server.test.client.model._
import sttp.client3._
import sttp.model.Method

import scala.collection.Seq

object ApplicationApi {

  def apply(baseUrl: String = TestServer.serverBaseUrl) = new ApplicationApi(baseUrl)
}

class ApplicationApi(baseUrl: String) extends CirceSchema {

  /** Get Configuration for key
    *
    * Expected answers: code 200 : MongoCampConfiguration () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param configurationKey
    *   configurationKey to get
    */
  def getConfig(username: String, password: String, bearerToken: String, apiKey: String)(configurationKey: String) =
    basicRequest
      .method(Method.GET, uri"$baseUrl/system/configurations/${configurationKey}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[MongoCampConfiguration])

  /** List all Configurations or filtered
    *
    * Expected answers: code 200 : Seq[MongoCampConfiguration] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of
    * the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def listConfigurations(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/system/configurations")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[Seq[MongoCampConfiguration]])

  /** Returns the Settings of the running MongoCamp Application.
    *
    * Expected answers: code 200 : SettingsResponse () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    */
  def settings(username: String, password: String, bearerToken: String, apiKey: String)() =
    basicRequest
      .method(Method.GET, uri"$baseUrl/system/settings")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .response(asJson[SettingsResponse])

  /** Update Configuration with the value
    *
    * Expected answers: code 200 : JsonValueBoolean () code 400 : String (Invalid value for: body) code 0 : ErrorDescription () Headers : x-error-code - Error
    * Code x-error-message - Message of the MongoCampException x-error-additional-info - Additional information for the MongoCampException
    *
    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
    *
    * @param configurationKey
    *   configurationKey to edit
    * @param jsonValueAny
    */
  def updateConfiguration(username: String, password: String, bearerToken: String, apiKey: String)(configurationKey: String, jsonValueAny: JsonValueAny) = {
    basicRequest
      .method(Method.PATCH, uri"$baseUrl/system/configurations/${configurationKey}")
      .contentType("application/json")
      .auth
      .basic(username, password)
      .auth
      .bearer(bearerToken)
      .header("X-AUTH-APIKEY", apiKey)
      .body(jsonValueAny)
      .response(asJson[JsonValueBoolean])
  }

  //  /** Returns the JVM Metrics of the running MongoCamp Application
  //    *
  //    * Expected answers: code 200 : Seq[Metric] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
  //    * MongoCampException x-error-additional-info - Additional information for the MongoCampException
  //    *
  //    * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
  //    */
  //  def jvmMetrics(username: String, password: String, bearerToken: String, apiKey: String)() =
  //    basicRequest
  //      .method(Method.GET, uri"$baseUrl/system/monitoring/jvm")
  //      .contentType("application/json")
  //      .auth
  //      .basic(username, password)
  //      .auth
  //      .bearer(bearerToken)
  //      .header("X-AUTH-APIKEY", apiKey)
  //      .response(asJson[Seq[Metric]])
//
//  /** Returns the Metrics of events of the running MongoCamp Application.
//   *
//   * Expected answers: code 200 : Seq[Metric] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
//   * MongoCampException x-error-additional-info - Additional information for the MongoCampException
//   *
//   * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
//   */
//  def eventMetrics(username: String, password: String, bearerToken: String, apiKey: String)() =
//    basicRequest
//      .method(Method.GET, uri"$baseUrl/system/monitoring/events")
//      .contentType("application/json")
//      .auth
//      .basic(username, password)
//      .auth
//      .bearer(bearerToken)
//      .header("X-AUTH-APIKEY", apiKey)
//      .response(asJson[Seq[Metric]])

//
//  /** Returns the MongoDB Metrics of the running MongoCamp Application
//   *
//   * Expected answers: code 200 : Seq[Metric] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
//   * MongoCampException x-error-additional-info - Additional information for the MongoCampException
//   *
//   * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
//   */
//  def mongoDbMetrics(username: String, password: String, bearerToken: String, apiKey: String)() =
//    basicRequest
//      .method(Method.GET, uri"$baseUrl/system/monitoring/mongodb")
//      .contentType("application/json")
//      .auth
//      .basic(username, password)
//      .auth
//      .bearer(bearerToken)
//      .header("X-AUTH-APIKEY", apiKey)
//      .response(asJson[Seq[Metric]])
//
//  /** Returns the Metrics of the MongoCamp System
//   *
//   * Expected answers: code 200 : Seq[Metric] () code 0 : ErrorDescription () Headers : x-error-code - Error Code x-error-message - Message of the
//   * MongoCampException x-error-additional-info - Additional information for the MongoCampException
//   *
//   * Available security schemes: httpAuth1 (http) httpAuth (http) apiKeyAuth (apiKey)
//   */
//  def systemMetrics(username: String, password: String, bearerToken: String, apiKey: String)() =
//    basicRequest
//      .method(Method.GET, uri"$baseUrl/system/monitoring/system")
//      .contentType("application/json")
//      .auth
//      .basic(username, password)
//      .auth
//      .bearer(bearerToken)
//      .header("X-AUTH-APIKEY", apiKey)
//      .response(asJson[Seq[Metric]])
}
