/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.database;

import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import dev.mongocamp.driver.mongodb.bson.codecs.CustomCodecProvider;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider;
import dev.mongocamp.driver.mongodb.database.DatabaseProvider$;
import dev.mongocamp.driver.mongodb.database.MongoConfig;
import dev.mongocamp.driver.mongodb.database.MongoConfig$;
import dev.mongocamp.driver.mongodb.database.MongoPoolOptions;
import dev.mongocamp.server.config.DefaultConfigurations$;
import dev.mongocamp.server.library.BuildInfo$;
import dev.mongocamp.server.service.ConfigurationRead;
import dev.mongocamp.server.service.ConfigurationRead$;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.mongodb.scala.MongoClient$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MongoDatabase$ {
    public static final MongoDatabase$ MODULE$ = new MongoDatabase$();
    private static String collectionPrefix;
    private static ArrayBuffer<ConnectionPoolListener> connectionPoolListener;
    private static ArrayBuffer<CommandListener> commandListener;
    private static String CollectionNameConfiguration;
    private static String CollectionNameUsers;
    private static String CollectionNameRoles;
    private static String CollectionNameTokenCache;
    private static String CollectionNameJobs;
    private static DatabaseProvider _databaseProvider;
    private static final ArrayBuffer<CodecProvider> userProviders;
    private static CodecRegistry providerRegistry;
    private static volatile byte bitmap$0;

    static {
        _databaseProvider = null;
        userProviders = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodecProvider[]{new CustomCodecProvider()}));
        providerRegistry = CodecRegistries.fromProviders((java.util.List)CollectionConverters$.MODULE$.BufferHasAsJava(MODULE$.userProviders()).asJava());
    }

    private String collectionPrefix$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                ConfigurationRead configRead = ConfigurationRead$.MODULE$.noPublishReader();
                collectionPrefix = (String)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthPrefix());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return collectionPrefix;
    }

    private String collectionPrefix() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.collectionPrefix$lzycompute();
        }
        return collectionPrefix;
    }

    private ArrayBuffer<ConnectionPoolListener> connectionPoolListener$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                connectionPoolListener = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return connectionPoolListener;
    }

    private ArrayBuffer<ConnectionPoolListener> connectionPoolListener() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.connectionPoolListener$lzycompute();
        }
        return connectionPoolListener;
    }

    private ArrayBuffer<CommandListener> commandListener$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                commandListener = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return commandListener;
    }

    private ArrayBuffer<CommandListener> commandListener() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.commandListener$lzycompute();
        }
        return commandListener;
    }

    private String CollectionNameConfiguration$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                CollectionNameConfiguration = new StringBuilder(13).append(this.collectionPrefix()).append("configuration").toString();
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return CollectionNameConfiguration;
    }

    public String CollectionNameConfiguration() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.CollectionNameConfiguration$lzycompute();
        }
        return CollectionNameConfiguration;
    }

    private String CollectionNameUsers$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                CollectionNameUsers = new StringBuilder(5).append(this.collectionPrefix()).append("users").toString();
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return CollectionNameUsers;
    }

    public String CollectionNameUsers() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.CollectionNameUsers$lzycompute();
        }
        return CollectionNameUsers;
    }

    private String CollectionNameRoles$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                CollectionNameRoles = new StringBuilder(5).append(this.collectionPrefix()).append("roles").toString();
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return CollectionNameRoles;
    }

    public String CollectionNameRoles() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.CollectionNameRoles$lzycompute();
        }
        return CollectionNameRoles;
    }

    private String CollectionNameTokenCache$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 0x40) == 0) {
                CollectionNameTokenCache = new StringBuilder(11).append(this.collectionPrefix()).append("token_cache").toString();
                bitmap$0 = (byte)(bitmap$0 | 0x40);
            }
        }
        return CollectionNameTokenCache;
    }

    public String CollectionNameTokenCache() {
        if ((byte)(bitmap$0 & 0x40) == 0) {
            return this.CollectionNameTokenCache$lzycompute();
        }
        return CollectionNameTokenCache;
    }

    private String CollectionNameJobs$lzycompute() {
        MongoDatabase$ mongoDatabase$ = this;
        synchronized (mongoDatabase$) {
            if ((byte)(bitmap$0 & 0x80) == 0) {
                CollectionNameJobs = new StringBuilder(4).append(this.collectionPrefix()).append("jobs").toString();
                bitmap$0 = (byte)(bitmap$0 | 0x80);
            }
        }
        return CollectionNameJobs;
    }

    public String CollectionNameJobs() {
        if ((byte)(bitmap$0 & 0x80) == 0) {
            return this.CollectionNameJobs$lzycompute();
        }
        return CollectionNameJobs;
    }

    private DatabaseProvider _databaseProvider() {
        return _databaseProvider;
    }

    private void _databaseProvider_$eq(DatabaseProvider x$1) {
        _databaseProvider = x$1;
    }

    public void registerConnectionPoolListener(ConnectionPoolListener listener) {
        this.connectionPoolListener().$plus$eq((Object)listener);
    }

    public void registerCommandListener(CommandListener listener) {
        this.commandListener().$plus$eq((Object)listener);
    }

    public DatabaseProvider databaseProvider() {
        Object object = this._databaseProvider() == null ? this.createNewDatabaseProvider() : BoxedUnit.UNIT;
        return this._databaseProvider();
    }

    public DatabaseProvider createNewDatabaseProvider() {
        ConfigurationRead configRead = ConfigurationRead$.MODULE$.noPublishReader();
        String x$1 = (String)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionDatabase());
        String x$2 = (String)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionHost());
        int x$3 = (int)BoxesRunTime.unboxToLong(configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionPort()));
        String x$4 = new StringBuilder(1).append(BuildInfo$.MODULE$.name()).append("/").append(BuildInfo$.MODULE$.version()).toString();
        Option x$5 = (Option)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionUsername());
        Option x$6 = (Option)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionPassword());
        String x$7 = (String)configRead.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyConnectionAuthDb());
        List x$8 = this.connectionPoolListener().toList();
        List x$9 = this.commandListener().toList();
        MongoPoolOptions x$10 = MongoConfig$.MODULE$.apply$default$8();
        List x$11 = MongoConfig$.MODULE$.apply$default$9();
        Option x$12 = MongoConfig$.MODULE$.apply$default$12();
        MongoConfig connection = new MongoConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$11, x$8, x$9, x$12);
        DatabaseProvider dbProvider = DatabaseProvider$.MODULE$.apply(connection, CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient$.MODULE$.DEFAULT_CODEC_REGISTRY(), this.providerRegistry()}));
        this._databaseProvider_$eq(dbProvider);
        return dbProvider;
    }

    public ArrayBuffer<CodecProvider> userProviders() {
        return userProviders;
    }

    public void addToProvider(CodecProvider provider) {
        this.userProviders().$plus$eq((Object)provider);
        this.providerRegistry_$eq(CodecRegistries.fromProviders((java.util.List)CollectionConverters$.MODULE$.BufferHasAsJava(this.userProviders()).asJava()));
        if (this._databaseProvider() != null) {
            this.createNewDatabaseProvider();
            return;
        }
    }

    private CodecRegistry providerRegistry() {
        return providerRegistry;
    }

    private void providerRegistry_$eq(CodecRegistry x$1) {
        providerRegistry = x$1;
    }

    private MongoDatabase$() {
    }
}

