/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.service;

import better.files.File;
import better.files.File$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.server.config.DefaultConfigurations$;
import dev.mongocamp.server.service.ConfigurationRead$;
import dev.mongocamp.server.service.CoursierModuleService$;
import dev.mongocamp.server.service.ReflectionService$;
import java.io.Serializable;
import java.net.URL;
import org.reflections.vfs.Vfs;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.util.ScalaClassLoader;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Q3AAB\u0004\u0001!!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0005M!)Q\b\u0001C\u0001}!)A\n\u0001C\u0001\u001b\")\u0011\u000b\u0001C\u0001%\ni\u0001\u000b\\;hS:\u001cVM\u001d<jG\u0016T!\u0001C\u0005\u0002\u000fM,'O^5dK*\u0011!bC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00051i\u0011!C7p]\u001e|7-Y7q\u0015\u0005q\u0011a\u00013fm\u000e\u00011c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qi\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\t1aY8n\u0013\t\u0001\u0013DA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\b\u000359W\r^\"iS2$g)\u001b7fgR\u0011qe\u000f\t\u0004QA\u001adBA\u0015/\u001d\tQS&D\u0001,\u0015\tas\"\u0001\u0004=e>|GOP\u0005\u0002)%\u0011qfE\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$G\u0001\u0003MSN$(BA\u0018\u0014!\t!\u0014(D\u00016\u0015\t1t'A\u0003gS2,7OC\u00019\u0003\u0019\u0011W\r\u001e;fe&\u0011!(\u000e\u0002\u0005\r&dW\rC\u0003=\u0005\u0001\u00071'A\u0002eSJ\f\u0011D^1mS\u0012\fG/\u001a$jY\u00164uN\u001d*fM2,7\r^5p]R\u0011qH\u0011\t\u0003%\u0001K!!Q\n\u0003\u000f\t{w\u000e\\3b]\")1i\u0001a\u0001\t\u0006\u0019QO\u001d7\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015a\u00018fi*\t\u0011*\u0001\u0003kCZ\f\u0017BA&G\u0005\r)&\u000bT\u0001\fY>\fG\r\u00157vO&t7\u000fF\u0001O!\t\u0011r*\u0003\u0002Q'\t!QK\\5u\u0003Ia\u0017n\u001d;PMJ+\u0017\rZ1cY\u0016,&\u000f\\:\u0015\u0003M\u00032\u0001\u000b\u0019E\u0001")
public class PluginService
implements LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        PluginService pluginService = this;
        synchronized (pluginService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private List<File> getChildFiles(File dir) {
        if (dir.isDirectory(dir.isDirectory$default$1())) {
            ArrayBuffer files = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            dir.children().toList().foreach((Function1 & Serializable)file -> {
                if (file.isDirectory(file.isDirectory$default$1())) {
                    return (ArrayBuffer)files.$plus$plus$eq(this.getChildFiles((File)file));
                }
                return (ArrayBuffer)files.$plus$eq(file);
            });
            return files.toList();
        }
        return Nil$.MODULE$;
    }

    public boolean validateFileForReflection(URL url) {
        boolean bl;
        try {
            Vfs.fromURL((URL)url);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void loadPlugins() {
        ReflectionService$.MODULE$.registerClassLoaders(this.getClass());
        ReflectionService$.MODULE$.registerClassLoaders(ReflectionService$.MODULE$.getClass());
        List<URL> listUrl = this.listOfReadableUrls();
        if (listUrl.nonEmpty()) {
            ScalaClassLoader.URLClassLoader urlClassLoader = new ScalaClassLoader.URLClassLoader(listUrl, this.getClass().getClassLoader());
            ReflectionService$.MODULE$.registerClassLoaders((ClassLoader)urlClassLoader);
            return;
        }
    }

    public List<URL> listOfReadableUrls() {
        File pluginDirectory = File$.MODULE$.apply((String)ConfigurationRead$.MODULE$.noPublishReader().getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyPluginsDirectory()), (Seq)Nil$.MODULE$);
        List files = (List)CoursierModuleService$.MODULE$.loadMavenConfiguredDependencies().$plus$plus((IterableOnce)(pluginDirectory.isDirectory(pluginDirectory.isDirectory$default$1()) ? this.getChildFiles(pluginDirectory) : package$.MODULE$.List().empty()));
        return files.map((Function1 & Serializable)x$1 -> x$1.url()).filter((Function1 & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)this.validateFileForReflection(url)));
    }

    public PluginService() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

