//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[Answer](index.md)

# Answer

@DelicateMokkeryApi

interface [Answer](index.md)&lt;out [T](index.md)&gt;

An answer for a function call. For blocking answers only [call](call.md) implementation is required. For suspending answers [callSuspend](call-suspend.md) should be implemented and [call](call.md) implementation should throw an exception. Use [Suspending](-suspending/index.md) for convenience.

#### Inheritors

| |
|---|
| [Suspending](-suspending/index.md) |
| [Const](-const/index.md) |
| [Block](-block/index.md) |
| [Throws](-throws/index.md) |
| [Autofill](-autofill/index.md) |

## Types

| Name | Summary |
|---|---|
| [Autofill](-autofill/index.md) | [common]<br>object [Autofill](-autofill/index.md) : [Answer](index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Provides *empty* value for standard types (e.g. 0 for numbers, &quot;&quot; for string, null for complex type). |
| [Block](-block/index.md) | [common]<br>class [Block](-block/index.md)&lt;[T](-block/index.md)&gt;(block: ([FunctionScope](../-function-scope/index.md)) -&gt; [T](-block/index.md)) : [Answer](index.md)&lt;[T](-block/index.md)&gt; <br>Calls block on [call](-block/call.md) and callSuspend. |
| [BlockSuspend](-block-suspend/index.md) | [common]<br>class [BlockSuspend](-block-suspend/index.md)&lt;[T](-block-suspend/index.md)&gt;(block: suspend ([FunctionScope](../-function-scope/index.md)) -&gt; [T](-block-suspend/index.md)) : [Answer.Suspending](-suspending/index.md)&lt;[T](-block-suspend/index.md)&gt; <br>Just like [Block](-block/index.md) but for suspending functions. |
| [Const](-const/index.md) | [common]<br>class [Const](-const/index.md)&lt;[T](-const/index.md)&gt;(value: [T](-const/index.md)) : [Answer](index.md)&lt;[T](-const/index.md)&gt; <br>Returns value on [call](-const/call.md) and callSuspend. |
| [Suspending](-suspending/index.md) | [common]<br>interface [Suspending](-suspending/index.md)&lt;[T](-suspending/index.md)&gt; : [Answer](index.md)&lt;[T](-suspending/index.md)&gt; <br>Convenience interface for custom suspending answers. By default, it throws runtime exception on [call](-suspending/call.md). |
| [Throws](-throws/index.md) | [common]<br>class [Throws](-throws/index.md)(throwable: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)) : [Answer](index.md)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt; <br>Throws throwable on [call](-throws/call.md) and callSuspend |

## Functions

| Name | Summary |
|---|---|
| [call](call.md) | [common]<br>abstract fun [call](call.md)(scope: [FunctionScope](../-function-scope/index.md)): [T](index.md)<br>Provides a return value for a function call with given [scope](call.md). |
| [callSuspend](call-suspend.md) | [common]<br>open suspend fun [callSuspend](call-suspend.md)(scope: [FunctionScope](../-function-scope/index.md)): [T](index.md)<br>Just like [call](call.md) but suspends. By default, it calls [call](call.md). |
