//[mokkery-runtime](../../../../index.md)/[dev.mokkery.answering.autofill](../../index.md)/[AutofillProvider](../index.md)/[Companion](index.md)

# Companion

[common]\
object [Companion](index.md) : [AutofillProvider](../index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; 

Implementation of [AutofillProvider](../index.md) that is used by [dev.mokkery.answering.Answer.Autofill](../../../dev.mokkery.answering/-answer/-autofill/index.md). It provides defaults and also allows registering custom providers.

Lookup order:

- 
   Custom implementations of [AutofillProvider](../index.md) registered with [registerProvider](register-provider.md).
- 
   Simplified type-to-function providers registered with [register](register.md)
- 
   Defaults

By default, it provides:

- 
   For any [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html) - 0
- 
   For [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) - false
- 
   For [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) - &quot;&quot;
- 
   For [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html) - Any::class
- 
   For [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) - [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)
- 
   For complex types:
- - 
      JVM and Wasm - null
   - 
      JS - empty object `{}`
   - 
      Native - reference to `object UnsafeValue`
- 
   For arrays - array with single element according to previous rules

## Functions

| Name | Summary |
|---|---|
| [provide](provide.md) | [common]<br>open override fun [provide](provide.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [AutofillProvider.Value](../-value/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;<br>Returns an instance of [Value.Provided](../-value/-provided/index.md), whenever value of [type](provide.md) can be provided. Otherwise, it returns [Value.Absent](../-value/-absent/index.md) |
| [provideValue](../../provide-value.md) | [common]<br>inline fun &lt;[T](../../provide-value.md)&gt; [AutofillProvider](../index.md)&lt;[T](../../provide-value.md)&gt;.[provideValue](../../provide-value.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [T](../../provide-value.md)?<br>Calls [AutofillProvider.provide](../provide.md) and returns [AutofillProvider.Value.Provided.value](../-value/-provided/value.md) if present. |
| [register](register.md) | [common]<br>fun &lt;[T](register.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [register](register.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](register.md)&gt;, provider: () -&gt; [T](register.md))<br>Registers a [provider](register.md) for [type](register.md). It overwrites any provider registered for the same [type](register.md) with this method. It's used after providers registered with [registerProvider](register-provider.md). |
| [register](../../register.md) | [common]<br>inline fun &lt;[T](../../register.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [AutofillProvider.Companion](index.md).[register](../../register.md)(noinline provider: () -&gt; [T](../../register.md))<br>Calls [AutofillProvider.register](register.md) with type [T](../../register.md). |
| [registerProvider](register-provider.md) | [common]<br>fun [registerProvider](register-provider.md)(provider: [AutofillProvider](../index.md)&lt;*&gt;)<br>Registers [provider](register-provider.md) to be used before previously registered providers (including initial defaults). |
| [unregister](unregister.md) | [common]<br>fun [unregister](unregister.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;)<br>Unregisters provider registered with [register](register.md) for [type](unregister.md) so it is no longer in use. |
| [unregister](../../unregister.md) | [common]<br>inline fun &lt;[T](../../unregister.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [AutofillProvider.Companion](index.md).[unregister](../../unregister.md)()<br>Calls [AutofillProvider.unregister](unregister.md) with type [T](../../unregister.md). |
| [unregisterProvider](unregister-provider.md) | [common]<br>fun [unregisterProvider](unregister-provider.md)(provider: [AutofillProvider](../index.md)&lt;*&gt;)<br>Unregisters [provider](unregister-provider.md) registered with [registerProvider](register-provider.md) so it is no longer in use. |
