//[mokkery-runtime](../../../index.md)/[dev.mokkery.matcher](../index.md)/[ArgMatchersScope](index.md)

# ArgMatchersScope

[common]\
interface [ArgMatchersScope](index.md)

Scope for registering argument matchers.

## Functions

| Name | Summary |
|---|---|
| [and](../../dev.mokkery.matcher.logical/and.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.logical/and.md)&gt; [ArgMatchersScope](index.md).[and](../../dev.mokkery.matcher.logical/and.md)(first: [T](../../dev.mokkery.matcher.logical/and.md), second: [T](../../dev.mokkery.matcher.logical/and.md), vararg moreMatchers: [T](../../dev.mokkery.matcher.logical/and.md)): [T](../../dev.mokkery.matcher.logical/and.md)<br>Matches argument that satisfies all the matchers ([first](../../dev.mokkery.matcher.logical/and.md), [second](../../dev.mokkery.matcher.logical/and.md) and all from [moreMatchers](../../dev.mokkery.matcher.logical/and.md)). It must not receive literals. Only matchers allowed! |
| [any](../any.md) | [common]<br>inline fun &lt;[T](../any.md)&gt; [ArgMatchersScope](index.md).[any](../any.md)(): [T](../any.md)<br>Matches any argument. |
| [anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.varargs/any-varargs.md)&gt; [ArgMatchersScope](index.md).[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.varargs/any-varargs.md)&gt;<br>Matches any sequence of varargs. |
| [anyVarargsBoolean](../../dev.mokkery.matcher.varargs/any-varargs-boolean.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsBoolean](../../dev.mokkery.matcher.varargs/any-varargs-boolean.md)(): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [anyVarargsByte](../../dev.mokkery.matcher.varargs/any-varargs-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsByte](../../dev.mokkery.matcher.varargs/any-varargs-byte.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [anyVarargsChar](../../dev.mokkery.matcher.varargs/any-varargs-char.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsChar](../../dev.mokkery.matcher.varargs/any-varargs-char.md)(): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [anyVarargsDouble](../../dev.mokkery.matcher.varargs/any-varargs-double.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsDouble](../../dev.mokkery.matcher.varargs/any-varargs-double.md)(): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [anyVarargsFloat](../../dev.mokkery.matcher.varargs/any-varargs-float.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsFloat](../../dev.mokkery.matcher.varargs/any-varargs-float.md)(): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [anyVarargsInt](../../dev.mokkery.matcher.varargs/any-varargs-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsInt](../../dev.mokkery.matcher.varargs/any-varargs-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [anyVarargsLong](../../dev.mokkery.matcher.varargs/any-varargs-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsLong](../../dev.mokkery.matcher.varargs/any-varargs-long.md)(): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [anyVarargsShort](../../dev.mokkery.matcher.varargs/any-varargs-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsShort](../../dev.mokkery.matcher.varargs/any-varargs-short.md)(): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [anyVarargsUByte](../../dev.mokkery.matcher.varargs/any-varargs-u-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUByte](../../dev.mokkery.matcher.varargs/any-varargs-u-byte.md)(): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [anyVarargsUInt](../../dev.mokkery.matcher.varargs/any-varargs-u-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUInt](../../dev.mokkery.matcher.varargs/any-varargs-u-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [anyVarargsULong](../../dev.mokkery.matcher.varargs/any-varargs-u-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsULong](../../dev.mokkery.matcher.varargs/any-varargs-u-long.md)(): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [anyVarargsUShort](../../dev.mokkery.matcher.varargs/any-varargs-u-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUShort](../../dev.mokkery.matcher.varargs/any-varargs-u-short.md)(): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [capture](../../dev.mokkery.matcher.capture/capture.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.capture/capture.md)&gt; [ArgMatchersScope](index.md).[capture](../../dev.mokkery.matcher.capture/capture.md)(container: [Capture](../../dev.mokkery.matcher.capture/-capture/index.md)&lt;[T](../../dev.mokkery.matcher.capture/capture.md)&gt;, matcher: [T](../../dev.mokkery.matcher.capture/capture.md) = any()): [T](../../dev.mokkery.matcher.capture/capture.md)<br>Matches an argument with [matcher](../../dev.mokkery.matcher.capture/capture.md) and captures matching arguments into [capture](../../dev.mokkery.matcher.capture/capture.md). Arguments are captured only if all other matchers match.<br>[common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.capture/capture.md)&gt; [ArgMatchersScope](index.md).[capture](../../dev.mokkery.matcher.capture/capture.md)(list: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[T](../../dev.mokkery.matcher.capture/capture.md)&gt;, matcher: [T](../../dev.mokkery.matcher.capture/capture.md) = any()): [T](../../dev.mokkery.matcher.capture/capture.md)<br>Matches an argument with [matcher](../../dev.mokkery.matcher.capture/capture.md) and captures matching arguments into [list](../../dev.mokkery.matcher.capture/capture.md). Arguments are captured only if all other matchers match. |
| [contentDeepEq](../../dev.mokkery.matcher.collections/content-deep-eq.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/content-deep-eq.md)&gt; [ArgMatchersScope](index.md).[contentDeepEq](../../dev.mokkery.matcher.collections/content-deep-eq.md)(array: [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.collections/content-deep-eq.md)&gt;): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.collections/content-deep-eq.md)&gt;<br>Matches an array that is equal to [array](../../dev.mokkery.matcher.collections/content-deep-eq.md) with [contentDeepEquals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/index.html). |
| [contentEq](../../dev.mokkery.matcher.collections/content-eq.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/content-eq.md)&gt; [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.collections/content-eq.md)&gt;): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.collections/content-eq.md)&gt;<br>Matches an array that has the same content as [array](../../dev.mokkery.matcher.collections/content-eq.md).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html)): [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html).<br>[common]<br>fun [ArgMatchersScope](index.md).[contentEq](../../dev.mokkery.matcher.collections/content-eq.md)(array: [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[contentEq](../../dev.mokkery.matcher.collections/content-eq.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [eq](../eq.md) | [common]<br>inline fun &lt;[T](../eq.md)&gt; [ArgMatchersScope](index.md).[eq](../eq.md)(value: [T](../eq.md)): [T](../eq.md)<br>Matches an argument that is equal to [value](../eq.md). It can be replaced with [value](../eq.md) literal. |
| [eqRef](../eq-ref.md) | [common]<br>inline fun &lt;[T](../eq-ref.md)&gt; [ArgMatchersScope](index.md).[eqRef](../eq-ref.md)(value: [T](../eq-ref.md)): [T](../eq-ref.md)<br>Matches an argument whose reference is equal to [value](../eq-ref.md)'s reference. |
| [gt](../gt.md) | [common]<br>inline fun &lt;[T](../gt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../gt.md)&gt;&gt; [ArgMatchersScope](index.md).[gt](../gt.md)(value: [T](../gt.md)): [T](../gt.md)<br>Matches argument that is greater than [value](../gt.md). |
| [gte](../gte.md) | [common]<br>inline fun &lt;[T](../gte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../gte.md)&gt;&gt; [ArgMatchersScope](index.md).[gte](../gte.md)(value: [T](../gte.md)): [T](../gte.md)<br>Matches an argument that is greater than or equal to [value](../gte.md). |
| [isIn](../../dev.mokkery.matcher.collections/is-in.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/is-in.md)&gt; [ArgMatchersScope](index.md).[isIn](../../dev.mokkery.matcher.collections/is-in.md)(vararg values: [T](../../dev.mokkery.matcher.collections/is-in.md)): [T](../../dev.mokkery.matcher.collections/is-in.md)<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/is-in.md)&gt; [ArgMatchersScope](index.md).[isIn](../../dev.mokkery.matcher.collections/is-in.md)(values: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[T](../../dev.mokkery.matcher.collections/is-in.md)&gt;): [T](../../dev.mokkery.matcher.collections/is-in.md)<br>Matches argument that is present in [values](../../dev.mokkery.matcher.collections/is-in.md). |
| [isNotIn](../../dev.mokkery.matcher.collections/is-not-in.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/is-not-in.md)&gt; [ArgMatchersScope](index.md).[isNotIn](../../dev.mokkery.matcher.collections/is-not-in.md)(vararg values: [T](../../dev.mokkery.matcher.collections/is-not-in.md)): [T](../../dev.mokkery.matcher.collections/is-not-in.md)<br>inline fun &lt;[T](../../dev.mokkery.matcher.collections/is-not-in.md)&gt; [ArgMatchersScope](index.md).[isNotIn](../../dev.mokkery.matcher.collections/is-not-in.md)(values: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[T](../../dev.mokkery.matcher.collections/is-not-in.md)&gt;): [T](../../dev.mokkery.matcher.collections/is-not-in.md)<br>Matches argument that is not present in [values](../../dev.mokkery.matcher.collections/is-not-in.md). |
| [lt](../lt.md) | [common]<br>inline fun &lt;[T](../lt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../lt.md)&gt;&gt; [ArgMatchersScope](index.md).[lt](../lt.md)(value: [T](../lt.md)): [T](../lt.md)<br>Matches argument that is less than [value](../lt.md). |
| [lte](../lte.md) | [common]<br>inline fun &lt;[T](../lte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../lte.md)&gt;&gt; [ArgMatchersScope](index.md).[lte](../lte.md)(value: [T](../lte.md)): [T](../lte.md)<br>Matches an argument that is less than or equal to [value](../lte.md). |
| [matches](matches.md) | [common]<br>@DelicateMokkeryApi<br>abstract fun &lt;[T](matches.md)&gt; [matches](matches.md)(argType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, matcher: [ArgMatcher](../-arg-matcher/index.md)&lt;[T](matches.md)&gt;): [T](matches.md)<br>Registers [matcher](matches.md) with given [argType](matches.md). |
| [matches](../matches.md) | [common]<br>@DelicateMokkeryApi<br>inline fun &lt;[T](../matches.md)&gt; [ArgMatchersScope](index.md).[matches](../matches.md)(matcher: [ArgMatcher](../-arg-matcher/index.md)&lt;[T](../matches.md)&gt;): [T](../matches.md)<br>Registers [matcher](../matches.md) with [T](../matches.md)::class as argument type. |
| [matching](../matching.md) | [common]<br>inline fun &lt;[T](../matching.md)&gt; [ArgMatchersScope](index.md).[matching](../matching.md)(noinline toString: () -&gt; [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = { &quot;matching(...)&quot; }, noinline predicate: ([T](../matching.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [T](../matching.md)<br>Matches an argument according to the [predicate](../matching.md). Registered matcher [Any.toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html) calls [toString](../matching.md). |
| [neq](../neq.md) | [common]<br>inline fun &lt;[T](../neq.md)&gt; [ArgMatchersScope](index.md).[neq](../neq.md)(value: [T](../neq.md)): [T](../neq.md)<br>Matches an argument that is not equal to [value](../neq.md). |
| [neqRef](../neq-ref.md) | [common]<br>inline fun &lt;[T](../neq-ref.md)&gt; [ArgMatchersScope](index.md).[neqRef](../neq-ref.md)(value: [T](../neq-ref.md)): [T](../neq-ref.md)<br>Matches an argument whose reference is not equal to [value](../neq-ref.md)'s reference. |
| [not](../../dev.mokkery.matcher.logical/not.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.logical/not.md)&gt; [ArgMatchersScope](index.md).[not](../../dev.mokkery.matcher.logical/not.md)(matcher: [T](../../dev.mokkery.matcher.logical/not.md)): [T](../../dev.mokkery.matcher.logical/not.md)<br>Matches argument that does not satisfy [matcher](../../dev.mokkery.matcher.logical/not.md). It must not receive literals. Only matchers allowed! |
| [ofType](../of-type.md) | [common]<br>inline fun &lt;[T](../of-type.md)&gt; [ArgMatchersScope](index.md).[ofType](../of-type.md)(): [T](../of-type.md)<br>Matches an argument that is an instance of type [T](../of-type.md). |
| [onArg](../../dev.mokkery.matcher.capture/on-arg.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.capture/on-arg.md)&gt; [ArgMatchersScope](index.md).[onArg](../../dev.mokkery.matcher.capture/on-arg.md)(matcher: [T](../../dev.mokkery.matcher.capture/on-arg.md) = any(), noinline block: ([T](../../dev.mokkery.matcher.capture/on-arg.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): [T](../../dev.mokkery.matcher.capture/on-arg.md)<br>Short for [capture](../../dev.mokkery.matcher.capture/capture.md) with [Capture.callback](../../dev.mokkery.matcher.capture/-capture/-companion/callback.md). |
| [or](../../dev.mokkery.matcher.logical/or.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.logical/or.md)&gt; [ArgMatchersScope](index.md).[or](../../dev.mokkery.matcher.logical/or.md)(first: [T](../../dev.mokkery.matcher.logical/or.md), second: [T](../../dev.mokkery.matcher.logical/or.md), vararg moreMatchers: [T](../../dev.mokkery.matcher.logical/or.md)): [T](../../dev.mokkery.matcher.logical/or.md)<br>Matches argument that satisfies any matcher ([first](../../dev.mokkery.matcher.logical/or.md), [second](../../dev.mokkery.matcher.logical/or.md) or any from [moreMatchers](../../dev.mokkery.matcher.logical/or.md)). It must not receive literals. Only matchers allowed! |
| [varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.varargs/varargs-all.md)&gt; [ArgMatchersScope](index.md).[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md)(noinline predicate: ([T](../../dev.mokkery.matcher.varargs/varargs-all.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.varargs/varargs-all.md)&gt;<br>Matches a sequence of varargs with all elements satisfying the given [predicate](../../dev.mokkery.matcher.varargs/varargs-all.md). |
| [varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.varargs/varargs-any.md)&gt; [ArgMatchersScope](index.md).[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md)(noinline predicate: ([T](../../dev.mokkery.matcher.varargs/varargs-any.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.varargs/varargs-any.md)&gt;<br>Matches a sequence of varargs with any element satisfying the given [predicate](../../dev.mokkery.matcher.varargs/varargs-any.md). |
| [varargsBooleanAll](../../dev.mokkery.matcher.varargs/varargs-boolean-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsBooleanAll](../../dev.mokkery.matcher.varargs/varargs-boolean-all.md)(noinline predicate: ([Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [varargsBooleanAny](../../dev.mokkery.matcher.varargs/varargs-boolean-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsBooleanAny](../../dev.mokkery.matcher.varargs/varargs-boolean-any.md)(noinline predicate: ([Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [varargsByteAll](../../dev.mokkery.matcher.varargs/varargs-byte-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsByteAll](../../dev.mokkery.matcher.varargs/varargs-byte-all.md)(noinline predicate: ([Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [varargsByteAny](../../dev.mokkery.matcher.varargs/varargs-byte-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsByteAny](../../dev.mokkery.matcher.varargs/varargs-byte-any.md)(noinline predicate: ([Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [varargsCharAll](../../dev.mokkery.matcher.varargs/varargs-char-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsCharAll](../../dev.mokkery.matcher.varargs/varargs-char-all.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [varargsCharAny](../../dev.mokkery.matcher.varargs/varargs-char-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsCharAny](../../dev.mokkery.matcher.varargs/varargs-char-any.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [varargsDoubleAll](../../dev.mokkery.matcher.varargs/varargs-double-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsDoubleAll](../../dev.mokkery.matcher.varargs/varargs-double-all.md)(noinline predicate: ([Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [varargsDoubleAny](../../dev.mokkery.matcher.varargs/varargs-double-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsDoubleAny](../../dev.mokkery.matcher.varargs/varargs-double-any.md)(noinline predicate: ([Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [varargsFloatAll](../../dev.mokkery.matcher.varargs/varargs-float-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsFloatAll](../../dev.mokkery.matcher.varargs/varargs-float-all.md)(noinline predicate: ([Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [varargsFloatAny](../../dev.mokkery.matcher.varargs/varargs-float-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsFloatAny](../../dev.mokkery.matcher.varargs/varargs-float-any.md)(noinline predicate: ([Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [varargsIntAll](../../dev.mokkery.matcher.varargs/varargs-int-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsIntAll](../../dev.mokkery.matcher.varargs/varargs-int-all.md)(noinline predicate: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [varargsIntAny](../../dev.mokkery.matcher.varargs/varargs-int-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsIntAny](../../dev.mokkery.matcher.varargs/varargs-int-any.md)(noinline predicate: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [varargsLongAll](../../dev.mokkery.matcher.varargs/varargs-long-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsLongAll](../../dev.mokkery.matcher.varargs/varargs-long-all.md)(noinline predicate: ([Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [varargsLongAny](../../dev.mokkery.matcher.varargs/varargs-long-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsLongAny](../../dev.mokkery.matcher.varargs/varargs-long-any.md)(noinline predicate: ([Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [varargsShortAll](../../dev.mokkery.matcher.varargs/varargs-short-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsShortAll](../../dev.mokkery.matcher.varargs/varargs-short-all.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [varargsShortAny](../../dev.mokkery.matcher.varargs/varargs-short-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsShortAny](../../dev.mokkery.matcher.varargs/varargs-short-any.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [varargsUByteAll](../../dev.mokkery.matcher.varargs/varargs-u-byte-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUByteAll](../../dev.mokkery.matcher.varargs/varargs-u-byte-all.md)(noinline predicate: ([UByte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [varargsUByteAny](../../dev.mokkery.matcher.varargs/varargs-u-byte-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUByteAny](../../dev.mokkery.matcher.varargs/varargs-u-byte-any.md)(noinline predicate: ([UByte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [varargsUIntAll](../../dev.mokkery.matcher.varargs/varargs-u-int-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUIntAll](../../dev.mokkery.matcher.varargs/varargs-u-int-all.md)(noinline predicate: ([UInt](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [varargsUIntAny](../../dev.mokkery.matcher.varargs/varargs-u-int-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUIntAny](../../dev.mokkery.matcher.varargs/varargs-u-int-any.md)(noinline predicate: ([UInt](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [varargsULongAll](../../dev.mokkery.matcher.varargs/varargs-u-long-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsULongAll](../../dev.mokkery.matcher.varargs/varargs-u-long-all.md)(noinline predicate: ([ULong](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [varargsULongAny](../../dev.mokkery.matcher.varargs/varargs-u-long-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsULongAny](../../dev.mokkery.matcher.varargs/varargs-u-long-any.md)(noinline predicate: ([ULong](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [varargsUShortAll](../../dev.mokkery.matcher.varargs/varargs-u-short-all.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUShortAll](../../dev.mokkery.matcher.varargs/varargs-u-short-all.md)(noinline predicate: ([UShort](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[varargsAll](../../dev.mokkery.matcher.varargs/varargs-all.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [varargsUShortAny](../../dev.mokkery.matcher.varargs/varargs-u-short-any.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUShortAny](../../dev.mokkery.matcher.varargs/varargs-u-short-any.md)(noinline predicate: ([UShort](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[varargsAny](../../dev.mokkery.matcher.varargs/varargs-any.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
