//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[BlockingAnsweringScope](index.md)

# BlockingAnsweringScope

[common]\
interface [BlockingAnsweringScope](index.md)&lt;[T](index.md)&gt; : [AnsweringScope](../-answering-scope/index.md)&lt;[T](index.md)&gt; 

Marker interface for defining an answer for non-suspend function call.

## Functions

| Name | Summary |
|---|---|
| [answers](../-answering-scope/answers.md) | [common]<br>@DelicateMokkeryApi<br>abstract fun [answers](../-answering-scope/answers.md)(answer: [Answer](../-answer/index.md)&lt;[T](index.md)&gt;)<br>Registers given [answer](../-answering-scope/answers.md) for a function call. Direct usage requires care, because it allows to register suspending answer for non-suspend function. |
| [calls](../calls.md) | [common]<br>infix fun &lt;[T](../calls.md)&gt; [BlockingAnsweringScope](index.md)&lt;[T](../calls.md)&gt;.[calls](../calls.md)(block: ([FunctionScope](../-function-scope/index.md)) -&gt; [T](../calls.md))<br>Function call executes [block](../calls.md). |
| [returns](../returns.md) | [common]<br>infix fun &lt;[T](../returns.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../returns.md)&gt;.[returns](../returns.md)(value: [T](../returns.md))<br>Function call always returns [value](../returns.md). |
| [throws](../throws.md) | [common]<br>infix fun &lt;[T](../throws.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../throws.md)&gt;.[throws](../throws.md)(error: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html))<br>Function call always throws [error](../throws.md). |
