//[mokkery-runtime](../../../index.md)/[dev.mokkery.matcher](../index.md)/[ArgMatchersScope](index.md)

# ArgMatchersScope

[common]\
interface [ArgMatchersScope](index.md)

Scope for registering argument matchers.

## Functions

| Name | Summary |
|---|---|
| [any](../any.md) | [common]<br>inline fun &lt;[T](../any.md)&gt; [ArgMatchersScope](index.md).[any](../any.md)(): [T](../any.md)<br>Matches any argument. |
| [anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.varargs/any-varargs.md)&gt; [ArgMatchersScope](index.md).[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.varargs/any-varargs.md)&gt;<br>Matches a vararg with any elements sequence. |
| [anyVarargsBoolean](../../dev.mokkery.matcher.varargs/any-varargs-boolean.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsBoolean](../../dev.mokkery.matcher.varargs/any-varargs-boolean.md)(): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [anyVarargsByte](../../dev.mokkery.matcher.varargs/any-varargs-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsByte](../../dev.mokkery.matcher.varargs/any-varargs-byte.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [anyVarargsChar](../../dev.mokkery.matcher.varargs/any-varargs-char.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsChar](../../dev.mokkery.matcher.varargs/any-varargs-char.md)(): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [anyVarargsDouble](../../dev.mokkery.matcher.varargs/any-varargs-double.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsDouble](../../dev.mokkery.matcher.varargs/any-varargs-double.md)(): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [anyVarargsFloat](../../dev.mokkery.matcher.varargs/any-varargs-float.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsFloat](../../dev.mokkery.matcher.varargs/any-varargs-float.md)(): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [anyVarargsInt](../../dev.mokkery.matcher.varargs/any-varargs-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsInt](../../dev.mokkery.matcher.varargs/any-varargs-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [anyVarargsLong](../../dev.mokkery.matcher.varargs/any-varargs-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsLong](../../dev.mokkery.matcher.varargs/any-varargs-long.md)(): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [anyVarargsShort](../../dev.mokkery.matcher.varargs/any-varargs-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsShort](../../dev.mokkery.matcher.varargs/any-varargs-short.md)(): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [anyVarargsUByte](../../dev.mokkery.matcher.varargs/any-varargs-u-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUByte](../../dev.mokkery.matcher.varargs/any-varargs-u-byte.md)(): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [anyVarargsUInt](../../dev.mokkery.matcher.varargs/any-varargs-u-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUInt](../../dev.mokkery.matcher.varargs/any-varargs-u-int.md)(): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [anyVarargsULong](../../dev.mokkery.matcher.varargs/any-varargs-u-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsULong](../../dev.mokkery.matcher.varargs/any-varargs-u-long.md)(): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [anyVarargsUShort](../../dev.mokkery.matcher.varargs/any-varargs-u-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[anyVarargsUShort](../../dev.mokkery.matcher.varargs/any-varargs-u-short.md)(): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[anyVarargs](../../dev.mokkery.matcher.varargs/any-varargs.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
| [eq](../eq.md) | [common]<br>inline fun &lt;[T](../eq.md)&gt; [ArgMatchersScope](index.md).[eq](../eq.md)(value: [T](../eq.md)): [T](../eq.md)<br>Matches an argument that is equal to [value](../eq.md). It can be replaced with [value](../eq.md) literal. |
| [eqRef](../eq-ref.md) | [common]<br>inline fun &lt;[T](../eq-ref.md)&gt; [ArgMatchersScope](index.md).[eqRef](../eq-ref.md)(value: [T](../eq-ref.md)): [T](../eq-ref.md)<br>Matches an argument whose reference is equal to [value](../eq-ref.md)'s reference. |
| [gt](../gt.md) | [common]<br>inline fun &lt;[T](../gt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../gt.md)&gt;&gt; [ArgMatchersScope](index.md).[gt](../gt.md)(value: [T](../gt.md)): [T](../gt.md)<br>Matches argument that is greater than [value](../gt.md). |
| [gte](../gte.md) | [common]<br>inline fun &lt;[T](../gte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../gte.md)&gt;&gt; [ArgMatchersScope](index.md).[gte](../gte.md)(value: [T](../gte.md)): [T](../gte.md)<br>Matches an argument that is greater than or equal to [value](../gte.md). |
| [lt](../lt.md) | [common]<br>inline fun &lt;[T](../lt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../lt.md)&gt;&gt; [ArgMatchersScope](index.md).[lt](../lt.md)(value: [T](../lt.md)): [T](../lt.md)<br>Matches argument that is less than [value](../lt.md). |
| [lte](../lte.md) | [common]<br>inline fun &lt;[T](../lte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](../lte.md)&gt;&gt; [ArgMatchersScope](index.md).[lte](../lte.md)(value: [T](../lte.md)): [T](../lte.md)<br>Matches an argument that is less than or equal to [value](../lte.md). |
| [matches](matches.md) | [common]<br>@DelicateMokkeryApi<br>abstract fun &lt;[T](matches.md)&gt; [matches](matches.md)(argType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, matcher: [ArgMatcher](../-arg-matcher/index.md)&lt;[T](matches.md)&gt;): [T](matches.md)<br>Registers [matcher](matches.md) with given [argType](matches.md). |
| [matches](../matches.md) | [common]<br>@DelicateMokkeryApi<br>inline fun &lt;[T](../matches.md)&gt; [ArgMatchersScope](index.md).[matches](../matches.md)(matcher: [ArgMatcher](../-arg-matcher/index.md)&lt;[T](../matches.md)&gt;): [T](../matches.md)<br>Registers [matcher](../matches.md) with [T](../matches.md)::class as argument type. |
| [matching](../matching.md) | [common]<br>inline fun &lt;[T](../matching.md)&gt; [ArgMatchersScope](index.md).[matching](../matching.md)(noinline toString: () -&gt; [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = { &quot;matching(...)&quot; }, noinline predicate: ([T](../matching.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [T](../matching.md)<br>Matches an argument according to the [predicate](../matching.md). Registered matcher [Any.toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html) calls [toString](../matching.md). |
| [neq](../neq.md) | [common]<br>inline fun &lt;[T](../neq.md)&gt; [ArgMatchersScope](index.md).[neq](../neq.md)(value: [T](../neq.md)): [T](../neq.md)<br>Matches an argument that is not equal to [value](../neq.md). |
| [neqRef](../neq-ref.md) | [common]<br>inline fun &lt;[T](../neq-ref.md)&gt; [ArgMatchersScope](index.md).[neqRef](../neq-ref.md)(value: [T](../neq-ref.md)): [T](../neq-ref.md)<br>Matches an argument whose reference is not equal to [value](../neq-ref.md)'s reference. |
| [varargs](../../dev.mokkery.matcher.varargs/varargs.md) | [common]<br>inline fun &lt;[T](../../dev.mokkery.matcher.varargs/varargs.md)&gt; [ArgMatchersScope](index.md).[varargs](../../dev.mokkery.matcher.varargs/varargs.md)(noinline predicate: ([T](../../dev.mokkery.matcher.varargs/varargs.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[T](../../dev.mokkery.matcher.varargs/varargs.md)&gt;<br>Matches a vararg whose elements all satisfy the given [predicate](../../dev.mokkery.matcher.varargs/varargs.md). |
| [varargsBoolean](../../dev.mokkery.matcher.varargs/varargs-boolean.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsBoolean](../../dev.mokkery.matcher.varargs/varargs-boolean.md)(noinline predicate: ([Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [BooleanArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean-array/index.html). |
| [varargsByte](../../dev.mokkery.matcher.varargs/varargs-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsByte](../../dev.mokkery.matcher.varargs/varargs-byte.md)(noinline predicate: ([Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html). |
| [varargsChar](../../dev.mokkery.matcher.varargs/varargs-char.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsChar](../../dev.mokkery.matcher.varargs/varargs-char.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [CharArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html). |
| [varargsDouble](../../dev.mokkery.matcher.varargs/varargs-double.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsDouble](../../dev.mokkery.matcher.varargs/varargs-double.md)(noinline predicate: ([Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [DoubleArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double-array/index.html). |
| [varargsFloat](../../dev.mokkery.matcher.varargs/varargs-float.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsFloat](../../dev.mokkery.matcher.varargs/varargs-float.md)(noinline predicate: ([Float](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [FloatArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float-array/index.html). |
| [varargsInt](../../dev.mokkery.matcher.varargs/varargs-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsInt](../../dev.mokkery.matcher.varargs/varargs-int.md)(noinline predicate: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html). |
| [varargsLong](../../dev.mokkery.matcher.varargs/varargs-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsLong](../../dev.mokkery.matcher.varargs/varargs-long.md)(noinline predicate: ([Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [LongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long-array/index.html). |
| [varargsShort](../../dev.mokkery.matcher.varargs/varargs-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsShort](../../dev.mokkery.matcher.varargs/varargs-short.md)(noinline predicate: ([Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [ShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short-array/index.html). |
| [varargsUByte](../../dev.mokkery.matcher.varargs/varargs-u-byte.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUByte](../../dev.mokkery.matcher.varargs/varargs-u-byte.md)(noinline predicate: ([UByte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [UByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-byte-array/index.html). |
| [varargsUInt](../../dev.mokkery.matcher.varargs/varargs-u-int.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUInt](../../dev.mokkery.matcher.varargs/varargs-u-int.md)(noinline predicate: ([UInt](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [IntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [UIntArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-int-array/index.html). |
| [varargsULong](../../dev.mokkery.matcher.varargs/varargs-u-long.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsULong](../../dev.mokkery.matcher.varargs/varargs-u-long.md)(noinline predicate: ([ULong](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [ULongArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-long-array/index.html). |
| [varargsUShort](../../dev.mokkery.matcher.varargs/varargs-u-short.md) | [common]<br>inline fun [ArgMatchersScope](index.md).[varargsUShort](../../dev.mokkery.matcher.varargs/varargs-u-short.md)(noinline predicate: ([UShort](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short/index.html)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html)<br>[varargs](../../dev.mokkery.matcher.varargs/varargs.md) variant for [UShortArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-u-short-array/index.html). |
