//[mokkery-runtime](../../index.md)/[dev.mokkery.answering.autofill](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [AutofillProvider](-autofill-provider/index.md) | [common]<br>fun interface [AutofillProvider](-autofill-provider/index.md)&lt;out [T](-autofill-provider/index.md)&gt;<br>Provides a value whenever there is a need to return a *placeholder* of certain type. |
| [CompositeAutofillProvider](-composite-autofill-provider/index.md) | [common]<br>interface [CompositeAutofillProvider](-composite-autofill-provider/index.md) : [AutofillProvider](-autofill-provider/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Provider that allows registering both [types](-composite-autofill-provider/types.md) and [delegates](-composite-autofill-provider/delegates.md). It uses given providers in specified order: |
| [DelegateAutofillProvider](-delegate-autofill-provider/index.md) | [common]<br>interface [DelegateAutofillProvider](-delegate-autofill-provider/index.md)&lt;[T](-delegate-autofill-provider/index.md)&gt; : [AutofillProvider](-autofill-provider/index.md)&lt;[T](-delegate-autofill-provider/index.md)&gt; <br>Provides values based on registered providers. Providers are utilized in order of their registration, starting with the most recent. |
| [TypeRegistryAutofillProvider](-type-registry-autofill-provider/index.md) | [common]<br>interface [TypeRegistryAutofillProvider](-type-registry-autofill-provider/index.md) : [AutofillProvider](-autofill-provider/index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Allows registering value providers for specific types. This provider does not support polymorphism. If you register provider for some interface `A`, it provides a value only for `A::class`. Provider for `AImpl` must be registered separately. |

## Functions

| Name | Summary |
|---|---|
| [getIfProvided](get-if-provided.md) | [common]<br>fun &lt;[T](get-if-provided.md)&gt; [AutofillProvider.Value](-autofill-provider/-value/index.md)&lt;[T](get-if-provided.md)&gt;.[getIfProvided](get-if-provided.md)(): [T](get-if-provided.md)?<br>Returns value if this is an instance of [AutofillProvider.Value.Provided](-autofill-provider/-value/-provided/index.md). |
| [isProvided](is-provided.md) | [common]<br>fun [AutofillProvider.Value](-autofill-provider/-value/index.md)&lt;*&gt;.[isProvided](is-provided.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this is an instance of [AutofillProvider.Value.Provided](-autofill-provider/-value/-provided/index.md) |
| [provideValue](provide-value.md) | [common]<br>inline fun &lt;[T](provide-value.md)&gt; [AutofillProvider](-autofill-provider/index.md)&lt;[T](provide-value.md)&gt;.[provideValue](provide-value.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [T](provide-value.md)?<br>Calls [AutofillProvider.provide](-autofill-provider/provide.md) and returns [AutofillProvider.Value.Provided.value](-autofill-provider/-value/-provided/value.md) if present. |
| [register](register.md) | [common]<br>inline fun &lt;[T](register.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [TypeRegistryAutofillProvider](-type-registry-autofill-provider/index.md).[register](register.md)(noinline provider: () -&gt; [T](register.md)?)<br>Calls [TypeRegistryAutofillProvider.register](-type-registry-autofill-provider/register.md) with type [T](register.md). |
| [unregister](unregister.md) | [common]<br>inline fun &lt;[T](unregister.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [TypeRegistryAutofillProvider](-type-registry-autofill-provider/index.md).[unregister](unregister.md)()<br>Calls [TypeRegistryAutofillProvider.unregister](-type-registry-autofill-provider/unregister.md) with type [T](unregister.md). |
