//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[BlockingAnsweringScope](index.md)

# BlockingAnsweringScope

interface [BlockingAnsweringScope](index.md)&lt;[T](index.md)&gt; : [AnsweringScope](../-answering-scope/index.md)&lt;[T](index.md)&gt; 

Marker interface for defining an answer for non-suspend function call.

#### Inheritors

| |
|---|
| [BlockingSequentialAnswerBuilder](../-blocking-sequential-answer-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [answers](../-answering-scope/answers.md) | [common]<br>@DelicateMokkeryApi<br>abstract infix fun [answers](../-answering-scope/answers.md)(answer: [Answer](../-answer/index.md)&lt;[T](index.md)&gt;)<br>Registers given [answer](../-answering-scope/answers.md) for a function call. Direct usage requires care, because it allows to register suspending answer for non-suspend function. |
| [calls](../calls.md) | [common]<br>infix fun &lt;[T](../calls.md)&gt; [BlockingAnsweringScope](index.md)&lt;[T](../calls.md)&gt;.[calls](../calls.md)(block: ([FunctionScope](../-function-scope/index.md)) -&gt; [T](../calls.md))<br>Function call executes [block](../calls.md). |
| [returns](../returns.md) | [common]<br>infix fun &lt;[T](../returns.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../returns.md)&gt;.[returns](../returns.md)(value: [T](../returns.md))<br>Function call always returns [value](../returns.md). |
| [sequentially](../sequentially.md) | [common]<br>infix fun &lt;[T](../sequentially.md)&gt; [BlockingAnsweringScope](index.md)&lt;[T](../sequentially.md)&gt;.[sequentially](../sequentially.md)(block: [BlockingSequentialAnswerBuilder](../-blocking-sequential-answer-builder/index.md)&lt;[T](../sequentially.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Function call will answer sequentially with answers defined in [block](../sequentially.md). |
| [sequentiallyReturns](../sequentially-returns.md) | [common]<br>infix fun &lt;[T](../sequentially-returns.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../sequentially-returns.md)&gt;.[sequentiallyReturns](../sequentially-returns.md)(values: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[T](../sequentially-returns.md)&gt;)<br>Simplification for [sequentially](../sequentially.md) with multiple [returns](../returns.md) calls. |
| [sequentiallyThrows](../sequentially-throws.md) | [common]<br>infix fun &lt;[T](../sequentially-throws.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../sequentially-throws.md)&gt;.[sequentiallyThrows](../sequentially-throws.md)(errors: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)&gt;)<br>Simplification for [sequentially](../sequentially.md) with multiple [throws](../throws.md) calls. |
| [throws](../throws.md) | [common]<br>infix fun &lt;[T](../throws.md)&gt; [AnsweringScope](../-answering-scope/index.md)&lt;[T](../throws.md)&gt;.[throws](../throws.md)(error: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html))<br>Function call always throws [error](../throws.md). |
