package dev.mokkery.internal.answering

import dev.mokkery.internal.DefaultNothingException
import dev.mokkery.internal.unsafeCast
import kotlin.reflect.KClass

internal expect fun autofillAny(kClass: KClass<*>): Any?

internal fun <T> autofillValue(returnType: KClass<*>): T {
    // don't change this to returnType == Nothing::class
    // it fails when returnType is non-primitive type on jsBrowser (probably a K/JS bug)
    return if (Nothing::class == returnType) {
        throw DefaultNothingException()
    } else {
        (autofillMapping[returnType] ?: autofillAny(returnType)).unsafeCast()
    }
}

@OptIn(ExperimentalUnsignedTypes::class)
internal val autofillMapping = mapOf(
    Byte::class to 0.toByte(),
    UByte::class to 0u.toUByte(),
    Char::class to '0',
    Short::class to 0.toShort(),
    UShort::class to 0.toUShort(),
    Int::class to 0,
    UInt::class to 0u,
    Long::class to 0L,
    ULong::class to 0uL,
    Double::class to 0.0,
    Float::class to 0f,
    Boolean::class to false,
    Unit::class to Unit,
    KClass::class to Any::class,
    String::class to "",
    IntArray::class to intArrayOf(),
    ByteArray::class to byteArrayOf(),
    DoubleArray::class to doubleArrayOf(),
    CharArray::class to charArrayOf(),
    FloatArray::class to floatArrayOf(),
    LongArray::class to longArrayOf(),
    BooleanArray::class to booleanArrayOf(),
    ShortArray::class to shortArrayOf(),
    UIntArray::class to uintArrayOf(),
    UByteArray::class to ubyteArrayOf(),
    ULongArray::class to ulongArrayOf(),
    UShortArray::class to ushortArrayOf()
)
