//[mokkery-runtime](../../index.md)/[dev.mokkery.answering](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [Answer](-answer/index.md) | [common]<br>@DelicateMokkeryApi<br>interface [Answer](-answer/index.md)&lt;out [T](-answer/index.md)&gt;<br>An answer for a function call. For blocking answers only [call](-answer/call.md) implementation is required. For suspending answers [callSuspend](-answer/call-suspend.md) should be implemented and [call](-answer/call.md) implementation should throw an exception. Use [Suspending](-answer/-suspending/index.md) for convenience. |
| [AnsweringScope](-answering-scope/index.md) | [common]<br>interface [AnsweringScope](-answering-scope/index.md)&lt;[T](-answering-scope/index.md)&gt;<br>Scope for defining an answer for a function call. |
| [BlockingAnsweringScope](-blocking-answering-scope/index.md) | [common]<br>interface [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](-blocking-answering-scope/index.md)&gt; : [AnsweringScope](-answering-scope/index.md)&lt;[T](-blocking-answering-scope/index.md)&gt; <br>Marker interface for defining an answer for non-suspend function call. |
| [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md) | [common]<br>interface [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md)&lt;[T](-blocking-sequential-answer-builder/index.md)&gt; : [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](-blocking-sequential-answer-builder/index.md)&gt; , [SequentialAnswerBuilder](-sequential-answer-builder/index.md)&lt;[T](-blocking-sequential-answer-builder/index.md)&gt; <br>Marker interface for sequential answer builder for non-suspend function |
| [FunctionScope](-function-scope/index.md) | [common]<br>class [FunctionScope](-function-scope/index.md)(val returnType: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, val args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;, val self: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?)<br>Provides function call arguments. If function has any extension receiver, it is provided at the beginning of the [args](-function-scope/args.md) list. |
| [SequentialAnswerBuilder](-sequential-answer-builder/index.md) | [common]<br>interface [SequentialAnswerBuilder](-sequential-answer-builder/index.md)&lt;[T](-sequential-answer-builder/index.md)&gt; : [AnsweringScope](-answering-scope/index.md)&lt;[T](-sequential-answer-builder/index.md)&gt; <br>Marker interface for sequential answer builder for any function |
| [SuspendAnsweringScope](-suspend-answering-scope/index.md) | [common]<br>interface [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](-suspend-answering-scope/index.md)&gt; : [AnsweringScope](-answering-scope/index.md)&lt;[T](-suspend-answering-scope/index.md)&gt; <br>Marker interface for defining an answer for suspend function call. |
| [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md) | [common]<br>interface [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md)&lt;[T](-suspend-sequential-answer-builder/index.md)&gt; : [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](-suspend-sequential-answer-builder/index.md)&gt; , [SequentialAnswerBuilder](-sequential-answer-builder/index.md)&lt;[T](-suspend-sequential-answer-builder/index.md)&gt; <br>Marker interface for sequential answer builder for suspend function |

## Functions

| Name | Summary |
|---|---|
| [calls](calls.md) | [common]<br>infix fun &lt;[T](calls.md)&gt; [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](calls.md)&gt;.[calls](calls.md)(block: ([FunctionScope](-function-scope/index.md)) -&gt; [T](calls.md))<br>Function call executes [block](calls.md).<br>[common]<br>infix fun &lt;[T](calls.md)&gt; [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](calls.md)&gt;.[calls](calls.md)(block: suspend ([FunctionScope](-function-scope/index.md)) -&gt; [T](calls.md))<br>Suspend function call executes [block](calls.md). |
| [repeat](repeat.md) | [common]<br>fun &lt;[T](repeat.md)&gt; [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md)&lt;[T](repeat.md)&gt;.[repeat](repeat.md)(block: [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md)&lt;[T](repeat.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>fun &lt;[T](repeat.md)&gt; [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md)&lt;[T](repeat.md)&gt;.[repeat](repeat.md)(block: [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md)&lt;[T](repeat.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>Allows to define a set of answers in [sequentially](sequentially.md) that will repeat in cycles. |
| [returns](returns.md) | [common]<br>infix fun &lt;[T](returns.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](returns.md)&gt;.[returns](returns.md)(value: [T](returns.md))<br>Function call always returns [value](returns.md). |
| [sequentially](sequentially.md) | [common]<br>infix fun &lt;[T](sequentially.md)&gt; [BlockingAnsweringScope](-blocking-answering-scope/index.md)&lt;[T](sequentially.md)&gt;.[sequentially](sequentially.md)(block: [BlockingSequentialAnswerBuilder](-blocking-sequential-answer-builder/index.md)&lt;[T](sequentially.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>infix fun &lt;[T](sequentially.md)&gt; [SuspendAnsweringScope](-suspend-answering-scope/index.md)&lt;[T](sequentially.md)&gt;.[sequentially](sequentially.md)(block: [SuspendSequentialAnswerBuilder](-suspend-sequential-answer-builder/index.md)&lt;[T](sequentially.md)&gt;.() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>Function call will answer sequentially with answers defined in [block](sequentially.md). |
| [sequentiallyReturns](sequentially-returns.md) | [common]<br>infix fun &lt;[T](sequentially-returns.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](sequentially-returns.md)&gt;.[sequentiallyReturns](sequentially-returns.md)(values: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[T](sequentially-returns.md)&gt;)<br>Simplification for [sequentially](sequentially.md) with multiple [returns](returns.md) calls. |
| [sequentiallyThrows](sequentially-throws.md) | [common]<br>infix fun &lt;[T](sequentially-throws.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](sequentially-throws.md)&gt;.[sequentiallyThrows](sequentially-throws.md)(errors: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)&gt;)<br>Simplification for [sequentially](sequentially.md) with multiple [throws](throws.md) calls. |
| [throws](throws.md) | [common]<br>infix fun &lt;[T](throws.md)&gt; [AnsweringScope](-answering-scope/index.md)&lt;[T](throws.md)&gt;.[throws](throws.md)(error: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html))<br>Function call always throws [error](throws.md). |
