//[mokkery-runtime](../../../index.md)/[dev.mokkery.matcher](../index.md)/[ArgMatcher](index.md)

# ArgMatcher

fun interface [ArgMatcher](index.md)&lt;in [T](index.md)&gt;

Checks if given argument satisfies provided conditions.

#### Inheritors

| |
|---|
| [Any](-any/index.md) |
| [Equals](-equals/index.md) |
| [NotEqual](-not-equal/index.md) |
| [EqualsRef](-equals-ref/index.md) |
| [NotEqualRef](-not-equal-ref/index.md) |
| [Matching](-matching/index.md) |
| [Comparing](-comparing/index.md) |
| [OfType](-of-type/index.md) |
| [Composite](-composite/index.md) |
| [ValueInIterable](../../dev.mokkery.matcher.collections/-collection-arg-matchers/-value-in-iterable/index.md) |
| [ValueNotInIterable](../../dev.mokkery.matcher.collections/-collection-arg-matchers/-value-not-in-iterable/index.md) |
| [ContentEquals](../../dev.mokkery.matcher.collections/-collection-arg-matchers/-content-equals/index.md) |
| [ContentDeepEquals](../../dev.mokkery.matcher.collections/-collection-arg-matchers/-content-deep-equals/index.md) |
| [VarArgMatcher](../../dev.mokkery.matcher.varargs/-var-arg-matcher/index.md) |

## Types

| Name | Summary |
|---|---|
| [Any](-any/index.md) | [common]<br>object [Any](-any/index.md) : [ArgMatcher](index.md)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; <br>Matches any argument. |
| [Comparing](-comparing/index.md) | [common]<br>data class [Comparing](-comparing/index.md)&lt;[T](-comparing/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](-comparing/index.md)&gt;&gt;(val value: [T](-comparing/index.md), val type: [ArgMatcher.Comparing.Type](-comparing/-type/index.md)) : [ArgMatcher](index.md)&lt;[T](-comparing/index.md)&gt; <br>Matches any [Comparable](-comparing/value.md) depending on [type](-comparing/type.md) parameter. |
| [Composite](-composite/index.md) | [common]<br>@DelicateMokkeryApi<br>interface [Composite](-composite/index.md)&lt;[T](-composite/index.md)&gt; : [ArgMatcher](index.md)&lt;[T](-composite/index.md)&gt; <br>Arg matcher that must be composed with other matchers. Check existing implementations to learn how to implement it correctly. |
| [Equals](-equals/index.md) | [common]<br>data class [Equals](-equals/index.md)&lt;[T](-equals/index.md)&gt;(val value: [T](-equals/index.md)) : [ArgMatcher](index.md)&lt;[T](-equals/index.md)&gt; <br>Matches an argument that is equal to [value](-equals/value.md). |
| [EqualsRef](-equals-ref/index.md) | [common]<br>data class [EqualsRef](-equals-ref/index.md)&lt;[T](-equals-ref/index.md)&gt;(val value: [T](-equals-ref/index.md)) : [ArgMatcher](index.md)&lt;[T](-equals-ref/index.md)&gt; <br>Matches an argument whose reference is equal to [value](-equals-ref/value.md)'s reference. |
| [Matching](-matching/index.md) | [common]<br>data class [Matching](-matching/index.md)&lt;[T](-matching/index.md)&gt;(val predicate: ([T](-matching/index.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), val toStringFun: () -&gt; [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [ArgMatcher](index.md)&lt;[T](-matching/index.md)&gt; <br>Matches an argument according to the [predicate](-matching/predicate.md). Registered matcher [Any.toString](-any/to-string.md) calls [toStringFun](-matching/to-string-fun.md). |
| [NotEqual](-not-equal/index.md) | [common]<br>data class [NotEqual](-not-equal/index.md)&lt;[T](-not-equal/index.md)&gt;(val value: [T](-not-equal/index.md)) : [ArgMatcher](index.md)&lt;[T](-not-equal/index.md)&gt; <br>Matches an argument that is not equal to [value](-not-equal/value.md). |
| [NotEqualRef](-not-equal-ref/index.md) | [common]<br>data class [NotEqualRef](-not-equal-ref/index.md)&lt;[T](-not-equal-ref/index.md)&gt;(val value: [T](-not-equal-ref/index.md)) : [ArgMatcher](index.md)&lt;[T](-not-equal-ref/index.md)&gt; <br>Matches an argument whose reference is not equal to [value](-not-equal-ref/value.md)'s reference. |
| [OfType](-of-type/index.md) | [common]<br>data class [OfType](-of-type/index.md)&lt;[T](-of-type/index.md)&gt;(val type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;) : [ArgMatcher](index.md)&lt;[T](-of-type/index.md)&gt; <br>Matches an argument that is instance of [type](-of-type/type.md). |

## Functions

| Name | Summary |
|---|---|
| [matches](matches.md) | [common]<br>abstract fun [matches](matches.md)(arg: [T](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
