/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.tracing;

import dev.mokkery.internal.UtilsKt;
import dev.mokkery.internal.tracing.CallArg;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ldev/mokkery/internal/tracing/CallTrace;", "", "receiver", "", "name", "args", "", "Ldev/mokkery/internal/tracing/CallArg;", "orderStamp", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;J)V", "getReceiver", "()Ljava/lang/String;", "getName", "getArgs", "()Ljava/util/List;", "getOrderStamp", "()J", "toString", "toStringNoReceiver", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "mokkery-runtime"})
public final class CallTrace {
    @NotNull
    private final String receiver;
    @NotNull
    private final String name;
    @NotNull
    private final List<CallArg> args;
    private final long orderStamp;

    public CallTrace(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args, long orderStamp) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.receiver = receiver;
        this.name = name;
        this.args = args;
        this.orderStamp = orderStamp;
    }

    @NotNull
    public final String getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CallArg> getArgs() {
        return this.args;
    }

    public final long getOrderStamp() {
        return this.orderStamp;
    }

    @NotNull
    public String toString() {
        return UtilsKt.callToString(this.receiver, this.name, this.args);
    }

    @NotNull
    public final String toStringNoReceiver() {
        return UtilsKt.callFunctionToString(this.name, this.args);
    }

    @NotNull
    public final String component1() {
        return this.receiver;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final List<CallArg> component3() {
        return this.args;
    }

    public final long component4() {
        return this.orderStamp;
    }

    @NotNull
    public final CallTrace copy(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args, long orderStamp) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new CallTrace(receiver, name, args, orderStamp);
    }

    public static /* synthetic */ CallTrace copy$default(CallTrace callTrace, String string, String string2, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = callTrace.receiver;
        }
        if ((n & 2) != 0) {
            string2 = callTrace.name;
        }
        if ((n & 4) != 0) {
            list = callTrace.args;
        }
        if ((n & 8) != 0) {
            l = callTrace.orderStamp;
        }
        return callTrace.copy(string, string2, list, l);
    }

    public int hashCode() {
        int result = this.receiver.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        result = result * 31 + Long.hashCode(this.orderStamp);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallTrace)) {
            return false;
        }
        CallTrace callTrace = (CallTrace)other;
        if (!Intrinsics.areEqual((Object)this.receiver, (Object)callTrace.receiver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)callTrace.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.args, callTrace.args)) {
            return false;
        }
        return this.orderStamp == callTrace.orderStamp;
    }
}

