/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.matcher;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.internal.JvmUtilsKt;
import dev.mokkery.internal.UtilsKt;
import dev.mokkery.matcher.capture.Capture;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u00e6\u0080\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u0002:\t\u0007\b\t\n\u000b\f\r\u000e\u000fJ\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldev/mokkery/matcher/ArgMatcher;", "T", "", "matches", "", "arg", "(Ljava/lang/Object;)Z", "Any", "Equals", "NotEqual", "EqualsRef", "NotEqualRef", "Matching", "Comparing", "OfType", "Composite", "mokkery-runtime"})
public interface ArgMatcher<T> {
    public boolean matches(T var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Any;", "Ldev/mokkery/matcher/ArgMatcher;", "", "<init>", "()V", "matches", "", "arg", "toString", "", "mokkery-runtime"})
    public static final class Any
    implements ArgMatcher<Object> {
        @NotNull
        public static final Any INSTANCE = new Any();

        private Any() {
        }

        @Override
        public boolean matches(@Nullable Object arg) {
            return true;
        }

        @NotNull
        public String toString() {
            return "any()";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Comparing;", "T", "", "Ldev/mokkery/matcher/ArgMatcher;", "value", "type", "Ldev/mokkery/matcher/ArgMatcher$Comparing$Type;", "<init>", "(Ljava/lang/Comparable;Ldev/mokkery/matcher/ArgMatcher$Comparing$Type;)V", "getValue", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "getType", "()Ldev/mokkery/matcher/ArgMatcher$Comparing$Type;", "matches", "", "arg", "(Ljava/lang/Comparable;)Z", "toString", "", "equals", "other", "", "hashCode", "", "Type", "mokkery-runtime"})
    public static final class Comparing<T extends Comparable<? super T>>
    implements ArgMatcher<T> {
        @NotNull
        private final T value;
        @NotNull
        private final Type type;

        public Comparing(@NotNull T value, @NotNull Type type) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.value = value;
            this.type = type;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @Override
        public boolean matches(@NotNull T arg) {
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            return (Boolean)this.type.getCompare().invoke((Object)arg.compareTo(this.value));
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.type.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return stringBuilder.append(string).append('(').append(UtilsKt.description(this.value)).append(')').toString();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Comparing cfr_ignored_0 = (Comparing)other;
            if (!Intrinsics.areEqual(this.value, ((Comparing)other).value)) {
                return false;
            }
            return this.type == ((Comparing)other).type;
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Comparing$Type;", "", "compare", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getCompare", "()Lkotlin/jvm/functions/Function1;", "Eq", "Lt", "Lte", "Gt", "Gte", "mokkery-runtime"})
        public static final class Type
        extends Enum<Type> {
            @NotNull
            private final Function1<Integer, Boolean> compare;
            public static final /* enum */ Type Eq = new Type((Function1<? super Integer, Boolean>)((Function1)Type::_init_$lambda$0));
            public static final /* enum */ Type Lt = new Type((Function1<? super Integer, Boolean>)((Function1)Type::_init_$lambda$1));
            public static final /* enum */ Type Lte = new Type((Function1<? super Integer, Boolean>)((Function1)Type::_init_$lambda$2));
            public static final /* enum */ Type Gt = new Type((Function1<? super Integer, Boolean>)((Function1)Type::_init_$lambda$3));
            public static final /* enum */ Type Gte = new Type((Function1<? super Integer, Boolean>)((Function1)Type::_init_$lambda$4));
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(Function1<? super Integer, Boolean> compare) {
                this.compare = compare;
            }

            @NotNull
            public final Function1<Integer, Boolean> getCompare() {
                return this.compare;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            private static final boolean _init_$lambda$0(int it) {
                return it == 0;
            }

            private static final boolean _init_$lambda$1(int it) {
                return it < 0;
            }

            private static final boolean _init_$lambda$2(int it) {
                return it <= 0;
            }

            private static final boolean _init_$lambda$3(int it) {
                return it > 0;
            }

            private static final boolean _init_$lambda$4(int it) {
                return it >= 0;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.Eq, Type.Lt, Type.Lte, Type.Gt, Type.Gte};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bg\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Composite;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "Ldev/mokkery/matcher/capture/Capture;", "compose", "matcher", "isFilled", "", "assertFilled", "", "capture", "value", "(Ljava/lang/Object;)V", "mokkery-runtime"})
    @DelicateMokkeryApi
    public static interface Composite<T>
    extends ArgMatcher<T>,
    Capture<T> {
        @NotNull
        public Composite<T> compose(@NotNull ArgMatcher<? super T> var1);

        public boolean isFilled();

        public void assertFilled();

        @Override
        public void capture(T var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Equals;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "matches", "", "arg", "(Ljava/lang/Object;)Z", "toString", "", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class Equals<T>
    implements ArgMatcher<T> {
        private final T value;

        public Equals(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public boolean matches(T arg) {
            return Intrinsics.areEqual(arg, this.value);
        }

        @NotNull
        public String toString() {
            return UtilsKt.description(this.value);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Equals cfr_ignored_0 = (Equals)other;
            return Intrinsics.areEqual(this.value, ((Equals)other).value);
        }

        public int hashCode() {
            T t = this.value;
            return t != null ? t.hashCode() : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/ArgMatcher$EqualsRef;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "matches", "", "arg", "(Ljava/lang/Object;)Z", "toString", "", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class EqualsRef<T>
    implements ArgMatcher<T> {
        private final T value;

        public EqualsRef(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public boolean matches(T arg) {
            return arg == this.value;
        }

        @NotNull
        public String toString() {
            return "eqRef(" + UtilsKt.description(this.value) + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Equals cfr_ignored_0 = (Equals)other;
            return this.value == ((Equals)other).getValue();
        }

        public int hashCode() {
            T t = this.value;
            return t != null ? t.hashCode() : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Ldev/mokkery/matcher/ArgMatcher$Matching;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "predicate", "Lkotlin/Function1;", "", "toStringFun", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getPredicate", "()Lkotlin/jvm/functions/Function1;", "getToStringFun", "()Lkotlin/jvm/functions/Function0;", "matches", "arg", "(Ljava/lang/Object;)Z", "toString", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class Matching<T>
    implements ArgMatcher<T> {
        @NotNull
        private final Function1<T, Boolean> predicate;
        @NotNull
        private final Function0<String> toStringFun;

        public Matching(@NotNull Function1<? super T, Boolean> predicate, @NotNull Function0<String> toStringFun) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter(toStringFun, (String)"toStringFun");
            this.predicate = predicate;
            this.toStringFun = toStringFun;
        }

        @NotNull
        public final Function1<T, Boolean> getPredicate() {
            return this.predicate;
        }

        @NotNull
        public final Function0<String> getToStringFun() {
            return this.toStringFun;
        }

        @Override
        public boolean matches(T arg) {
            return (Boolean)this.predicate.invoke(arg);
        }

        @NotNull
        public String toString() {
            return (String)this.toStringFun.invoke();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Matching cfr_ignored_0 = (Matching)other;
            if (!Intrinsics.areEqual(this.predicate, ((Matching)other).predicate)) {
                return false;
            }
            return Intrinsics.areEqual(this.toStringFun, ((Matching)other).toStringFun);
        }

        public int hashCode() {
            int result = this.predicate.hashCode();
            result = 31 * result + this.toStringFun.hashCode();
            return result;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/ArgMatcher$NotEqual;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "matches", "", "arg", "(Ljava/lang/Object;)Z", "toString", "", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class NotEqual<T>
    implements ArgMatcher<T> {
        private final T value;

        public NotEqual(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public boolean matches(T arg) {
            return !Intrinsics.areEqual(arg, this.value);
        }

        @NotNull
        public String toString() {
            return "neq(" + UtilsKt.description(this.value) + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Equals cfr_ignored_0 = (Equals)other;
            return Intrinsics.areEqual(this.value, ((Equals)other).getValue());
        }

        public int hashCode() {
            T t = this.value;
            return t != null ? t.hashCode() : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/ArgMatcher$NotEqualRef;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "matches", "", "arg", "(Ljava/lang/Object;)Z", "toString", "", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class NotEqualRef<T>
    implements ArgMatcher<T> {
        private final T value;

        public NotEqualRef(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        @Override
        public boolean matches(T arg) {
            return arg != this.value;
        }

        @NotNull
        public String toString() {
            return "neqRef(" + UtilsKt.description(this.value) + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Equals cfr_ignored_0 = (Equals)other;
            return this.value == ((Equals)other).getValue();
        }

        public int hashCode() {
            T t = this.value;
            return t != null ? t.hashCode() : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/ArgMatcher$OfType;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "type", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "getType", "()Lkotlin/reflect/KClass;", "matches", "", "arg", "(Ljava/lang/Object;)Z", "toString", "", "equals", "other", "", "hashCode", "", "mokkery-runtime"})
    public static final class OfType<T>
    implements ArgMatcher<T> {
        @NotNull
        private final KClass<?> type;

        public OfType(@NotNull KClass<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final KClass<?> getType() {
            return this.type;
        }

        @Override
        public boolean matches(T arg) {
            return this.type.isInstance(arg);
        }

        @NotNull
        public String toString() {
            return "ofType<" + JvmUtilsKt.bestName(this.type) + ">()";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            OfType cfr_ignored_0 = (OfType)other;
            return Intrinsics.areEqual(this.type, ((OfType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

