/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.matcher.collections;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.matcher.ArgMatcher;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Ldev/mokkery/matcher/collections/CollectionArgMatchers;", "", "()V", "ContentDeepEquals", "ContentEquals", "ValueInIterable", "ValueNotInIterable", "mokkery-runtime"})
public final class CollectionArgMatchers {
    @NotNull
    public static final CollectionArgMatchers INSTANCE = new CollectionArgMatchers();

    private CollectionArgMatchers() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001b\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ldev/mokkery/matcher/collections/CollectionArgMatchers$ContentDeepEquals;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "", "array", "([Ljava/lang/Object;)V", "getArray", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "matches", "arg", "([Ljava/lang/Object;)Z", "toString", "", "mokkery-runtime"})
    public static final class ContentDeepEquals<T>
    implements ArgMatcher<T[]> {
        @NotNull
        private final T[] array;

        public ContentDeepEquals(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.array = array;
        }

        @NotNull
        public final T[] getArray() {
            return this.array;
        }

        @Override
        public boolean matches(@NotNull T[] arg) {
            Intrinsics.checkNotNullParameter(arg, (String)"arg");
            Object[] objectArray = arg;
            Object[] objectArray2 = this.array;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])objectArray2);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ContentDeepEquals cfr_ignored_0 = (ContentDeepEquals)other;
            return Arrays.equals(this.array, ((ContentDeepEquals)other).array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("contentDeepEq(");
            List list = ArrayUtilsKt.asListOrNull(this.array);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/mokkery/matcher/collections/CollectionArgMatchers$ContentEquals;", "Ldev/mokkery/matcher/ArgMatcher;", "", "array", "(Ljava/lang/Object;)V", "elements", "", "matches", "", "arg", "toString", "", "mokkery-runtime"})
    @DelicateMokkeryApi
    public static final class ContentEquals
    implements ArgMatcher<Object> {
        @NotNull
        private final Object array;
        @NotNull
        private final List<Object> elements;

        public ContentEquals(@NotNull Object array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
            List<Object> list = ArrayUtilsKt.asListOrNull(this.array);
            if (list == null) {
                ContentEquals contentEquals = this;
                boolean bl = false;
                ContentEquals contentEquals2 = contentEquals;
                String string = "ContentEquals expects array but received " + this.array + '!';
                throw new IllegalArgumentException(string.toString());
            }
            this.elements = list;
        }

        @Override
        public boolean matches(@NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            List<Object> list = ArrayUtilsKt.asListOrNull(arg);
            if (list == null) {
                return false;
            }
            List<Object> actual = list;
            return Intrinsics.areEqual(actual, this.elements);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("contentEq(");
            List list = ArrayUtilsKt.asListOrNull(this.array);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ldev/mokkery/matcher/collections/CollectionArgMatchers$ValueInIterable;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "iterable", "", "(Ljava/lang/Iterable;)V", "getIterable", "()Ljava/lang/Iterable;", "equals", "", "other", "", "hashCode", "", "matches", "arg", "(Ljava/lang/Object;)Z", "toString", "", "mokkery-runtime"})
    public static final class ValueInIterable<T>
    implements ArgMatcher<T> {
        @NotNull
        private final Iterable<T> iterable;

        public ValueInIterable(@NotNull Iterable<? extends T> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            this.iterable = iterable;
        }

        @NotNull
        public final Iterable<T> getIterable() {
            return this.iterable;
        }

        @Override
        public boolean matches(T arg) {
            return CollectionsKt.contains(this.iterable, arg);
        }

        @NotNull
        public String toString() {
            return "isIn(" + CollectionsKt.joinToString$default(this.iterable, null, null, null, (int)0, null, null, (int)63, null) + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ValueInIterable cfr_ignored_0 = (ValueInIterable)other;
            return Intrinsics.areEqual(this.iterable, ((ValueInIterable)other).iterable);
        }

        public int hashCode() {
            return this.iterable.hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ldev/mokkery/matcher/collections/CollectionArgMatchers$ValueNotInIterable;", "T", "Ldev/mokkery/matcher/ArgMatcher;", "iterable", "", "(Ljava/lang/Iterable;)V", "getIterable", "()Ljava/lang/Iterable;", "equals", "", "other", "", "hashCode", "", "matches", "arg", "(Ljava/lang/Object;)Z", "toString", "", "mokkery-runtime"})
    public static final class ValueNotInIterable<T>
    implements ArgMatcher<T> {
        @NotNull
        private final Iterable<T> iterable;

        public ValueNotInIterable(@NotNull Iterable<? extends T> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            this.iterable = iterable;
        }

        @NotNull
        public final Iterable<T> getIterable() {
            return this.iterable;
        }

        @Override
        public boolean matches(T arg) {
            return !CollectionsKt.contains(this.iterable, arg);
        }

        @NotNull
        public String toString() {
            return "isNotIn(" + CollectionsKt.joinToString$default(this.iterable, null, null, null, (int)0, null, null, (int)63, null) + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ValueNotInIterable cfr_ignored_0 = (ValueNotInIterable)other;
            return Intrinsics.areEqual(this.iterable, ((ValueNotInIterable)other).iterable);
        }

        public int hashCode() {
            return this.iterable.hashCode();
        }
    }
}

